/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.math;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.math.Interpolator;
import dk.progressivemedia.skeleton.math.MathUtil;

public class InterpolatorSpring
extends Interpolator {
    public static final int DEFAULT_STIFFNESS = 16000;
    public static final int DEFAULT_DAMPING = 13000;
    public static final int DEFAULT_MAX_VELOCITY = 5500000;
    private static final int REST_VELOCITY = 1000;
    private static final int MAX_DELTA_TIME = 17;
    private static final int MAX_INTERATIONS = 8;
    private int mTargetX = 0;
    private int mTargetY = 0;
    private int mOffsetX = 0;
    private int mOffsetY = 0;
    private int mVelocityX = 0;
    private int mVelocityY = 0;
    private int mStiffness = 16000;
    private int mDamping = 13000;
    private int mMaxVelocity = 5500000;

    public void update(int n) {
        int n2 = 1;
        if (n >= 34 && (n2 = n / 17) > 8) {
            n2 = 8;
        }
        while (n2 > 0) {
            this.mVelocityX += PMMath.MUL(-this.mOffsetX, this.mStiffness);
            this.mVelocityY += PMMath.MUL(-this.mOffsetY, this.mStiffness);
            this.mVelocityX -= PMMath.MUL(this.mVelocityX, this.mDamping);
            this.mVelocityY -= PMMath.MUL(this.mVelocityY, this.mDamping);
            this.mVelocityX = MathUtil.clamp(this.mVelocityX, -this.mMaxVelocity, this.mMaxVelocity);
            this.mVelocityY = MathUtil.clamp(this.mVelocityY, -this.mMaxVelocity, this.mMaxVelocity);
            this.mOffsetX += (this.mVelocityX << 6) / 33 * n >> 6;
            this.mOffsetY += (this.mVelocityY << 6) / 33 * n >> 6;
            --n2;
        }
        if (this.isDone()) {
            this.mOffsetX = 0;
            this.mOffsetY = 0;
        }
    }

    public boolean isDone() {
        return MathUtil.abs(this.mVelocityX) < 1000 && MathUtil.abs(this.mVelocityY) < 1000;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.mTargetX = n3;
        this.mTargetY = n4;
        this.mOffsetX = n - n3;
        this.mOffsetY = n2 - n4;
    }

    public int getX() {
        return this.mTargetX + this.mOffsetX;
    }

    public int getY() {
        return this.mTargetY + this.mOffsetY;
    }

    public void setStiffness(int n) {
        this.mStiffness = n;
    }

    public void setDamping(int n) {
        this.mDamping = n;
    }

    public void setMaxVelocity(int n) {
        this.mMaxVelocity = n;
    }
}

