/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMLocale;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.SaveGameHelper;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.TransitionEffect;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.script.Script;

public class StateSlotSelection {
    private static int[] mBarImgs = new int[]{1106, 1107, 1108, 1109, 1110};
    private static final int NUM_SELECT_BUTTONS = 6;
    private static final int BUTTON_PLAY1 = 0;
    private static final int BUTTON_PLAY2 = 1;
    private static final int BUTTON_PLAY3 = 2;
    private static final int BUTTON_DELETE1 = 3;
    private static final int BUTTON_DELETE2 = 4;
    private static final int BUTTON_DELETE3 = 5;
    private static final int NUM_DELETE_BUTTONS = 2;
    private static final int BUTTON_CONFIRM = 0;
    private static final int BUTTON_BACK = 1;
    private static int[] mSelectButtonCoords = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static int[] mDeleteButtonCoords = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static int[] mSelectButtonIDs = new int[]{0, 3, 1, 4, 2, 5};
    private static int[] mDeleteButtonIDs = new int[]{0, 1};
    private static final int STATE_SWIPE_IN = 0;
    private static final int STATE_SLOT_SELECT = 1;
    private static final int STATE_OUTRO = 2;
    private static final int STATE_SWIPE_OUT = 3;
    private static int mState = 0;
    private static final int NUM_SLOTS = 3;
    private static final int SLOT_STATE_IDLE = 0;
    private static final int SLOT_STATE_MOVING_OUT = 1;
    private static final int SLOT_STATE_EXPANDED = 2;
    private static final int SLOT_STATE_MOVING_IN = 3;
    private static int mSlotState = 0;
    private static int mSlotWidth;
    private static int mSlotHeight;
    private static final int SLOT_DELETE_WIDTH = 86;
    private static final int SLOT_DELETE_HEIGHT = 77;
    private static final int SLOT_Y_POS = 74;
    private static final int SLOT_SPACING = 10;
    private static final int SLOT_ID_SIZE_X = 82;
    private static final int TEXT_OFFSET_Y = 30;
    private static final int LIVES_SPACING = 70;
    private static final int DELETE_GAME_TEXT_OFFSET_Y = 200;
    private static final int CONFIRM_BUTTONS_OFFSET_Y = 320;
    private static final int CONFIRM_BUTTONS_SPACING_X = 100;
    private static final int CONFIRM_BUTTON_WIDTH = 97;
    private static final int CONFIRM_BUTTON_HEIGHT = 78;
    private static final int PRESSED_OFFSET = 2;
    private static int mSelectedSlot;
    private static boolean mSlotsInUse;
    private static int[] mSlotCorrectPosX;
    private static int[] mSlotCorrectPosY;
    private static int[] mSlotPosX;
    private static int[] mSlotPosY;
    private static int[] mSlotOffsetX;
    private static int[] mSlotOffsetY;
    private static int[] mSlotDeltaPosX;
    private static int[] mSlotDeltaPosY;
    private static int mInterp;
    private static boolean[] mSlotPressed;
    private static boolean[] mDeletePressed;
    private static boolean mYesPressed;
    private static boolean mNoPressed;
    private static String mTextNewgame;
    private static String mTextDeleteGame;
    private static String mTextYes;
    private static String mTextNo;
    private static String[] mTextProgression;
    private static String[] mTextLives;
    private static int[] mTextProgressionWidth;
    private static int[] mProgressionWidth;
    private static short[] mScriptIDs;
    private static boolean mFromGame;
    private static Script mActiveScript;
    private static Script[] mScripts;

    public static void init(int n) {
        int n2;
        Main.counter = 0;
        PMFile.loadScreen = true;
        PMImageManager.load(1104, 9);
        PMImageManager.load(23);
        mSlotWidth = PMImageManager.getWidth(mBarImgs[PMLocale.get()]);
        mSlotHeight = PMImageManager.getHeight(mBarImgs[PMLocale.get()]);
        mFromGame = n != 0;
        TransitionEffect.init(false);
        mState = 0;
        mTextNewgame = PMText.getText(327680);
        mTextDeleteGame = PMText.getText(327682);
        mTextYes = PMText.getText(327683);
        mTextNo = PMText.getText(327684);
        mTextProgression = new String[3];
        mTextLives = new String[3];
        mTextProgressionWidth = new int[3];
        mProgressionWidth = new int[3];
        for (n2 = 0; n2 < 3; ++n2) {
            int n3 = SaveGameHelper.slotLevel(n2);
            if (n3 >= 23) {
                n3 = 22;
            }
            int n4 = Defines.mWorldLookup[n3];
            n3 = Defines.mLevelLookup[n3];
            StateSlotSelection.mTextProgression[n2] = "" + ++n4 + "-" + ++n3;
            StateSlotSelection.mTextLives[n2] = "" + SaveGameHelper.slotLives(n2);
            StateSlotSelection.mTextProgressionWidth[n2] = PMFont.stringWidth(mTextProgression[n2], 0);
            StateSlotSelection.mProgressionWidth[n2] = mTextProgressionWidth[n2] + PMFont.stringWidth(mTextLives[n2], 0) + 70 + 26 + 36;
        }
        StateSlotSelection.calculateCorrectPositions();
        mSelectedSlot = -1;
        mSlotState = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            StateSlotSelection.mSlotPosX[n2] = mSlotCorrectPosX[n2];
            StateSlotSelection.mSlotPosY[n2] = mSlotCorrectPosY[n2];
            StateSlotSelection.mSlotDeltaPosX[n2] = 0;
            StateSlotSelection.mSlotDeltaPosY[n2] = 0;
            StateSlotSelection.mSlotOffsetX[n2] = 0;
            StateSlotSelection.mSlotOffsetY[n2] = 0;
            StateSlotSelection.mSlotPressed[n2] = false;
            StateSlotSelection.mDeletePressed[n2] = false;
        }
        mYesPressed = false;
        mNoPressed = false;
        mInterp = 0;
        mActiveScript = null;
        mScripts = new Script[mScriptIDs.length];
        for (n2 = 0; n2 < mScriptIDs.length; ++n2) {
            StateSlotSelection.mScripts[n2] = Script.load(mScriptIDs[n2]);
        }
        Timer.initTimer();
        Dialog.init(1, 0);
        StateSlotSelection.calculateOverlay();
        PMAudio.load(42, "sfxMainMenuDelete", 6, 10428);
        PMAudio.load(39, "sfxMainMenuNew", 6, 980);
        PMAudio.load(36, "sfxMainMenuLoad", 6, 11812);
        PMFile.loadScreen = false;
    }

    public static void deinit() {
        for (int i = 0; i < mScripts.length; ++i) {
            Script cfr_ignored_0 = mScripts[i];
            Script.unload();
            StateSlotSelection.mScripts[i] = null;
        }
        mScripts = null;
        Dialog.deinit();
        PMAudio.deInitAudio();
        PMImageManager.unloadAll();
        Main.counter = 0;
    }

    private static void handleInput() {
        switch (mSlotState) {
            case 0: {
                if (Dialog.isActive()) break;
                boolean bl = false;
                boolean bl2 = false;
                mYesPressed = Touch.isDown(0);
                mNoPressed = Touch.isDown(1);
                StateSlotSelection.mSlotPressed[0] = Touch.isDown(0);
                StateSlotSelection.mSlotPressed[1] = Touch.isDown(1);
                StateSlotSelection.mSlotPressed[2] = Touch.isDown(2);
                StateSlotSelection.mDeletePressed[0] = Touch.isDown(3);
                StateSlotSelection.mDeletePressed[1] = Touch.isDown(4);
                boolean bl3 = StateSlotSelection.mDeletePressed[2] = Touch.isDown(5);
                if (Touch.wasReleased(0) || Touch.isPressed(0) || Touch.wasReleased(1) || Touch.isPressed(1) || Touch.wasReleased(2) || Touch.isPressed(2)) {
                    if (Touch.wasReleased(0) || Touch.isPressed(0)) {
                        mSelectedSlot = 0;
                    } else if (Touch.wasReleased(1) || Touch.isPressed(1)) {
                        mSelectedSlot = 1;
                    } else if (Touch.wasReleased(2) || Touch.isPressed(2)) {
                        mSelectedSlot = 2;
                    }
                    bl = true;
                } else if (Touch.wasReleased(3) || Touch.isPressed(3) || Touch.wasReleased(4) || Touch.isPressed(4) || Touch.wasReleased(5) || Touch.isPressed(5)) {
                    if (Touch.wasReleased(3) || Touch.isPressed(3)) {
                        mSelectedSlot = 0;
                    } else if (Touch.wasReleased(4) || Touch.isPressed(4)) {
                        mSelectedSlot = 1;
                    } else if (Touch.wasReleased(5) || Touch.isPressed(5)) {
                        mSelectedSlot = 2;
                    }
                    bl2 = true;
                }
                if (bl) {
                    StateSlotSelection.stopScript();
                    if (SaveGameHelper.slotInUse(mSelectedSlot)) {
                        SoundBuffer.play(39, 500);
                        mActiveScript = mScripts[3];
                        mActiveScript.rewind();
                    } else {
                        SoundBuffer.play(36, 500);
                        mActiveScript = mScripts[2];
                        mActiveScript.rewind();
                    }
                    mState = 2;
                    break;
                }
                if (!bl2) break;
                for (int i = 0; i < 3; ++i) {
                    StateSlotSelection.mSlotOffsetX[i] = 0;
                    StateSlotSelection.mSlotOffsetY[i] = 0;
                    if (i == mSelectedSlot) {
                        StateSlotSelection.mSlotDeltaPosX[i] = mSlotPosX[0] - mSlotPosX[i];
                        StateSlotSelection.mSlotDeltaPosY[i] = mSlotPosY[0] - mSlotPosY[i];
                        continue;
                    }
                    StateSlotSelection.mSlotDeltaPosX[i] = 640;
                    StateSlotSelection.mSlotDeltaPosY[i] = 0;
                }
                mInterp = 0;
                mSlotState = 1;
                SoundBuffer.play(42, 500);
                break;
            }
            case 2: {
                StateSlotSelection.mSlotPressed[0] = Touch.isDown(0);
                StateSlotSelection.mSlotPressed[1] = Touch.isDown(1);
                StateSlotSelection.mSlotPressed[2] = Touch.isDown(2);
                StateSlotSelection.mDeletePressed[0] = Touch.isDown(3);
                StateSlotSelection.mDeletePressed[1] = Touch.isDown(4);
                boolean bl = StateSlotSelection.mDeletePressed[2] = Touch.isDown(5);
                if (Dialog.isActive()) break;
                boolean bl4 = false;
                boolean bl5 = false;
                mYesPressed = Touch.isDown(0);
                boolean bl6 = mNoPressed = Touch.isDown(1);
                if (Touch.wasReleased(0) || Touch.isPressed(0)) {
                    bl5 = true;
                } else if (Touch.wasReleased(1) || Touch.isPressed(1)) {
                    bl4 = true;
                } else if (InputProxy.isPressedCancel()) {
                    bl4 = true;
                }
                if (bl5) {
                    StateSlotSelection.stopScript();
                    SaveGameHelper.deleteSlot(mSelectedSlot);
                    StateSlotSelection.calculateCorrectPositions();
                    for (int i = 0; i < 3; ++i) {
                        StateSlotSelection.mSlotOffsetX[i] = 0;
                        StateSlotSelection.mSlotOffsetY[i] = 0;
                        StateSlotSelection.mSlotDeltaPosX[i] = mSlotCorrectPosX[i] - mSlotPosX[i];
                        StateSlotSelection.mSlotDeltaPosY[i] = mSlotCorrectPosY[i] - mSlotPosY[i];
                    }
                    mInterp = 0;
                    mSlotState = 3;
                    SoundBuffer.play(42, 500);
                    break;
                }
                if (!bl4) break;
                StateSlotSelection.stopScript();
                for (int i = 0; i < 3; ++i) {
                    StateSlotSelection.mSlotOffsetX[i] = 0;
                    StateSlotSelection.mSlotOffsetY[i] = 0;
                    StateSlotSelection.mSlotDeltaPosX[i] = mSlotCorrectPosX[i] - mSlotPosX[i];
                    StateSlotSelection.mSlotDeltaPosY[i] = mSlotCorrectPosY[i] - mSlotPosY[i];
                }
                mInterp = 0;
                mSlotState = 3;
                SoundBuffer.play(42, 500);
            }
        }
    }

    private static void draw() {
        int n;
        int n2;
        int n3 = 65536;
        PMImageManager.draw(1105, 0, 0, false, 0, 255, n3, 65536);
        if (PMStateManager.currentState == 1) {
            n2 = 0;
            n = 288;
            PMImageManager.draw(23, 36, 324);
        }
        block4: for (n2 = 0; n2 < 3; ++n2) {
            int n4;
            int n5;
            n = mSlotPosX[n2] + mSlotOffsetX[n2] + (mSlotPressed[n2] ? 2 : 0);
            int n6 = mSlotPosY[n2] + mSlotOffsetY[n2] + (mSlotPressed[n2] ? 2 : 0);
            int n7 = 65536;
            PMImageManager.draw(mBarImgs[PMLocale.get()], n, n6, n7);
            int n8 = (n -= mSlotWidth >> 1) + 41;
            int n9 = n6 - 30;
            PMCanvas.PMGraphics_drawString(n8, n9, "" + (n2 + 1), 0);
            if (SaveGameHelper.slotInUse(n2)) {
                n5 = n + 82 + ((mSlotWidth - 82 >> 1) - (mProgressionWidth[n2] >> 1));
                n4 = n6;
                PMCanvas.PMGraphics_drawString(n5, n4 - 30, mTextProgression[n2], 0);
                PMImageManager.draw(479, n5 += mTextProgressionWidth[n2] + 70, n4);
                PMImageManager.draw(484, n5 += 18, n4);
                PMCanvas.PMGraphics_drawString(n5 += 26, n4 - 30, mTextLives[n2], 0);
            } else {
                PMCanvas.PMGraphics_drawString(n + 82, n6 - 30, mTextNewgame, 0);
            }
            switch (mSlotState) {
                case 0: {
                    if (!SaveGameHelper.slotInUse(n2)) continue block4;
                    n5 = mSlotPosX[n2] + mSlotOffsetX[n2] + (mSlotWidth >> 1) + 43;
                    n4 = mSlotPosY[n2] + mSlotOffsetY[n2];
                    PMImageManager.draw(1112, n5 += mDeletePressed[n2] ? 2 : 0, n4 += mDeletePressed[n2] ? 2 : 0);
                    continue block4;
                }
                case 2: {
                    n5 = 320;
                    n4 = n5 - (PMFont.stringWidth(mTextDeleteGame, 0) >> 1);
                    int n10 = n5 - 100 + (mYesPressed ? 2 : 0);
                    int n11 = 320 + (mYesPressed ? 2 : 0);
                    int n12 = n5 + 100 + (mNoPressed ? 2 : 0);
                    int n13 = 320 + (mNoPressed ? 2 : 0);
                    int n14 = 65536;
                    int n15 = 65536;
                    PMCanvas.PMGraphics_drawString(n4, 200, mTextDeleteGame, 0);
                    PMImageManager.draw(1111, n10, n11, n14);
                    PMCanvas.PMGraphics_drawString(n10 - (PMFont.stringWidth(mTextYes, 0) >> 1), n11 - 30, mTextYes, 0);
                    PMImageManager.draw(1111, n12, n13, n15);
                    PMCanvas.PMGraphics_drawString(n12 - (PMFont.stringWidth(mTextNo, 0) >> 1), n13 - 30, mTextNo, 0);
                }
            }
        }
        Dialog.draw();
    }

    public static void update() {
        Timer.updateTimer();
        StateSlotSelection.draw();
        switch (mState) {
            case 0: {
                if (TransitionEffect.update()) {
                    if (!mFromGame) {
                        mActiveScript = mSlotsInUse ? mScripts[1] : mScripts[0];
                        mActiveScript.rewind();
                    }
                    Touch.init(6, mSelectButtonCoords, mSelectButtonIDs, false);
                    mState = 1;
                }
                TransitionEffect.draw();
                break;
            }
            case 1: {
                if (mActiveScript != null && mActiveScript.update(Timer.mDt)) {
                    mActiveScript = null;
                }
                Dialog.update();
                switch (mSlotState) {
                    case 1: {
                        if ((mInterp += 5957 * Timer.mDt >> 6) >= 65536) {
                            StateSlotSelection.stopScript();
                            for (int i = 0; i < 3; ++i) {
                                int n = i;
                                mSlotPosX[n] = mSlotPosX[n] + mSlotOffsetX[i];
                                int n2 = i;
                                mSlotPosY[n2] = mSlotPosY[n2] + mSlotOffsetY[i];
                                StateSlotSelection.mSlotOffsetX[i] = 0;
                                StateSlotSelection.mSlotOffsetY[i] = 0;
                            }
                            mSlotState = 2;
                            Touch.init(2, mDeleteButtonCoords, mDeleteButtonIDs, false);
                            break;
                        }
                        StateSlotSelection.updateMoveAnimation();
                        break;
                    }
                    case 3: {
                        if ((mInterp += 5957 * Timer.mDt >> 6) >= 65536) {
                            mSlotState = 0;
                            mSelectedSlot = -1;
                            for (int i = 0; i < 3; ++i) {
                                int n = i;
                                mSlotPosX[n] = mSlotPosX[n] + mSlotOffsetX[i];
                                int n3 = i;
                                mSlotPosY[n3] = mSlotPosY[n3] + mSlotOffsetY[i];
                                StateSlotSelection.mSlotOffsetX[i] = 0;
                                StateSlotSelection.mSlotOffsetY[i] = 0;
                            }
                            StateSlotSelection.calculateOverlay();
                            Touch.init(6, mSelectButtonCoords, mSelectButtonIDs, false);
                            break;
                        }
                        StateSlotSelection.updateMoveAnimation();
                        break;
                    }
                    case 0: 
                    case 2: {
                        StateSlotSelection.handleInput();
                    }
                }
                break;
            }
            case 2: {
                Dialog.update();
                if (mActiveScript != null) {
                    if (!mActiveScript.update(Timer.mDt)) break;
                    mActiveScript = null;
                    break;
                }
                if (Dialog.isActive()) break;
                TransitionEffect.init(true);
                mState = 3;
                SaveGameHelper.loadSlot(mSelectedSlot);
                GameState.mSelectedSlotID = mSelectedSlot;
                break;
            }
            case 3: {
                if (TransitionEffect.update()) {
                    boolean bl = true;
                    if (GameState.mSelectedSlotID == 2) {
                        // empty if block
                    }
                    if (SaveGameHelper.slotInUse(mSelectedSlot)) {
                        bl = false;
                    }
                    if (bl) {
                        GameState.mPlayCutscene = 1;
                        PMStateManager.set(4, 0);
                    } else {
                        PMStateManager.set(2, 0);
                    }
                    if (!SaveGameHelper.slotInUse(mSelectedSlot)) {
                        SaveGameHelper.saveSlot();
                    }
                }
                TransitionEffect.draw();
            }
        }
        PMSystem.nextFrame();
    }

    private static void updateMoveAnimation() {
        for (int i = 0; i < 3; ++i) {
            StateSlotSelection.mSlotOffsetX[i] = MathUtil.smoothStep(mInterp, mSlotDeltaPosX[i]);
            StateSlotSelection.mSlotOffsetY[i] = MathUtil.smoothStep(mInterp, mSlotDeltaPosY[i]);
        }
    }

    private static void calculateOverlay() {
        int n;
        for (n = 0; n < 3; ++n) {
            StateSlotSelection.mSelectButtonCoords[n * 8 + 0] = mSlotPosX[n] - (mSlotWidth >> 1);
            StateSlotSelection.mSelectButtonCoords[n * 8 + 1] = mSlotPosY[n] - (mSlotHeight >> 1);
            StateSlotSelection.mSelectButtonCoords[n * 8 + 2] = mSlotPosX[n] + (mSlotWidth >> 1);
            StateSlotSelection.mSelectButtonCoords[n * 8 + 3] = mSlotPosY[n] + (mSlotHeight >> 1);
            if (SaveGameHelper.slotInUse(n)) {
                StateSlotSelection.mSelectButtonCoords[n * 8 + 4] = mSlotPosX[n] + (mSlotWidth >> 1);
                StateSlotSelection.mSelectButtonCoords[n * 8 + 5] = mSlotPosY[n] - 38;
                StateSlotSelection.mSelectButtonCoords[n * 8 + 6] = mSelectButtonCoords[n * 8 + 4] + 86;
                StateSlotSelection.mSelectButtonCoords[n * 8 + 7] = mSelectButtonCoords[n * 8 + 5] + 77;
                continue;
            }
            StateSlotSelection.mSelectButtonCoords[n * 8 + 4] = 0;
            StateSlotSelection.mSelectButtonCoords[n * 8 + 5] = 0;
            StateSlotSelection.mSelectButtonCoords[n * 8 + 6] = 0;
            StateSlotSelection.mSelectButtonCoords[n * 8 + 7] = 0;
        }
        n = 320;
        StateSlotSelection.mDeleteButtonCoords[0] = n - 100 - 48;
        StateSlotSelection.mDeleteButtonCoords[1] = 281;
        StateSlotSelection.mDeleteButtonCoords[2] = mDeleteButtonCoords[0] + 97;
        StateSlotSelection.mDeleteButtonCoords[3] = mDeleteButtonCoords[1] + 78;
        StateSlotSelection.mDeleteButtonCoords[4] = n + 100 - 48;
        StateSlotSelection.mDeleteButtonCoords[5] = 281;
        StateSlotSelection.mDeleteButtonCoords[6] = mDeleteButtonCoords[4] + 97;
        StateSlotSelection.mDeleteButtonCoords[7] = mDeleteButtonCoords[5] + 78;
    }

    private static void calculateCorrectPositions() {
        int n;
        mSlotsInUse = false;
        for (n = 0; n < 3; ++n) {
            if (!SaveGameHelper.slotInUse(n)) continue;
            mSlotsInUse = true;
        }
        for (n = 0; n < 3; ++n) {
            StateSlotSelection.mSlotCorrectPosX[n] = 320;
            if (mSlotsInUse) {
                int n2 = n;
                mSlotCorrectPosX[n2] = mSlotCorrectPosX[n2] - 43;
            }
            StateSlotSelection.mSlotCorrectPosY[n] = 74 + n * (mSlotHeight + 10);
        }
    }

    private static void stopScript() {
        if (mActiveScript != null) {
            mActiveScript.stop();
            mActiveScript = null;
        }
    }

    static {
        mSelectedSlot = -1;
        mSlotCorrectPosX = new int[3];
        mSlotCorrectPosY = new int[3];
        mSlotPosX = new int[3];
        mSlotPosY = new int[3];
        mSlotOffsetX = new int[3];
        mSlotOffsetY = new int[3];
        mSlotDeltaPosX = new int[3];
        mSlotDeltaPosY = new int[3];
        mInterp = 0;
        mSlotPressed = new boolean[3];
        mDeletePressed = new boolean[3];
        mScriptIDs = new short[]{-11793, -7796, -28309, -24312};
    }
}

