/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.movement;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMTrigonometry;

public class MovementTable {
    public static final int MOVEMENTTYPE_SMOOTH = 1;
    public static final int MOVEMENTTYPE_PARABEL = 2;

    public static int[] CreateTable(int n) {
        return MovementTable.CreateTable(n, 1);
    }

    public static int[] CreateTable(int n, int n2) {
        int[] nArray;
        switch (n2) {
            case 1: {
                nArray = MovementTable.CreateSmoothTable(n);
                break;
            }
            case 2: {
                nArray = MovementTable.CreateParabelTable(n);
                break;
            }
            default: {
                nArray = MovementTable.CreateSmoothTable(n);
            }
        }
        return nArray;
    }

    private static int[] CreateSmoothTable(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            nArray[i] = 32768 + PMTrigonometry.cos((180 + 360 * i / (n - 1)) % 360) / 2;
        }
        nArray[n - 1] = 0;
        return nArray;
    }

    private static int[] CreateParabelTable(int n) {
        int[] nArray = new int[n];
        int n2 = 131072 / (n - 1);
        int n3 = -65536;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            nArray[i] = 65536 - PMMath.MUL(n3, n3);
            n3 += n2;
        }
        nArray[n - 1] = 0;
        return nArray;
    }
}

