/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.graphics;

import dk.progressivemedia.rflib.graphics.PMImage;
import dk.progressivemedia.rflib.io.PMFile;
import javax.microedition.lcdui.Image;

public class PMFont {
    public static Image[] font;
    public static int[] charWidth;
    public static int[] kerning;
    public static int[] charHeight;
    public static int[] leading;
    public static short[][] fontOffset;
    public static byte[][] fontWidth;
    public static int[] fontId;
    public static short[][] ascii;

    public static void init(int n) {
        ascii = new short[n][];
        charWidth = new int[n];
        charHeight = new int[n];
        kerning = new int[n];
        font = new Image[n];
        fontId = new int[n];
        leading = new int[n];
        fontOffset = new short[n][];
        fontWidth = new byte[n][];
    }

    public static void load(int n, short s, short s2, short s3, byte by, short s4, int n2, int n3) {
        PMFont.load(n, s, s2, s3, by, s4, n2, n3, 0);
    }

    public static void load(int n, short s, short s2, short s3, byte by, short s4, int n2, int n3, int n4) {
        int n5;
        PMFont.ascii[n] = new short[256];
        PMFont.fontWidth[n] = new byte[256];
        byte[] byArray = PMFile.fileToByteArray(s3);
        short[] sArray = PMFile.fileToShortArray(s4);
        int n6 = sArray.length;
        PMFont.font[n] = PMImage.loadImage(s, s2);
        PMFont.fontOffset[n] = new short[n6];
        int n7 = 0;
        for (n5 = 0; n5 < 256; n5 = (int)((short)(n5 + 1))) {
            PMFont.ascii[n][n5] = -1;
            PMFont.fontWidth[n][n5] = by;
        }
        n5 = 0;
        for (int n8 = 0; n8 < n6; n8 = (int)((short)(n8 + 1))) {
            short s5 = sArray[n8];
            PMFont.ascii[n][s5] = n8;
            PMFont.fontWidth[n][s5] = byArray[n8];
            PMFont.fontOffset[n][n8] = n5;
            n5 = (short)(n5 + byArray[n8]);
        }
        PMFont.charHeight[n] = font[n].getHeight() / (n7 + 1);
        PMFont.charWidth[n] = font[n].getWidth() / n6;
        PMFont.kerning[n] = n2;
        PMFont.leading[n] = n3;
    }

    public static int getLeading(int n) {
        return leading[n];
    }

    public static boolean isLoaded(int n) {
        return font[n] != null;
    }

    public static void unload(int n) {
        PMFont.ascii[n] = null;
        PMFont.font[n] = null;
        PMFont.fontOffset[n] = null;
        PMFont.fontWidth[n] = null;
    }

    public static void deInit() {
        ascii = null;
        font = null;
        fontOffset = null;
        fontWidth = null;
        System.gc();
    }

    public static int stringWidth(String string, int n) {
        if (fontWidth[n] == null) {
            return string.length() * (charWidth[n] + kerning[n]) - kerning[n];
        }
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n2 += fontWidth[n][string.charAt(i)];
        }
        return n2 += (n3 - 1) * kerning[n];
    }

    public static int charsInWidth(int n, int n2) {
        return (n + kerning[n2]) / (charWidth[n2] + kerning[n2]);
    }

    public static int charsInWidth(int n, int n2, String string, int n3) {
        int n4;
        if (fontWidth[n2] == null) {
            return PMFont.charsInWidth(n, n2);
        }
        int n5 = string.length();
        for (n4 = n3; n4 < n5; ++n4) {
            char c = string.charAt(n4);
            if (c < '\u0000') {
                return n4 - n3 + 1;
            }
            if ((n -= fontWidth[n2][c]) < 0) break;
            n -= kerning[n2];
        }
        return n4 - n3;
    }

    public static String[] stringBoxLinesString(int n, String string, int n2) {
        int[] nArray = PMFont.stringBoxLines(n, string, n2);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = i == nArray.length - 1 ? string.substring(nArray[i]) : string.substring(nArray[i], nArray[i + 1]);
        }
        return stringArray;
    }

    public static int[] stringBoxLines(int n, String string, int n2) {
        if (font[n2] == null) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 99999;
        int n6 = string.length();
        int n7 = 0;
        int n8 = 100000;
        int n9 = n6 / 8;
        if (n9 < 10) {
            n9 = 10;
        }
        int[] nArray = new int[n9];
        boolean bl = false;
        boolean bl2 = true;
        int n10 = 0;
        while (n7 < n6 && n4 < n8) {
            int n11;
            switch (string.charAt(n7)) {
                case ' ': {
                    ++n7;
                    break;
                }
                case '\u000f': {
                    ++n7;
                    break;
                }
                case '\n': {
                    if (!bl2 && n10 > 0) {
                        nArray[n3++] = n7;
                    }
                    ++n10;
                    ++n7;
                    break;
                }
                default: {
                    n10 = 0;
                    bl = true;
                }
            }
            if (!bl) continue;
            bl2 = false;
            bl = false;
            int n12 = n7 + PMFont.charsInWidth(n, n2, string, n7);
            if (n12 > n6) {
                n12 = n6;
            }
            int n13 = -1;
            for (n11 = n7; n11 < n12; ++n11) {
                if (string.charAt(n11) == '\n') {
                    n13 = n11;
                    break;
                }
                if (string.charAt(n11) != ' ' && string.charAt(n11) != '\u000f') continue;
                n13 = n11;
            }
            if (n11 < n6 && n13 > 0) {
                n11 = n13;
            }
            if (n11 >= n5) {
                n11 = n5;
                n6 = 0;
            }
            if (n7 > n11) {
                n7 = n11;
            }
            nArray[n3++] = n7;
            n7 = n11;
        }
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }
}

