/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.PlatformView;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class PlatformViewCorrosive
extends PlatformView {
    private static final int STATE_IDLE = 0;
    private static final int STATE_SHAKING = 1;
    private static final int STATE_FALLING = 2;
    private static final int STATE_GONE = 3;
    private int mState;
    private Movie mAnimIdle;
    private Movie mAnimShaking;
    private Movie mAnimFalling;
    private Movie mAnimGone;
    private int mWidth;

    public PlatformViewCorrosive(PlatformData platformData) {
        this.mData = platformData;
        switch (platformData.getSize()) {
            case 0: {
                this.mAnimIdle = Movie.load((short)-23994);
                this.mAnimShaking = Movie.load((short)-30079);
                this.mAnimFalling = Movie.load((short)-6124);
                this.mAnimGone = Movie.load((short)11671);
                this.mWidth = 80;
                break;
            }
            case 1: {
                this.mAnimIdle = Movie.load((short)-18650);
                this.mAnimShaking = Movie.load((short)-13608);
                this.mAnimFalling = Movie.load((short)-22451);
                this.mAnimGone = Movie.load((short)14583);
                this.mWidth = 120;
                break;
            }
            case 2: {
                this.mAnimIdle = Movie.load((short)-8456);
                this.mAnimShaking = Movie.load((short)9576);
                this.mAnimFalling = Movie.load((short)18429);
                this.mAnimGone = Movie.load((short)20777);
                this.mWidth = 160;
            }
        }
        this.mAnimIdle.loadGfx();
        this.mAnimIdle.gotoTick(0);
        this.mAnimShaking.loadGfx();
        this.mAnimShaking.gotoTick(0);
        this.mAnimFalling.loadGfx();
        this.mAnimFalling.gotoTick(0);
        this.mAnimGone.loadGfx();
        this.mAnimGone.gotoTick(0);
        this.mState = 0;
    }

    public void update() {
        int n = this.mData.getAlphaValue();
        switch (this.mState) {
            case 0: 
            case 1: {
                Surface surface = this.mData.getSurface();
                if (surface.getPlayerTouching()) {
                    this.mState = 1;
                    this.mAnimShaking.update(Timer.mDt);
                } else {
                    this.mState = 0;
                }
                if (n > 0) break;
                this.mState = 2;
                break;
            }
            case 2: {
                this.mAnimFalling.update(Timer.mDt);
                if (!this.mAnimFalling.isDone()) break;
                this.mState = 3;
                break;
            }
            case 3: {
                if (n <= 0) break;
                this.mAnimIdle.gotoTick(0);
                this.mAnimShaking.gotoTick(0);
                this.mAnimFalling.gotoTick(0);
                this.mAnimGone.gotoTick(0);
                this.mState = 0;
            }
        }
    }

    public void draw(Vector2 vector2) {
        int n;
        int n2;
        long l;
        long l2;
        int n3;
        long l3;
        Surface surface = this.mData.getSurface();
        long l4 = (long)surface.getMinX() * 5L >> 1;
        int n4 = (int)((l4 >> 16) - ((l3 = (long)vector2.mX * 5L >> 1) >> 16));
        if (Camera.isInside(n4, n3 = (int)(((l2 = (long)surface.getFirstY() * 5L >> 1) >> 16) - ((l = (long)vector2.mY * 5L >> 1) >> 16)), n2 = this.mWidth * 5 >> 1, n = 40)) {
            switch (this.mState) {
                case 0: {
                    this.mAnimIdle.draw(n4, n3);
                    break;
                }
                case 1: {
                    this.mAnimShaking.draw(n4, n3);
                    break;
                }
                case 2: {
                    this.mAnimFalling.draw(n4, n3);
                    break;
                }
                case 3: {
                    this.mAnimGone.draw(n4, n3);
                }
            }
        }
    }
}

