/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.util.PMRandom;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.script.Script;

public class LevelSelectionScriptHelper {
    public static final int EVENT_ENTER_LEVEL_SELECTION = 0;
    private static short[] mScriptIDs = new short[]{16191, 3932, 8061, 28570, 32699, 24569, -20970, -16841, 6190, 2063, 14444, 16766};
    private static short[] mScriptPriority = new short[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static Script mActiveScript;
    private static short mActivePriority;
    private static Script[] mScripts;

    public static void init() {
        mActiveScript = null;
        mActivePriority = 0;
        mScripts = new Script[mScriptIDs.length];
        for (int i = 0; i < mScriptIDs.length; ++i) {
            LevelSelectionScriptHelper.mScripts[i] = Script.load(mScriptIDs[i]);
        }
    }

    public static void deinit() {
        for (int i = 0; i < mScripts.length; ++i) {
            Script cfr_ignored_0 = mScripts[i];
            Script.unload();
            LevelSelectionScriptHelper.mScripts[i] = null;
        }
        mScripts = null;
    }

    public static void update() {
        if (mActiveScript != null) {
            mActiveScript.update(Timer.mDt);
            if (mActiveScript.isDone()) {
                mActiveScript = null;
                mActivePriority = 0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void startScript(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        n3 = 0;
                        break;
                    }
                    case 3: {
                        n3 = 3;
                        break;
                    }
                    case 4: {
                        n3 = 1;
                        n4 = PMRandom.get16() * 4 >> 16;
                        break;
                    }
                    case 5: {
                        n3 = 2;
                        break;
                    }
                    case 6: {
                        if ((GameState.mScriptStateGlobal & 0x400L) != 0L) break;
                        n3 = 4;
                        GameState.mScriptStateGlobal |= 0x400L;
                        break;
                    }
                    case 7: {
                        n3 = 5;
                        break;
                    }
                    case 8: {
                        n3 = 6;
                        break;
                    }
                    case 9: {
                        n3 = 7;
                        break;
                    }
                    case 10: {
                        n3 = 8;
                        break;
                    }
                    case 11: {
                        n3 = 9;
                        break;
                    }
                    case 12: {
                        if (!GameState.mAllCollectedInGame) {
                            n3 = 10;
                            break;
                        }
                        if ((GameState.mScriptStateGlobal & 0x400L) != 0L) break;
                        n3 = 11;
                        GameState.mScriptStateGlobal |= 0x400L;
                    }
                }
                break;
            }
        }
        if (n3 == -1) return;
        if (mActiveScript != null) {
            if (mActivePriority >= mScriptPriority[n3]) return;
            mActiveScript.stop();
            mActiveScript = mScripts[n3];
            mActivePriority = mScriptPriority[n3];
            if (n4 >= 0) {
                mActiveScript.setVariable(0, n4);
            }
            mActiveScript.rewind();
            return;
        }
        mActiveScript = mScripts[n3];
        mActivePriority = mScriptPriority[n3];
        if (n4 >= 0) {
            mActiveScript.setVariable(0, n4);
        }
        mActiveScript.rewind();
    }

    public static boolean isScriptPlaying() {
        return mActiveScript != null;
    }
}

