/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.system.PMTimer;
import dk.progressivemedia.skeleton.Timer;

public class SoundBuffer {
    private static final int NUM_BUFFERED = 50;
    private static int[] mFree = new int[50];
    private static int mCurFreeSlot = 0;
    private static boolean[] mActive = new boolean[50];
    private static int[] mEffects = new int[50];
    private static int[] mTimeouts = new int[50];
    private static int mNumBuffered;
    public static long lastPlayCallTime;

    public static void init() {
        for (int i = 0; i < 50; ++i) {
            SoundBuffer.mFree[i] = i == 49 ? -1 : i + 1;
            SoundBuffer.mActive[i] = false;
        }
        mCurFreeSlot = 0;
    }

    public static void update() {
        for (int i = 0; i < 50; ++i) {
            if (!mActive[i]) continue;
            PMAudio.play(mEffects[i], 1);
            PMAudio.setVolume(mEffects[i], 9);
            if (mTimeouts[i] > 0) {
                int n = i;
                mTimeouts[n] = mTimeouts[n] - Timer.mDt;
            }
            if (!PMAudio.isPlaying(mEffects[i], -1) && mTimeouts[i] >= 0) continue;
            SoundBuffer.mFree[i] = mCurFreeSlot;
            mCurFreeSlot = i;
            SoundBuffer.mActive[i] = false;
        }
    }

    public static void play(int n, int n2) {
        if (PMTimer.tick() - lastPlayCallTime < 1000L && (n == 11 || n == 5)) {
            return;
        }
        lastPlayCallTime = PMTimer.tick();
        int n3 = mCurFreeSlot;
        if (n3 >= 0) {
            mCurFreeSlot = mFree[n3];
            SoundBuffer.mActive[n3] = true;
            SoundBuffer.mEffects[n3] = n;
            SoundBuffer.mTimeouts[n3] = n2;
        }
    }

    static {
        lastPlayCallTime = 0L;
    }
}

