/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.Transition;

public class TransitionEffect {
    private static final int TRANSITION_LENGTH = 50;
    private static final int ALPHA_OPAQUE = 255;
    private static final int STENCIL_SCALE = 524288;
    private static Transition alpha;
    private static Transition scale;
    private static Transition musicVolume;
    private static boolean bToBlack;
    private static boolean bFadeMusic;

    public static void init(boolean bl) {
        bToBlack = bl;
        if (bl) {
            alpha = new Transition(0, 50);
            alpha.Value(255);
            scale = new Transition(524288, 50);
            scale.Value(0);
            musicVolume = new Transition(MusicBuffer.getVolume(), 50);
            musicVolume.Value(0);
        } else {
            alpha = new Transition(255, 50);
            alpha.Value(0);
            scale = new Transition(0, 50);
            scale.Value(524288);
            musicVolume = new Transition(0, 50);
            musicVolume.Value(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
        }
    }

    public static boolean update() {
        alpha.update();
        scale.update();
        musicVolume.update();
        if (bFadeMusic) {
            MusicBuffer.setVolume(musicVolume.Value());
        }
        return alpha.Value() == alpha.actualValue();
    }

    public static void draw() {
        int n = 255;
        int n2 = 85 * scale.Value() >> 16;
        int n3 = 64 * scale.Value() >> 16;
        int n4 = 160 - (n2 >> 1);
        int n5 = 120 - (n3 >> 1);
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        int n8 = 32;
        int n9 = 32;
        int n10 = 65536 + PMMath.DIV(n4 << 16, n8 << 16);
        int n11 = 65536 + PMMath.DIV(320 - n6 << 16, n8 << 16);
        int n12 = 65536 + PMMath.DIV(n5 << 16, n9 << 16);
        int n13 = PMMath.DIV(n2 << 16, n8 << 16);
        int n14 = PMMath.DIV(240 - n7 << 16, n9 - (n9 >> 4) << 16);
        int n15 = PMMath.DIV(n2 << 16, n8 << 16);
        PMImageManager.draw(24, n4, 0, false, 0, n, n10, 0x600000);
        PMImageManager.draw(26, n6, 0, false, 0, n, n11, 0x600000);
        PMImageManager.draw(25, n4, n5, false, 0, n, n13, n12);
        PMImageManager.draw(27, n4, n7, false, 0, n, n15, n14);
    }

    public static void setFadeMusic(boolean bl) {
        bFadeMusic = bl;
    }

    static {
        bToBlack = true;
        bFadeMusic = true;
    }
}

