/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets.subpackets;

import gs.common.BoundedString;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.GameInstanceStatus;
import gs.common.enumerations.GameType;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.info.IGameInstanceInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class GameInstanceInfo
implements IGameInstanceInfo,
IDataStringConvertible {
    private static final int NUMPACKETFILEDS = 5;
    private IGSId id;
    private BoundedString name;
    private Short gameStatus;
    private Short gameType;
    private Integer freeSlots;

    public GameInstanceInfo() {
        this.id = null;
        this.name = BoundedString.empty();
        this.gameStatus = GameInstanceStatus.Invalid;
        this.gameType = GameType.Invalid;
        this.freeSlots = null;
    }

    public GameInstanceInfo(IGameInstanceInfo info) {
        this.id = info.getId();
        this.name = info.getName();
        this.gameStatus = info.getStatus();
        this.gameType = info.getType();
        this.freeSlots = info.getFreeSlots();
    }

    public GameInstanceInfo(IGSId gameId, BoundedString gameName, Short gameStatus, Short gameType, Integer freeSlots) {
        this.id = gameId;
        this.name = gameName;
        this.gameStatus = gameStatus;
        this.gameType = gameType;
        this.freeSlots = freeSlots;
    }

    public IGSId getId() {
        return this.id;
    }

    public BoundedString getName() {
        return this.name;
    }

    public Short getStatus() {
        return this.gameStatus;
    }

    public Short getType() {
        return this.gameType;
    }

    public Integer getFreeSlots() {
        return this.freeSlots;
    }

    public String toDataString() throws PacketConversionException {
        if (this.id == null || this.name == null || this.gameStatus == GameInstanceStatus.Invalid || this.gameType == GameType.Invalid) {
            throw new PacketConversionException("GameInstanceInfo to data string: packet not initialized");
        }
        String result = "";
        result = result + DataPacketUtil.objectToDataString(this.id);
        result = result + DataPacketUtil.gameInstanceInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.name);
        result = result + DataPacketUtil.gameInstanceInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameStatus);
        result = result + DataPacketUtil.gameInstanceInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameType);
        result = result + DataPacketUtil.gameInstanceInfoSeperator();
        result = result + DataPacketUtil.objectToDataString(this.freeSlots);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.gameInstanceInfoSeperator());
        if (mainSplit.size() != 5) {
            throw new PacketConversionException("parsing GameInstanceInfo: invalid packet type");
        }
        try {
            this.id = GSIdUtil.parseFromString((String)mainSplit.elementAt(0));
            this.name = new BoundedString((String)mainSplit.elementAt(1));
            this.gameStatus = ObjectUtil.shortFromString((String)mainSplit.elementAt(2));
            this.gameType = ObjectUtil.shortFromString((String)mainSplit.elementAt(3));
            this.freeSlots = ObjectUtil.integerFromString((String)mainSplit.elementAt(4));
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing GameInstanceInfo: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.SubPacket;
    }

    public String toString() {
        return "GameInstanceInfo: id=" + ((Object)this.id).toString() + "; " + "name=" + this.name.toString() + "; " + "gameStatus=" + GameInstanceStatus.gameInstanceStatusToString(this.gameStatus) + "; " + "gameType=" + GameType.gameTypeToString(this.gameType) + "; " + "freeSlots=" + this.freeSlots.toString();
    }
}

