/*
 * Decompiled with CFR 0.152.
 */
package root;

import com.nokia.mid.ui.DeviceControl;
import framework.Globals;
import framework.MainGameCanvas;
import framework.Texts;
import framework.sound.Music;
import gs.common.utils.CollectionUtil;
import gs.common.utils.ObjectUtil;
import gs.ompg.ClientInterface;
import gs.ompg.IMsgReceiver;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import menu.InGameMenu;
import root.Ship;
import root.TanksGameState;
import root.TanksMIDlet;

public class TanksCanvas
extends GameCanvas
implements Runnable,
IMsgReceiver {
    public Graphics g;
    private Thread gameThread;
    private ClientInterface clientInterface;
    private InGameMenu inGameMenu = null;
    private long timeNow;
    private long timeUsed;
    private long sleepTime = 20L;
    private long fullTime;
    public boolean isActive = true;
    public static int gameState = 0;
    public static int WAITING_FOR_PLAYER = 1;
    public static int PLAYING = 2;
    public static int STOPPED = 3;
    public static int RECEIVER = 0;
    public static int HOST_PLAYER = 1;
    public static int JOIN_PLAYER = 2;
    public int TIMER_LIMIT;
    public int TIMER = this.TIMER_LIMIT = 40;
    private long lastTimerTime = 0L;
    private long lastTime = -1L;
    private int deltaTime;
    public static boolean isTraining = false;
    public Random random;
    TanksMIDlet midlet;
    public Font font = Font.getFont((int)0, (int)1, (int)8);
    public boolean isTrainingMode = false;
    public Image imgHud;
    public Image imgSelector;
    public Image imgArrow;
    public Image imgShipsLeft;
    public Image imgHudPause;
    public Image imgTarget;
    public Image imgMiss;
    public Image imgMyTile;
    public Image imgOppTile;
    public Image imgButton;
    public Image imgButton_unpressed = null;
    public Image[] boomAnim = null;
    private int imgHudHeight = 0;
    public int SCREEN_WIDTH = 240;
    public int SCREEN_HEIGHT = 320;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public long fireButtonStartTime = 0L;
    private MainGameCanvas mainGameCanvas;
    private TanksGameState lastSent;
    private long lastLightTime = 0L;
    private boolean gameEndArrived = false;
    public static boolean backFromOnline = false;
    private StringBuffer endInfo;
    private boolean rematchPossible = true;
    public boolean wasSfxPlayed = false;
    public int roundCounter = 0;
    private boolean rematchSent = false;
    private char[] charsArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'};
    public Image[][] ships;
    private Image[] currShip;
    public int currShipNr = 0;
    private int currShipX = 5;
    private int currShipY = 5;
    public int TILE_SIZE = 0;
    public int diffTile = 0;
    public boolean setShips = false;
    public boolean showMyBoard = true;
    private boolean showShipsLeft = false;
    public Ship[] myShips;
    public Ship[] enemyShips;
    public int cursorX = 4;
    public int cursorY = 4;
    int shipLengthH = 0;
    int shipLengthV = 0;
    int AIorient = 0;
    int lastHitShipId = 0;
    int lastHitX = 0;
    int lastHitY = 0;
    int firstHitX = 0;
    int firstHitY = 0;
    int hitsInRow = 0;
    boolean isVertical = false;
    boolean isHorizontal = false;
    boolean wasEndShown = false;
    int tryCntr = 0;
    int rX;
    int rY;
    boolean isHunt = false;
    boolean wasHit = false;
    boolean myTurn = false;
    boolean wasAutoChange = false;
    long lastAiShotTime = 0L;
    int RANDOM_AI_TIME = 0;
    private long lastShotTime = 0L;
    private long gameEndArrivedTime = 0L;
    private int VIEW_CHANGE_TIME = 0;
    private int[][] myBoard = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private int[][] enemyBoard = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public TanksCanvas(TanksMIDlet midlet, MainGameCanvas mainGameCanvas) {
        super(false);
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.mainGameCanvas = mainGameCanvas;
        this.loadGraphics();
        this.random = new Random();
        this.inGameMenu = new InGameMenu(mainGameCanvas, this, midlet);
        if (this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.gameThread.start();
        }
    }

    public boolean initialize(Object param) {
        return true;
    }

    public void startGame() {
        Music.stopMusic();
        Music.playMusic(TanksMIDlet.gameMusicId);
        gameState = PLAYING;
        this.setShips = true;
        this.showMyBoard = true;
        this.showShipsLeft = false;
        this.cursorX = 4;
        this.cursorY = 4;
        this.clearBoard(this.myBoard);
        this.clearBoard(this.enemyBoard);
        this.myShips = null;
        this.enemyShips = null;
        this.myShips = new Ship[10];
        this.enemyShips = new Ship[10];
        this.myShips[9] = new Ship(this, 0, 1, true);
        this.myShips[8] = new Ship(this, 1, 1, true);
        this.myShips[7] = new Ship(this, 2, 1, true);
        this.myShips[6] = new Ship(this, 3, 1, true);
        this.myShips[5] = new Ship(this, 4, 2, true);
        this.myShips[4] = new Ship(this, 5, 2, true);
        this.myShips[3] = new Ship(this, 6, 2, true);
        this.myShips[2] = new Ship(this, 7, 3, true);
        this.myShips[1] = new Ship(this, 8, 3, true);
        this.myShips[0] = new Ship(this, 9, 4, true);
        this.enemyShips[9] = new Ship(this, 0, 1, false);
        this.enemyShips[8] = new Ship(this, 1, 1, false);
        this.enemyShips[7] = new Ship(this, 2, 1, false);
        this.enemyShips[6] = new Ship(this, 3, 1, false);
        this.enemyShips[5] = new Ship(this, 4, 2, false);
        this.enemyShips[4] = new Ship(this, 5, 2, false);
        this.enemyShips[3] = new Ship(this, 6, 2, false);
        this.enemyShips[2] = new Ship(this, 7, 3, false);
        this.enemyShips[1] = new Ship(this, 8, 3, false);
        this.enemyShips[0] = new Ship(this, 9, 4, false);
        if (isTraining) {
            this.placeShipsRandomly(this.enemyBoard, this.enemyShips);
            this.inGameMenu.menu = this.inGameMenu.trainingInfoMenu;
            this.inGameMenu.isActive = true;
            this.myTurn = true;
        } else {
            Globals.playerNickname = new StringBuffer(this.clientInterface.myGetName());
            Globals.enemyNickname = new StringBuffer(this.clientInterface.oppGetName());
        }
        this.currShipNr = 0;
        this.inGameMenu.isActive = false;
        this.inGameMenu.menu = this.inGameMenu.pauseMenu;
        this.inGameMenu.updateGameMenu();
        this.TIMER = this.TIMER_LIMIT + 20;
        this.inGameMenu.updateSettings();
        this.gameEndArrived = false;
        this.wasEndShown = false;
        this.roundCounter = 1;
        this.rematchSent = false;
        this.midlet.display.setCurrent((Displayable)this);
    }

    public void clearBoard(int[][] board) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                board[i][j] = 0;
            }
        }
    }

    public void loadGraphics() {
        try {
            this.imgMyTile = Image.createImage((String)"/kratka1.png");
            this.imgOppTile = Image.createImage((String)"/kratka2.png");
            this.imgMiss = Image.createImage((String)"/pudlo.png");
            this.imgHud = Image.createImage((String)"/hud.png");
            this.imgTarget = Image.createImage((String)"/target.png");
            this.imgSelector = Image.createImage((String)"/hud_panel_morza.png");
            this.imgHudPause = Image.createImage((String)"/hud_soft_pause.png");
            this.imgButton_unpressed = Image.createImage((String)"/button_unpressed.png");
            this.imgButton = Image.createImage((String)"/button.png");
            this.imgArrow = Image.createImage((String)"/hud_strzalka.png");
            this.imgHudHeight = this.imgHud.getHeight();
            this.TILE_SIZE = this.imgMyTile.getHeight();
            this.ships = new Image[4][4];
            this.boomAnim = new Image[8];
            this.imgShipsLeft = Image.createImage((String)"/pozostale_tlo.png");
            this.ships[0][0] = Image.createImage((String)"/statek1.png");
            this.ships[0][1] = Image.createImage((String)"/statek1.png");
            this.ships[0][2] = Image.createImage((String)"/statek1x.png");
            this.ships[0][3] = Image.createImage((String)"/statek1x.png");
            this.diffTile = (this.TILE_SIZE - this.ships[0][0].getHeight()) / 2;
            this.ships[1][0] = Image.createImage((String)"/statek2.png");
            this.ships[1][1] = Image.createImage((String)"/statek2p.png");
            this.ships[1][2] = Image.createImage((String)"/statek2xx.png");
            this.ships[1][3] = Image.createImage((String)"/statek2x.png");
            this.ships[2][0] = Image.createImage((String)"/statek3.png");
            this.ships[2][1] = Image.createImage((String)"/statek3p.png");
            this.ships[2][2] = Image.createImage((String)"/statek3xx.png");
            this.ships[2][3] = Image.createImage((String)"/statek3x.png");
            this.ships[3][0] = Image.createImage((String)"/statek4.png");
            this.ships[3][1] = Image.createImage((String)"/statek4p.png");
            this.ships[3][2] = Image.createImage((String)"/statek4xx.png");
            this.ships[3][3] = Image.createImage((String)"/statek4x.png");
            for (int k = 1; k <= 8; ++k) {
                this.boomAnim[k - 1] = Image.createImage((String)("/boom" + k + ".png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("BLAD LADOWANIA GRAFIKI loadGraphics() ");
        }
    }

    public void keyPressed(int keyCode) {
        int keyState = this.getKeyStates();
        if (this.inGameMenu != null) {
            if (keyCode == -7 && this.inGameMenu.menu == this.inGameMenu.pauseMenu) {
                this.inGameMenu.isActive = !this.inGameMenu.isActive;
            }
            if (this.inGameMenu.isActive) {
                this.inGameMenu.keyPressed(keyCode);
                return;
            }
        }
        if (keyCode == 48 && !this.setShips) {
            this.showShipsLeft = !this.showShipsLeft;
        }
        if (keyCode == 42 && this.setShips) {
            this.placeShipsRandomly(this.myBoard, this.myShips);
            if (!isTraining) {
                this.inGameMenu.isActive = true;
                this.inGameMenu.menu = this.inGameMenu.waitingBoardMenu;
            }
        }
        if (keyCode == 35 && !this.setShips) {
            this.showMyBoard = !this.showMyBoard;
        }
        if (!(keyCode != -6 && keyCode != -5 || this.setShips)) {
            this.fireButtonStartTime = System.currentTimeMillis();
            this.takeShotAt(this.cursorX, this.cursorY);
        }
        if (this.setShips) {
            if (this.myShips[this.currShipNr].orientation == 0) {
                this.shipLengthH = this.myShips[this.currShipNr].type - 1;
                this.shipLengthV = 0;
            } else {
                this.shipLengthV = this.myShips[this.currShipNr].type - 1;
                this.shipLengthH = 0;
            }
        }
        if (keyCode == -1 || keyCode == 50) {
            if (this.showMyBoard && this.setShips) {
                if (this.myShips[this.currShipNr].posY > 0) {
                    --this.myShips[this.currShipNr].posY;
                }
            } else if (this.cursorY > 0 && this.myTurn) {
                --this.cursorY;
            }
        }
        if (keyCode == -2 || keyCode == 56) {
            if (this.showMyBoard && this.setShips) {
                if (this.myShips[this.currShipNr].posY < 9 - this.shipLengthV) {
                    ++this.myShips[this.currShipNr].posY;
                }
            } else if (this.cursorY < 9 && this.myTurn) {
                ++this.cursorY;
            }
        }
        if (keyCode == -3 || keyCode == 52) {
            if (this.showMyBoard && this.setShips) {
                if (this.myShips[this.currShipNr].posX > 0) {
                    --this.myShips[this.currShipNr].posX;
                }
            } else if (this.cursorX > 0 && this.myTurn) {
                --this.cursorX;
            }
        }
        if (keyCode == -4 || keyCode == 54) {
            if (this.showMyBoard && this.setShips) {
                if (this.myShips[this.currShipNr].posX < 9 - this.shipLengthH) {
                    ++this.myShips[this.currShipNr].posX;
                }
            } else if (this.cursorX < 9 && this.myTurn) {
                ++this.cursorX;
            }
        }
        if ((keyCode == 53 || keyCode == -5) && this.setShips && !this.checkCollision()) {
            this.placeShipOnBoard(this.myBoard, this.myShips, this.myShips[this.currShipNr].posX, this.myShips[this.currShipNr].posY, this.myShips[this.currShipNr].orientation, this.shipLengthH, this.shipLengthV, false, 0);
            if (this.currShipNr < 9) {
                ++this.currShipNr;
            } else {
                if (isTraining) {
                    this.setShips = false;
                    this.showMyBoard = !this.myTurn;
                }
                if (!isTraining) {
                    this.sendStartParams(this.myShips);
                    this.inGameMenu.isActive = true;
                    this.inGameMenu.menu = this.inGameMenu.waitingBoardMenu;
                }
            }
        }
        if (keyCode == -6 && this.setShips) {
            this.myShips[this.currShipNr].orientation = this.myShips[this.currShipNr].orientation == 0 ? 1 : 0;
            if (this.myShips[this.currShipNr].orientation == 0) {
                this.shipLengthH = this.myShips[this.currShipNr].type - 1;
                this.shipLengthV = 0;
            } else {
                this.shipLengthV = this.myShips[this.currShipNr].type - 1;
                this.shipLengthH = 0;
            }
            if (this.myShips[this.currShipNr].posX + this.shipLengthH > 9) {
                this.myShips[this.currShipNr].posX = 9 - this.shipLengthH;
            }
            if (this.myShips[this.currShipNr].posY + this.shipLengthV > 9) {
                this.myShips[this.currShipNr].posY = 9 - this.shipLengthV;
            }
        }
    }

    public void placeShipsRandomly(int[][] board, Ship[] ships) {
        int i;
        int shipCntr = 0;
        int length = 0;
        this.currShipNr = 0;
        int randomOrient = 0;
        boolean success = false;
        while (this.currShipNr <= 9) {
            int randomX = this.getRandom(0, 9);
            int randomY = this.getRandom(0, 9);
            randomOrient = this.getRandom(0, 1);
            success = true;
            length = ships[shipCntr].type - 1;
            if (randomOrient == 0) {
                for (i = 0; i <= length; ++i) {
                    if (randomX + length > 9 || board[randomY][randomX + i] == 0) continue;
                    success = false;
                }
                if (randomX + length > 9) {
                    success = false;
                }
                if (success) {
                    this.placeShipOnBoard(board, ships, randomX, randomY, randomOrient, length, 0, false, 0);
                }
            } else {
                for (i = 0; i <= length; ++i) {
                    if (randomY + length > 9 || board[randomY + i][randomX] == 0) continue;
                    success = false;
                }
                if (randomY + length > 9) {
                    success = false;
                }
                if (success) {
                    this.placeShipOnBoard(board, ships, randomX, randomY, randomOrient, 0, length, false, 0);
                }
            }
            if (!success) continue;
            ++shipCntr;
            ++this.currShipNr;
        }
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                System.out.print(" " + board[i][j]);
            }
            System.out.println("");
        }
        this.currShipNr = 9;
        if (!isTraining) {
            this.sendStartParams(this.myShips);
        } else if (board == this.myBoard) {
            this.setShips = false;
            this.showMyBoard = !this.myTurn;
        }
    }

    public void placeShipOnBoard(int[][] board, Ship[] ships, int shipX, int shipY, int orient, int shipH, int shipV, boolean mod, int id) {
        int i;
        if (mod) {
            this.currShipNr = id;
        }
        System.out.println("place on board x: " + shipX + " y: " + shipY + " orient: " + orient + " lh: " + shipH + " lv: " + shipV);
        if (shipH > 0) {
            for (i = 0; i <= shipH; ++i) {
                if (shipX + i + 1 <= 9 && i == shipH) {
                    board[shipY][shipX + 1 + i] = -1;
                }
                if (shipX + i - 1 >= 0 && i == 0) {
                    board[shipY][shipX - 1 + i] = -1;
                }
                if (shipY + 1 <= 9) {
                    board[shipY + 1][shipX + i] = -1;
                }
                if (shipY - 1 >= 0) {
                    board[shipY - 1][shipX + i] = -1;
                }
                if (shipX + i + 1 <= 9 && shipY - 1 >= 0) {
                    board[shipY - 1][shipX + 1 + i] = -1;
                }
                if (shipY + 1 <= 9 && shipX + 1 + i <= 9) {
                    board[shipY + 1][shipX + 1 + i] = -1;
                }
                if (shipX - 1 + i >= 0 && shipY - 1 >= 0) {
                    board[shipY - 1][shipX - 1 + i] = -1;
                }
                if (shipY + 1 <= 9 && shipX - 1 + i >= 0) {
                    board[shipY + 1][shipX - 1 + i] = -1;
                }
                board[shipY][shipX + i] = ships[this.currShipNr].type;
                ships[this.currShipNr].posX = shipX;
                ships[this.currShipNr].posY = shipY;
                ships[this.currShipNr].orientation = orient;
            }
        }
        if (shipV > 0) {
            for (i = 0; i <= shipV; ++i) {
                if (shipX + 1 <= 9) {
                    board[shipY + i][shipX + 1] = -1;
                }
                if (shipX - 1 >= 0) {
                    board[shipY + i][shipX - 1] = -1;
                }
                if (shipY + 1 + i <= 9 && i == shipV) {
                    board[shipY + 1 + i][shipX] = -1;
                }
                if (shipY - 1 + i >= 0 && i == 0) {
                    board[shipY - 1 + i][shipX] = -1;
                }
                if (shipX + 1 <= 9 && shipY - 1 + i >= 0) {
                    board[shipY - 1 + i][shipX + 1] = -1;
                }
                if (shipY + 1 + i <= 9 && shipX + 1 <= 9) {
                    board[shipY + 1 + i][shipX + 1] = -1;
                }
                if (shipX - 1 >= 0 && shipY - 1 + i >= 0) {
                    board[shipY - 1 + i][shipX - 1] = -1;
                }
                if (shipY + 1 + i <= 9 && shipX - 1 >= 0) {
                    board[shipY + 1 + i][shipX - 1] = -1;
                }
                board[shipY + i][shipX] = ships[this.currShipNr].type;
                ships[this.currShipNr].posX = shipX;
                ships[this.currShipNr].posY = shipY;
                ships[this.currShipNr].orientation = orient;
            }
        }
        if (shipV == 0 && shipH == 0) {
            board[shipY][shipX] = ships[this.currShipNr].type;
            ships[this.currShipNr].posX = shipX;
            ships[this.currShipNr].posY = shipY;
            ships[this.currShipNr].orientation = orient;
            if (shipX + 1 <= 9) {
                board[shipY][shipX + 1] = -1;
            }
            if (shipX - 1 >= 0) {
                board[shipY][shipX - 1] = -1;
            }
            if (shipY + 1 <= 9) {
                board[shipY + 1][shipX] = -1;
            }
            if (shipY - 1 >= 0) {
                board[shipY - 1][shipX] = -1;
            }
            if (shipX + 1 <= 9 && shipY - 1 >= 0) {
                board[shipY - 1][shipX + 1] = -1;
            }
            if (shipY + 1 <= 9 && shipX + 1 <= 9) {
                board[shipY + 1][shipX + 1] = -1;
            }
            if (shipX - 1 >= 0 && shipY - 1 >= 0) {
                board[shipY - 1][shipX - 1] = -1;
            }
            if (shipY + 1 <= 9 && shipX - 1 >= 0) {
                board[shipY + 1][shipX - 1] = -1;
            }
        }
        if (ships[this.currShipNr].orientation == 0) {
            for (i = 0; i <= shipH; ++i) {
                ships[this.currShipNr].shipParts[i][0] = ships[this.currShipNr].posX + i;
                ships[this.currShipNr].shipParts[i][1] = ships[this.currShipNr].posY;
                ships[this.currShipNr].shipParts[i][2] = 1;
            }
        } else {
            for (i = 0; i <= shipV; ++i) {
                ships[this.currShipNr].shipParts[i][0] = ships[this.currShipNr].posX;
                ships[this.currShipNr].shipParts[i][1] = ships[this.currShipNr].posY + i;
                ships[this.currShipNr].shipParts[i][2] = 1;
            }
        }
    }

    public void fillEnemyData(TanksGameState state, String msg) {
        int i;
        int shipLength = 0;
        int orient = 0;
        int shipH = 0;
        int shipV = 0;
        int x = 0;
        int y = 0;
        Vector split = CollectionUtil.splitString(msg, "<p>");
        for (i = 0; i < 10; ++i) {
            try {
                x = ObjectUtil.integerFromString((String)split.elementAt(2 + 2 * i));
                y = ObjectUtil.integerFromString((String)split.elementAt(3 + 2 * i));
            }
            catch (Exception e) {
                System.out.println("Eror spliting:" + e.getMessage());
            }
            if (x < 0) {
                orient = 1;
                x = Math.abs(x);
            } else {
                orient = 0;
            }
            --x;
            if (i == 0) {
                shipLength = 3;
            }
            if (i >= 1 && i <= 2) {
                shipLength = 2;
            }
            if (i >= 3 && i <= 5) {
                shipLength = 1;
            }
            if (i >= 6 && i <= 9) {
                shipLength = 0;
            }
            if (orient == 0) {
                shipH = shipLength;
                shipV = 0;
            } else {
                shipV = shipLength;
                shipH = 0;
            }
            this.placeShipOnBoard(this.enemyBoard, this.enemyShips, Math.abs(x), Math.abs(y), orient, shipH, shipV, true, i);
        }
        System.out.println("TABLICA PRZECIWNIKA " + this.currShipNr);
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                System.out.print(" " + this.enemyBoard[i][j]);
            }
            System.out.println("");
        }
        System.out.println("**********KONIEC TABALICY*********");
    }

    public void takeShotAt(int targetX, int targetY) {
        if (this.enemyBoard[targetY][targetX] != -2) {
            if (this.myTurn && !this.showMyBoard) {
                if (this.enemyBoard[targetY][targetX] <= 0) {
                    this.enemyBoard[targetY][targetX] = -2;
                } else {
                    this.enemyBoard[targetY][targetX] = -2;
                    int hitID = this.getHitShipID(targetX, targetY, this.enemyShips);
                    this.checkShipDestroyedByID(this.enemyBoard, hitID, this.enemyShips);
                }
                this.changeTurn(false);
            }
            if (!isTraining) {
                this.VIEW_CHANGE_TIME = 1500;
                this.lastShotTime = System.currentTimeMillis();
                this.sendShotParams(this.cursorX, this.cursorY);
            }
        }
    }

    public void enemyShot(int x, int y) {
        this.showMyBoard = true;
        if (this.myBoard[y][x] <= 0) {
            this.myBoard[y][x] = -2;
        } else {
            this.myBoard[y][x] = -2;
            int hitID = this.getHitShipID(x, y, this.myShips);
            this.checkShipDestroyedByID(this.myBoard, hitID, this.myShips);
        }
    }

    public void AIShot() {
        if (!this.isHunt) {
            this.rX = this.getRandom(0, 9);
            this.rY = this.getRandom(0, 9);
        }
        int hitID = 0;
        if (this.tryCntr > 10) {
            block0: for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    if (this.myBoard[i][j] == -2) continue;
                    this.rX = j;
                    this.rY = i;
                    this.tryCntr = 0;
                    continue block0;
                }
            }
        }
        if (this.isHunt) {
            if (this.AIorient == 0) {
                this.rX = this.lastHitX;
                this.rY = this.lastHitY - 1;
                if (this.rY < 0 || this.myBoard[this.rY][this.rX] == -2) {
                    if (this.hitsInRow < 2) {
                        this.AIorient = 1;
                        this.rX = this.lastHitX + 1;
                        this.rY = this.lastHitY;
                    } else {
                        this.AIorient = 2;
                        this.rX = this.lastHitX;
                        this.rY = this.lastHitY + 1;
                    }
                    this.lastHitX = this.firstHitX;
                    this.lastHitY = this.firstHitY;
                }
            } else if (this.AIorient == 1) {
                this.rX = this.lastHitX + 1;
                this.rY = this.lastHitY;
                if (this.rX > 9 || this.myBoard[this.rY][this.rX] == -2) {
                    if (this.hitsInRow < 2) {
                        this.AIorient = 2;
                        this.rX = this.lastHitX;
                        this.rY = this.lastHitY + 1;
                    } else {
                        this.AIorient = 3;
                        this.rX = this.lastHitX - 1;
                        this.rY = this.lastHitY;
                    }
                    this.lastHitX = this.firstHitX;
                    this.lastHitY = this.firstHitY;
                }
            } else if (this.AIorient == 2) {
                this.rX = this.lastHitX;
                this.rY = this.lastHitY + 1;
                if (this.rY > 9 || this.myBoard[this.rY][this.rX] == -2) {
                    if (this.hitsInRow < 2) {
                        this.AIorient = 3;
                        this.rX = this.lastHitX - 1;
                        this.rY = this.lastHitY;
                    } else {
                        this.AIorient = 0;
                        this.rX = this.lastHitX;
                        this.rY = this.lastHitY - 1;
                    }
                    this.lastHitX = this.firstHitX;
                    this.lastHitY = this.firstHitY;
                }
            } else if (this.AIorient == 3) {
                this.rX = this.lastHitX - 1;
                this.rY = this.lastHitY;
                if (this.rX < 0 || this.myBoard[this.rY][this.rX] == -2) {
                    if (this.hitsInRow < 2) {
                        this.AIorient = 0;
                        this.rX = this.lastHitX;
                        this.rY = this.lastHitY - 1;
                    } else {
                        this.AIorient = 1;
                        this.rX = this.lastHitX + 1;
                        this.rY = this.lastHitY;
                    }
                    this.lastHitX = this.firstHitX;
                    this.lastHitY = this.firstHitY;
                }
            }
            if (this.rX < 0 || this.rY < 0 || this.rX > 9 || this.rY > 9) {
                this.AIorient = this.AIorient < 3 ? ++this.AIorient : 0;
                this.AIShot();
            }
        }
        if (this.myBoard[this.rY][this.rX] != -2) {
            if (this.myBoard[this.rY][this.rX] <= 0) {
                if (this.isHunt) {
                    this.wasHit = false;
                    if (this.hitsInRow < 2) {
                        this.AIorient = this.AIorient < 3 ? ++this.AIorient : 0;
                    } else if (this.AIorient == 0) {
                        this.AIorient = 2;
                    } else if (this.AIorient == 1) {
                        this.AIorient = 3;
                    } else if (this.AIorient == 2) {
                        this.AIorient = 0;
                    } else if (this.AIorient == 3) {
                        this.AIorient = 1;
                    }
                    this.lastHitX = this.firstHitX;
                    this.lastHitY = this.firstHitY;
                } else {
                    this.AIorient = 0;
                }
                this.myBoard[this.rY][this.rX] = -2;
            } else {
                this.myBoard[this.rY][this.rX] = -2;
                hitID = this.getHitShipID(this.rX, this.rY, this.myShips);
                ++this.hitsInRow;
                if (!this.isHunt) {
                    this.firstHitX = this.rX;
                    this.firstHitY = this.rY;
                    this.AIorient = 0;
                }
                this.wasHit = true;
                this.isHunt = true;
                this.lastHitX = this.rX;
                this.lastHitY = this.rY;
                if (this.checkShipDestroyedByID(this.myBoard, hitID, this.myShips)) {
                    this.wasHit = false;
                    this.isHunt = false;
                    this.hitsInRow = 0;
                }
            }
            this.tryCntr = 0;
        } else {
            this.AIShot();
            ++this.tryCntr;
        }
    }

    public int getHitShipID(int x, int y, Ship[] ships) {
        for (int i = 0; i < ships.length; ++i) {
            for (int k = 0; k < ships[i].type; ++k) {
                if (ships[i].shipParts[k][0] != x || ships[i].shipParts[k][1] != y) continue;
                System.out.println("znalazlem id: " + ships[i].id);
                ships[i].shipParts[k][2] = 0;
                ships[i].animFrame = 0;
                return ships[i].id;
            }
        }
        return -1;
    }

    public boolean checkShipDestroyedByID(int[][] board, int id, Ship[] ships) {
        int length = 0;
        for (int i = 0; i < ships.length; ++i) {
            if (ships[i].id != id) continue;
            for (int k = 0; k < ships[i].type; ++k) {
                if (ships[i].shipParts[k][2] != 1) continue;
                return false;
            }
            ships[i].destroyed = true;
            int shipX = ships[i].posX;
            int shipY = ships[i].posY;
            int orient = ships[i].orientation;
            length = ships[i].type;
            for (int l = 0; l < length; ++l) {
                int n;
                int m;
                if (orient == 0) {
                    m = l;
                    n = 0;
                } else {
                    m = 0;
                    n = l;
                }
                if (shipX + 1 + m <= 9) {
                    board[shipY + n][shipX + 1 + m] = -2;
                }
                if (shipX - 1 + m >= 0) {
                    board[shipY + n][shipX - 1 + m] = -2;
                }
                if (shipY + 1 + n <= 9) {
                    board[shipY + 1 + n][shipX + m] = -2;
                }
                if (shipY - 1 + n >= 0) {
                    board[shipY - 1 + n][shipX + m] = -2;
                }
                if (shipX + 1 + m <= 9 && shipY - 1 + n >= 0) {
                    board[shipY - 1 + n][shipX + 1 + m] = -2;
                }
                if (shipY + 1 + n <= 9 && shipX + 1 + m <= 9) {
                    board[shipY + 1 + n][shipX + 1 + m] = -2;
                }
                if (shipX - 1 + m >= 0 && shipY - 1 + n >= 0) {
                    board[shipY - 1 + n][shipX - 1 + m] = -2;
                }
                if (shipY + 1 + n > 9 || shipX - 1 + m < 0) continue;
                board[shipY + 1 + n][shipX - 1 + m] = -2;
            }
        }
        return true;
    }

    public boolean checkCollision() {
        int length = this.myShips[this.currShipNr].type;
        if (this.myShips[this.currShipNr].orientation == 0) {
            for (int k = 0; k < length; ++k) {
                if (this.myBoard[this.myShips[this.currShipNr].posY][this.myShips[this.currShipNr].posX + k] == 0) continue;
                return true;
            }
        } else {
            for (int k = 0; k < length; ++k) {
                if (this.myBoard[this.myShips[this.currShipNr].posY + k][this.myShips[this.currShipNr].posX] == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void keyReleased(int keyCode) {
    }

    public void startUp() {
        this.inGameMenu.isActive = false;
        this.inGameMenu.menu = this.inGameMenu.pauseMenu;
        this.inGameMenu.updateGameMenu();
        this.TIMER = this.TIMER_LIMIT;
        this.inGameMenu.updateSettings();
        this.gameEndArrived = false;
        this.roundCounter = 1;
        this.rematchSent = false;
    }

    public void run() {
        boolean frame = false;
        while (this.isActive) {
            long startTime = System.currentTimeMillis();
            if (gameState == PLAYING) {
                try {
                    if (System.currentTimeMillis() - this.lastLightTime > 1000L) {
                        DeviceControl.setLights((int)0, (int)100);
                        this.lastLightTime = System.currentTimeMillis();
                    }
                    if (!isTraining && this.VIEW_CHANGE_TIME != 0 && System.currentTimeMillis() - this.lastShotTime > (long)this.VIEW_CHANGE_TIME) {
                        this.showMyBoard = !this.showMyBoard;
                        this.VIEW_CHANGE_TIME = 0;
                        this.showGameEnd();
                    }
                    if (System.currentTimeMillis() - this.lastTimerTime > 1000L && !this.gameEndArrived) {
                        if (this.TIMER > 0) {
                            --this.TIMER;
                            if (isTraining && !this.myTurn && !this.setShips && this.TIMER < this.TIMER_LIMIT - 1) {
                                this.checkGameEnd();
                                this.showMyBoard = true;
                                if (this.TIMER < this.TIMER_LIMIT - 2) {
                                    this.AIShot();
                                    this.lastAiShotTime = System.currentTimeMillis();
                                    this.changeTurn(false);
                                    this.wasAutoChange = false;
                                }
                            }
                        } else if (this.setShips) {
                            this.placeShipsRandomly(this.myBoard, this.myShips);
                        } else if (!isTraining && this.myTurn) {
                            this.changeTurn(true);
                            this.sendChangeTurn();
                        }
                        if (!this.wasAutoChange && isTraining && System.currentTimeMillis() - this.lastAiShotTime > 1000L && this.myTurn && !this.setShips) {
                            this.checkGameEnd();
                            this.showMyBoard = false;
                            this.lastAiShotTime = System.currentTimeMillis();
                            this.wasAutoChange = true;
                        }
                        this.lastTimerTime = System.currentTimeMillis();
                    }
                    for (int i = 0; i < 10; ++i) {
                        this.myShips[i].update();
                        this.enemyShips[i].update();
                    }
                    if (this.gameEndArrived && !this.wasEndShown && System.currentTimeMillis() - this.gameEndArrivedTime > 500L) {
                        this.showGameEnd();
                        this.wasEndShown = true;
                    }
                    this.repaint();
                    this.serviceRepaints();
                }
                catch (Exception ex) {
                    System.out.print("blad w run: " + ex);
                    ex.printStackTrace();
                }
            }
            long currentTime = System.currentTimeMillis();
            if (this.lastTime == -1L) {
                this.lastTime = currentTime;
                continue;
            }
            this.deltaTime = (int)(currentTime - this.lastTime);
            this.lastTime = currentTime;
            if (this.inGameMenu != null && this.inGameMenu.isActive) {
                this.inGameMenu.handleInput();
                this.inGameMenu.update(this.deltaTime);
                this.repaint();
            }
            try {
                long delayTime = this.sleepTime - (System.currentTimeMillis() - startTime);
                if (delayTime < this.sleepTime) {
                    delayTime = this.sleepTime;
                }
                Thread.sleep(delayTime);
            }
            catch (Exception e) {}
        }
    }

    public void changeTurn(boolean mod) {
        this.myTurn = !this.myTurn;
        if (!isTraining && mod) {
            if (!this.showMyBoard && !this.myTurn) {
                this.showMyBoard = true;
            }
            if (this.showMyBoard && this.myTurn) {
                this.showMyBoard = false;
            }
        }
        this.TIMER = this.TIMER_LIMIT;
        this.RANDOM_AI_TIME = 3;
    }

    public void checkGameEnd() {
        int i;
        int cntr1 = 0;
        int cntr2 = 0;
        for (i = 0; i <= 9; ++i) {
            if (!this.myShips[i].destroyed) continue;
            ++cntr1;
        }
        for (i = 0; i <= 9; ++i) {
            if (!this.enemyShips[i].destroyed) continue;
            ++cntr2;
        }
        if (cntr1 == 10) {
            this.inGameMenu.isActive = true;
            this.inGameMenu.setScore(2);
            this.inGameMenu.createScoreMenu(this.endInfo, this.rematchPossible);
            this.inGameMenu.menu = this.inGameMenu.scoreMenu;
        }
        if (cntr2 == 10) {
            this.inGameMenu.isActive = true;
            this.inGameMenu.setScore(1);
            this.inGameMenu.createScoreMenu(this.endInfo, this.rematchPossible);
            this.inGameMenu.menu = this.inGameMenu.scoreMenu;
        }
    }

    public void showGameEnd() {
        if (this.gameEndArrived) {
            this.inGameMenu.isActive = true;
            this.inGameMenu.setScore(Globals.endGameType);
            this.inGameMenu.createScoreMenu(this.endInfo, this.rematchPossible);
            this.inGameMenu.menu = this.inGameMenu.scoreMenu;
        }
    }

    public void repaintInGameMenu(Graphics g) {
    }

    public void paint(Graphics g) {
        try {
            if (gameState == PLAYING) {
                g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                g.setColor(0x999999);
                g.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                this.paintBoard(g);
                if (this.showMyBoard) {
                    for (int i = 0; i < this.currShipNr + 1; ++i) {
                        this.myShips[i].paint(g, i);
                    }
                } else {
                    for (int i = 0; i < 10; ++i) {
                        this.enemyShips[i].paint(g, i);
                    }
                }
                if (!this.showMyBoard && this.myTurn) {
                    g.setColor(0xFF0000);
                    g.drawRect(this.cursorX * this.TILE_SIZE, this.cursorY * this.TILE_SIZE, this.TILE_SIZE, this.TILE_SIZE);
                    g.drawImage(this.imgTarget, this.cursorX * this.TILE_SIZE, this.cursorY * this.TILE_SIZE, 0);
                }
            }
            g.translate(-g.getTranslateX(), -g.getTranslateY());
            if (this.showShipsLeft) {
                this.paintShipsLeft(g);
            }
            g.drawImage(this.imgHud, 0, this.SCREEN_HEIGHT - this.imgHudHeight, 0);
            if (System.currentTimeMillis() - this.fireButtonStartTime < 1000L) {
                g.drawImage(this.imgButton, 18, this.SCREEN_HEIGHT - this.imgHudHeight + 18, 0);
            } else {
                g.drawImage(this.imgButton_unpressed, 18, this.SCREEN_HEIGHT - this.imgHudHeight + 18, 0);
            }
            TanksMIDlet.textRenderer.renderText(g, 90, 273, Globals.playerNickname);
            if (isTraining) {
                TanksMIDlet.textRenderer.renderText(g, 90, 293, Texts.AI);
            } else {
                TanksMIDlet.textRenderer.renderText(g, 90, 293, Globals.enemyNickname);
            }
            if (this.imgArrow == null) {
                TanksMIDlet.textRenderer.renderText(g, 90, 100, new StringBuffer("imgArrow = null"));
            }
            if (this.myTurn) {
                g.drawImage(this.imgArrow, 73, 273, 0);
                TanksMIDlet.textRenderer.renderText(g, this.SCREEN_WIDTH / 2 - TanksMIDlet.textRenderer.getStringWidth(Integer.toString(this.TIMER).length()) + 56, 273, new StringBuffer("" + this.TIMER));
            } else {
                g.drawImage(this.imgArrow, 73, 293, 0);
                TanksMIDlet.textRenderer.renderText(g, this.SCREEN_WIDTH / 2 - TanksMIDlet.textRenderer.getStringWidth(Integer.toString(this.TIMER).length()) + 56, 293, new StringBuffer("" + this.TIMER));
            }
            if (this.showMyBoard) {
                g.drawImage(this.imgSelector, 85, this.SCREEN_HEIGHT - this.imgHudHeight + 1, 0);
            } else {
                g.drawImage(this.imgSelector, 85, this.SCREEN_HEIGHT - this.imgHudHeight + 21, 0);
            }
            g.drawImage(this.imgHudPause, this.SCREEN_WIDTH - this.imgHudPause.getWidth(), this.SCREEN_HEIGHT - this.imgHudPause.getHeight(), 0);
            g.setColor(0xFFFFFF);
            TanksMIDlet.textRenderer.setCurrentFont(this.midlet.fontInGame);
            if (this.inGameMenu != null) {
                this.inGameMenu.render(g);
            }
        }
        catch (Exception ex) {
            System.out.println("BlAD W PAINT" + ex);
            TanksMIDlet.textRenderer.renderTextWordBreak(g, 10, 10, this.SCREEN_WIDTH, this.SCREEN_HEIGHT, 0, new StringBuffer("p: " + ex), true);
        }
    }

    public void paintBoard(Graphics g) {
        int size = this.imgMyTile.getHeight();
        int trans_x = (this.SCREEN_WIDTH - 10 * size) / 2;
        int trans_y = (this.SCREEN_HEIGHT - this.imgHudHeight - 10 * size) / 2;
        int ax = (this.imgMyTile.getHeight() - TanksMIDlet.textRenderer.getStringWidth(1)) / 2;
        int bx = (this.imgMyTile.getHeight() - TanksMIDlet.textRenderer.getStringHeight(1)) / 2;
        int mx = (this.TILE_SIZE - this.imgMiss.getHeight()) / 2;
        g.translate(trans_x, trans_y);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.myBoard[j][i] == -1 && this.setShips) {
                    g.drawImage(this.imgOppTile, i * size, j * size, 0);
                    continue;
                }
                if (this.showMyBoard) {
                    g.drawImage(this.imgMyTile, i * size, j * size, 0);
                    if (this.myBoard[j][i] != -2) continue;
                    g.drawImage(this.imgMiss, i * size + mx, j * size + mx, 0);
                    continue;
                }
                g.drawImage(this.imgOppTile, i * size, j * size, 0);
                if (this.enemyBoard[j][i] != -2) continue;
                g.drawImage(this.imgMiss, i * size + mx, j * size + mx, 0);
            }
            TanksMIDlet.textRenderer.renderText(g, ax + i * size, -TanksMIDlet.textRenderer.getStringHeight(1) - 1 * this.SCREEN_WIDTH / 100, new StringBuffer("" + this.charsArray[i]));
            TanksMIDlet.textRenderer.renderText(g, -TanksMIDlet.textRenderer.getStringWidth(1) - 1 * this.SCREEN_WIDTH / 100, i * size + bx, new StringBuffer("" + i));
        }
    }

    public void paintShipsLeft(Graphics g) {
        int i;
        int trans = 0;
        int fontHeight = TanksMIDlet.textRenderer.getStringHeight(1) + 4;
        int trans_y = (320 - (4 * (this.ships[0][0].getHeight() + 4) + fontHeight)) / 2;
        g.drawImage(this.imgShipsLeft, this.SCREEN_WIDTH / 2, this.SCREEN_HEIGHT / 2, 3);
        TanksMIDlet.textRenderer.renderText(g, this.SCREEN_WIDTH / 2 - TanksMIDlet.textRenderer.getStringWidth(Texts.SHIPS_LEFT.length()) / 2, trans_y, Texts.SHIPS_LEFT);
        trans = (240 - 4 * (this.ships[0][0].getWidth() + 2)) / 2;
        for (i = 0; i < 4; ++i) {
            if (this.enemyShips[9 - i].destroyed) {
                g.drawImage(this.ships[0][3], i * (this.ships[0][0].getWidth() + 2) + trans, fontHeight + trans_y, 0);
                continue;
            }
            g.drawImage(this.ships[0][0], i * (this.ships[0][0].getWidth() + 2) + trans, fontHeight + trans_y, 0);
        }
        trans = (240 - 3 * (this.ships[1][0].getWidth() + 2)) / 2;
        for (i = 0; i < 3; ++i) {
            if (this.enemyShips[5 - i].destroyed) {
                g.drawImage(this.ships[1][3], i * (this.ships[1][0].getWidth() + 2) + trans, fontHeight + this.ships[1][0].getHeight() + 4 + trans_y, 0);
                continue;
            }
            g.drawImage(this.ships[1][0], i * (this.ships[1][0].getWidth() + 2) + trans, fontHeight + this.ships[1][0].getHeight() + 4 + trans_y, 0);
        }
        trans = (240 - 2 * (this.ships[2][0].getWidth() + 2)) / 2;
        for (i = 0; i < 2; ++i) {
            if (this.enemyShips[2 - i].destroyed) {
                g.drawImage(this.ships[2][3], i * (this.ships[2][0].getWidth() + 2) + trans, fontHeight + 2 * (this.ships[2][0].getHeight() + 4) + trans_y, 0);
                continue;
            }
            g.drawImage(this.ships[2][0], i * (this.ships[2][0].getWidth() + 2) + trans, fontHeight + 2 * (this.ships[2][0].getHeight() + 4) + trans_y, 0);
        }
        trans = (240 - 1 * (this.ships[3][0].getWidth() + 2)) / 2;
        if (this.enemyShips[0].destroyed) {
            g.drawImage(this.ships[3][3], trans, fontHeight + 3 * (this.ships[3][0].getHeight() + 4) + trans_y, 0);
        } else {
            g.drawImage(this.ships[3][0], trans, fontHeight + 3 * (this.ships[3][0].getHeight() + 4) + trans_y, 0);
        }
    }

    public static void gradientBox(Graphics g, int color1, int color2, int left, int top, int width, int height, int orientation) {
        int max = orientation == 0 ? height : width;
        for (int i = 0; i < max; ++i) {
            int color = TanksCanvas.midColor(color1, color2, max * (max - 1 - i) / (max - 1), max);
            g.setColor(color);
            if (orientation == 0) {
                g.drawLine(left, top + i, left + width - 1, top + i);
                continue;
            }
            g.drawLine(left + i, top, left + i, top + height - 1);
        }
    }

    static int midColor(int color1, int color2, int prop, int max) {
        int red = ((color1 >> 16 & 0xFF) * prop + (color2 >> 16 & 0xFF) * (max - prop)) / max;
        int green = ((color1 >> 8 & 0xFF) * prop + (color2 >> 8 & 0xFF) * (max - prop)) / max;
        int blue = ((color1 >> 0 & 0xFF) * prop + (color2 >> 0 & 0xFF) * (max - prop)) / max;
        int color = 0 | red << 16 | green << 8 | blue;
        return color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void gameStep(TanksGameState state, String msg) {
        try {
            if (this.lastSent != null && state.getReceiver() == RECEIVER) {
                return;
            }
            if (Math.abs(state.getMessage()) == 100) {
                this.myTurn = state.getMessage() > 0;
                RECEIVER = this.clientInterface.isGameHosted() ? JOIN_PLAYER : HOST_PLAYER;
                this.inGameMenu.isActive = false;
                this.inGameMenu.menu = this.inGameMenu.pauseMenu;
                this.fillEnemyData(state, msg);
                this.TIMER = this.TIMER_LIMIT;
                this.setShips = false;
                this.showMyBoard = !this.myTurn;
                return;
            }
            if (state.getMessage() == 101) {
                this.changeTurn(true);
                return;
            }
            if (state.getMessage() == 102) {
                this.enemyShot(state.getX(), state.getY());
                this.changeTurn(false);
                this.VIEW_CHANGE_TIME = 1500;
                this.lastShotTime = System.currentTimeMillis();
                return;
            }
            if (state.getMessage() == 104) {
                if (!this.rematchSent) {
                    this.rematchWanted();
                } else {
                    this.inGameMenu.menu = this.inGameMenu.initializingMenu;
                    if (this.clientInterface.isGameHosted()) {
                        RECEIVER = JOIN_PLAYER;
                        this.startUp();
                        this.sendStartParams(this.myShips);
                    } else {
                        RECEIVER = HOST_PLAYER;
                    }
                }
            }
            if (state.getMessage() == 105) {
                this.startGame();
            }
            if (state.getMessage() == 106) {
                this.inGameMenu.menu = this.inGameMenu.noRematchMenu;
            }
            if (state.getMessage() != 107) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendStartParams(Ship[] ships) {
        int x1 = ships[0].posX + 1;
        int y1 = ships[0].posY;
        if (ships[0].orientation == 1) {
            x1 = -x1;
        }
        int x2 = ships[1].posX + 1;
        int y2 = ships[1].posY;
        if (ships[1].orientation == 1) {
            x2 = -x2;
        }
        int x3 = ships[2].posX + 1;
        int y3 = ships[2].posY;
        if (ships[2].orientation == 1) {
            x3 = -x3;
        }
        int x4 = ships[3].posX + 1;
        int y4 = ships[3].posY;
        if (ships[3].orientation == 1) {
            x4 = -x4;
        }
        int x5 = ships[4].posX + 1;
        int y5 = ships[4].posY;
        if (ships[4].orientation == 1) {
            x5 = -x5;
        }
        int x6 = ships[5].posX + 1;
        int y6 = ships[5].posY;
        if (ships[5].orientation == 1) {
            x6 = -x6;
        }
        int x7 = ships[6].posX + 1;
        int y7 = ships[6].posY;
        if (ships[6].orientation == 1) {
            x7 = -x7;
        }
        int x8 = ships[7].posX + 1;
        int y8 = ships[7].posY;
        if (ships[7].orientation == 1) {
            x8 = -x8;
        }
        int x9 = ships[8].posX + 1;
        int y9 = ships[8].posY;
        if (ships[8].orientation == 1) {
            x9 = -x9;
        }
        int x10 = ships[9].posX + 1;
        int y10 = ships[9].posY;
        if (ships[9].orientation == 1) {
            x10 = -x10;
        }
        try {
            this.lastSent = new TanksGameState(RECEIVER, 107, x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6, x7, y7, x8, y8, x9, y9, x10, y10);
            this.clientInterface.sendGameState(this.lastSent.toGameStateString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendStartSignal() {
    }

    public void sendChangeTurn() {
        try {
            System.out.println("wysylam change turn");
            this.lastSent = new TanksGameState(RECEIVER, 101, 0, 0);
            this.clientInterface.sendGameState(this.lastSent.toGameStateString2());
            this.TIMER = this.TIMER_LIMIT;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendShotParams(int x, int y) {
        try {
            this.lastSent = new TanksGameState(RECEIVER, 102, x, y);
            this.clientInterface.sendGameState(this.lastSent.toGameStateString2());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendRematchRequest() {
        try {
            this.rematchSent = true;
            this.lastSent = new TanksGameState(RECEIVER, 104, 0, 0);
            this.clientInterface.sendGameState(this.lastSent.toGameStateString2());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendRematchAnswer(boolean accepted) {
        try {
            this.lastSent = accepted ? new TanksGameState(-1, 105, 0, 0) : new TanksGameState(-1, 106, 0, 0);
            this.clientInterface.sendGameState(this.lastSent.toGameStateString2());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void OnMessage(String msg) {
        try {
            System.out.println("String msg: " + msg);
            TanksGameState gs = TanksGameState.fromGameStateString(msg);
            this.gameStep(gs, msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void OnMessage(int msg) {
        System.out.println("ON MSG: " + msg);
        switch (msg) {
            case 19: {
                break;
            }
            case 33: {
                break;
            }
            case 7: {
                this.gameEndArrived = true;
                this.gameEndArrivedTime = System.currentTimeMillis();
                System.out.println("GAME END ARRIVED");
                switch (Globals.endGameType) {
                    case 1: {
                        this.rematchPossible = true;
                        this.endInfo = Texts.WIN;
                        break;
                    }
                    case 2: {
                        this.rematchPossible = true;
                        this.endInfo = Texts.LOST;
                        break;
                    }
                    case 3: {
                        this.rematchPossible = false;
                        this.endInfo = Texts.WIN_PLAYER_KICKED;
                        break;
                    }
                    case 4: {
                        this.rematchPossible = false;
                        this.endInfo = Texts.LOSE_PLAYER_KICKED;
                        break;
                    }
                    case 20: {
                        this.rematchPossible = false;
                        this.endInfo = Texts.WIN_PLAYER_ESCAPED;
                        break;
                    }
                    case 21: {
                        this.rematchPossible = false;
                        this.endInfo = Texts.LOSE_PLAYER_ESCAPED;
                        break;
                    }
                    case 5: {
                        this.rematchPossible = true;
                        this.endInfo = Texts.DRAW;
                    }
                }
                break;
            }
            case 32: {
                break;
            }
            case 90: {
                this.inGameMenu.menu = this.inGameMenu.connectionTerminatedInfoMenu;
                this.inGameMenu.isActive = true;
                break;
            }
        }
    }

    public void quitGame(boolean sendGameState) {
        backFromOnline = !this.isTrainingMode;
        this.mainGameCanvas.requestAppStateChange("MainMenu");
        gameState = STOPPED;
        this.inGameMenu.isActive = false;
        this.inGameMenu.menu = this.inGameMenu.pauseMenu;
        Music.stopMusic();
        Music.playMusic(TanksMIDlet.menuMusicId);
        this.setOnDisplay(false);
        this.freeMemory();
    }

    public void OnGameStarted() {
        try {
            this.clientInterface = ClientInterface.GetInstance();
            this.clientInterface.SetMsgReceiver(this);
            RECEIVER = this.clientInterface.isGameHosted() ? JOIN_PLAYER : HOST_PLAYER;
            this.startGame();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleInput() {
    }

    public void pauseStateChanged(boolean paused) {
    }

    public void deinitialize() {
    }

    public void disconnect() {
        if (ClientInterface.GetInstance() != null && ClientInterface.GetInstance().IsConnected()) {
            try {
                ClientInterface.GetInstance().gameLeave();
            }
            catch (Exception ex) {
                System.out.println("!!!!!!" + ex);
            }
            try {
                ClientInterface.GetInstance().roomLeave();
            }
            catch (Exception ex) {
                System.out.println("!!!!!!" + ex);
            }
        }
    }

    public void rematchWanted() {
        this.inGameMenu.menu = this.inGameMenu.rematchMenu;
        this.inGameMenu.isActive = true;
    }

    public void NoRematch() {
        this.inGameMenu.menu = this.inGameMenu.noRematchMenu;
        this.inGameMenu.isActive = true;
    }

    public void freeMemory() {
        System.gc();
    }

    public void setOnDisplay(boolean toGame) {
        if (toGame) {
            this.midlet.display.setCurrent((Displayable)this);
        } else {
            this.midlet.display.setCurrent((Displayable)this.mainGameCanvas);
        }
    }

    public int getRandom(int a, int b) {
        return a + Math.abs(this.random.nextInt()) % (1 + b - a);
    }

    public int getRandomNegative(int a, int b) {
        if (this.random.nextInt(2) == 0) {
            return (int)((double)a + this.random.nextDouble() * (double)(b - a));
        }
        return -((int)((double)a + this.random.nextDouble() * (double)(b - a)));
    }
}

