/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ControlGroup {
    public Enemy[] enemy = new Enemy[3];
    private boolean[][] active;
    private static final int[] ACTION_LEVEL = new int[]{1, 2, 3, 1, 2, 3, 3, 3};
    private static final int[] POS_PLA_LEVEL = new int[]{2, 2, 1, 2, 1, 2, 2, 1};

    public ControlGroup(Stage stage) {
        Image img = null;
        try {
            img = Image.createImage((String)"/monster.png");
        }
        catch (IOException e) {
            System.out.println("no se cargo la imagen");
        }
        this.enemy[0] = new Enemy(img);
        this.enemy[1] = new Enemy(img);
        this.enemy[2] = new Enemy(img);
        this.active = new boolean[stage.getNumCuadros()][this.enemy.length];
        for (int n = 0; n < stage.getNumCuadros(); ++n) {
            for (int i = 0; i < this.enemy.length; ++i) {
                this.active[n][i] = true;
            }
        }
    }

    public void init(Stage stage) {
        int n;
        for (n = 0; n < this.enemy.length; ++n) {
            this.enemy[n].level = 0;
            this.enemy[n].changeType();
            this.enemy[n].reset(stage, n + POS_PLA_LEVEL[Interface.level], ACTION_LEVEL[Interface.level], true);
        }
        this.active = new boolean[stage.getNumCuadros()][this.enemy.length];
        for (n = 0; n < stage.getNumCuadros(); ++n) {
            for (int i = 0; i < this.enemy.length; ++i) {
                this.active[n][i] = true;
            }
        }
    }

    public void move(Stage stage, int xPlayer, Explosion explo) {
        for (int n = 0; n < this.enemy.length; ++n) {
            if (this.enemy[n].active) {
                this.enemy[n].move(stage, xPlayer, explo);
            }
            if (this.enemy[n].level == stage.plataforma[n + ControlGroup.POS_PLA_LEVEL[Interface.level]].level) continue;
            if (this.enemy[n].level >= 0) {
                if (this.active[stage.plataforma[n + ControlGroup.POS_PLA_LEVEL[Interface.level]].level][n]) {
                    if (!this.enemy[n].active) {
                        this.enemy[n].reset(stage, n + POS_PLA_LEVEL[Interface.level], ACTION_LEVEL[Interface.level], true);
                        continue;
                    }
                    if (this.enemy[n].getX() + this.enemy[n].getWidth() >= 0 && this.enemy[n].getX() <= Interface.SCREEN_W) continue;
                    this.enemy[n].reset(stage, n + POS_PLA_LEVEL[Interface.level], ACTION_LEVEL[Interface.level], true);
                    continue;
                }
                if (!this.enemy[n].active) {
                    this.enemy[n].reset(stage, n + POS_PLA_LEVEL[Interface.level], ACTION_LEVEL[Interface.level], false);
                    continue;
                }
                if (this.enemy[n].getX() + this.enemy[n].getWidth() >= 0 && this.enemy[n].getX() <= Interface.SCREEN_W) continue;
                this.enemy[n].reset(stage, n + POS_PLA_LEVEL[Interface.level], ACTION_LEVEL[Interface.level], false);
                continue;
            }
            this.enemy[n].reset(stage, n + POS_PLA_LEVEL[Interface.level], ACTION_LEVEL[Interface.level], true);
        }
    }

    public void offEnemy(int index) {
        this.active[this.enemy[index].level][index] = false;
    }

    public void move(int incX, int incY) {
        for (int n = 0; n < this.enemy.length; ++n) {
            if (!this.enemy[n].active) continue;
            this.enemy[n].move(incX, incY);
        }
    }

    public void draw(Graphics g) {
        for (int n = 0; n < this.enemy.length; ++n) {
            if (!this.enemy[n].active) continue;
            this.enemy[n].draw(g);
        }
    }

    public void activeEnemy(Stage stage, int posX) {
        for (int n = 0; n < this.enemy.length; ++n) {
            if (this.enemy[n].getX() >= 0 && this.enemy[n].getX() + this.enemy[n].getWidth() <= Interface.SCREEN_W && this.enemy[n].active) continue;
            this.enemy[n].activeFromEnemy(posX, -40);
            return;
        }
    }
}

