/*
 * Decompiled with CFR 0.152.
 */
package com.george.games.menus;

import com.george.games.Drawable;
import com.george.games.Tasks;
import com.george.games.menus.Help;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Main;
import com.george.headfall.Setting;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.Viewport;
import com.george.headfall.res.ResMenu;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class MainMenu
implements Drawable {
    private Image offline = Image.createImage((int)Viewport.WIDTH, (int)Viewport.HEIGHT);
    private Sprite pointer;
    private Sprite sound;
    private Sprite newGame;
    private Sprite continueGame;
    private Sprite exit;
    private Sprite help;
    private Sprite fullVersion;
    private Sprite facebook;
    private Sprite twitter;
    private Vector vecSprites;
    private int menuX = 35;
    private int menuY = 5;
    private Setting setting;
    private int selectedIndex;

    public MainMenu() {
        SoundsPlayer.getInstance().runMain();
        this.setting = Setting.getInstance();
        this.pointer = new Sprite(Image.createImage((int)5, (int)5));
        this.pointer.setPosition(-5, -5);
        this.sound = this.setting.isSound() ? ResMenu.soundOff : ResMenu.soundOn;
        this.help = ResMenu.HELP;
        this.help.setPosition(180, 14);
        this.newGame = ResMenu.newGame;
        this.continueGame = ResMenu.continueGame;
        this.exit = ResMenu.exit;
        this.sound.setFrame(0);
        this.newGame.setFrame(0);
        this.continueGame.setFrame(0);
        this.exit.setFrame(0);
        this.newGame.setPosition(this.menuX, this.menuY);
        this.facebook = HeadFallRes.FACEBOOK;
        this.facebook.setPosition(Viewport.WIDTH - this.facebook.getWidth() + 3, 140);
        this.twitter = HeadFallRes.TWITTER;
        this.twitter.setPosition(Viewport.WIDTH - this.twitter.getWidth() + 3, 140 + this.facebook.getHeight());
        if (this.setting.getLevel() > 0) {
            this.continueGame.setPosition(this.menuX, this.menuY + this.newGame.getHeight() + 1);
            this.sound.setPosition(this.menuX, this.menuY + 2 * this.newGame.getHeight() + 2);
            this.exit.setPosition(93, 260);
            this.vecSprites = new Vector();
            this.vecSprites.addElement(this.newGame);
            this.vecSprites.addElement(this.continueGame);
            this.vecSprites.addElement(this.sound);
            this.vecSprites.addElement(this.facebook);
            this.vecSprites.addElement(this.twitter);
            this.vecSprites.addElement(this.exit);
            this.vecSprites.addElement(this.help);
        } else {
            this.continueGame.setPosition(-300, -300);
            this.sound.setPosition(this.menuX, this.menuY + this.newGame.getHeight() + 1);
            this.exit.setPosition(93, 260);
            this.vecSprites = new Vector();
            this.vecSprites.addElement(this.newGame);
            this.vecSprites.addElement(this.sound);
            this.vecSprites.addElement(this.facebook);
            this.vecSprites.addElement(this.twitter);
            this.vecSprites.addElement(this.exit);
            this.vecSprites.addElement(this.help);
        }
        this.fullVersion = HeadFallRes.FULL_VERSION;
        this.fullVersion.setFrame(0);
        this.fullVersion.setPosition(214, 580);
        if (!Main.TRIAL) {
            this.fullVersion.setPosition(-300, -300);
        }
    }

    public void cycle() {
    }

    public void draw(Graphics gg) {
        Graphics g = this.offline.getGraphics();
        g.drawImage(ResMenu.MainBack, 0, 0, 0);
        this.newGame.paint(g);
        this.continueGame.paint(g);
        this.sound.paint(g);
        this.exit.paint(g);
        this.help.paint(g);
        this.fullVersion.paint(g);
        this.facebook.paint(g);
        this.twitter.paint(g);
        this.drawSelected(g);
        if (Main.container.getWidth() < Main.container.getHeight()) {
            gg.drawImage(this.offline, 0, 0, 0);
        } else {
            gg.drawImage(Image.createImage((Image)this.offline, (int)0, (int)0, (int)Viewport.WIDTH, (int)Viewport.HEIGHT, (int)6), 0, 0, 0);
        }
    }

    private void drawSelected(Graphics g) {
        if (Main.TOUCH_SUPPORT) {
            return;
        }
        Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
        g.setColor(16253967);
        g.drawRect(sp.getX(), sp.getY(), sp.getWidth() - 2, sp.getHeight() - 2);
        g.drawRect(sp.getX() + 1, sp.getY() + 1, sp.getWidth() - 4, sp.getHeight() - 4);
    }

    public void pointerPressed(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, false)) {
                sprite.setFrame(1 % sprite.getFrameSequenceLength());
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
        Main.container.repaint();
    }

    public void pointerReleased(int x, int y) {
        this.pointer.setPosition(x, y);
        if (this.pointer.collidesWith(this.newGame, false)) {
            this.setting.setLevel(0);
            this.setting.setPlayerScore(0);
            this.setting.save();
            Tasks.loadLevel(0).execute();
        } else if (this.pointer.collidesWith(this.sound, false)) {
            int index = this.vecSprites.indexOf(this.sound);
            this.setting.changeSound();
            this.setting.save();
            this.vecSprites.removeElement(this.sound);
            if (this.setting.isSound()) {
                SoundsPlayer.getInstance().restart();
                ResMenu.soundOff.setPosition(this.sound.getX(), this.sound.getY());
                this.sound = ResMenu.soundOff;
            } else {
                SoundsPlayer.getInstance().pause();
                ResMenu.soundOn.setPosition(this.sound.getX(), this.sound.getY());
                this.sound = ResMenu.soundOn;
            }
            this.vecSprites.insertElementAt(this.sound, index);
            this.resetAll();
        } else if (this.pointer.collidesWith(this.continueGame, false)) {
            Tasks.loadLevel(this.setting.getLevel()).execute();
            this.resetAll();
        } else if (this.pointer.collidesWith(this.help, false)) {
            Main.setCurrent(new Help(0));
            this.resetAll();
        } else if (this.pointer.collidesWith(this.fullVersion, false)) {
            Main.getFullVersion();
        } else if (this.pointer.collidesWith(this.facebook, false)) {
            Main.facebook();
        } else if (this.pointer.collidesWith(this.twitter, false)) {
            Main.twitter();
        } else if (this.pointer.collidesWith(this.exit, false)) {
            Main.exit();
        }
        this.resetAll();
        this.pointer.setPosition(-5, -5);
        Main.container.repaint();
    }

    public void pointerDragged(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, true)) {
                sprite.setFrame(1 % sprite.getFrameSequenceLength());
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
        Main.container.repaint();
    }

    private void resetAll() {
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            sprite.setFrame(0);
        }
    }

    public void keyPressed(int keyCode) {
        int k = Main.container.getGameAction(keyCode);
        if (k == 6) {
            this.selectedIndex = (this.selectedIndex + 1) % this.vecSprites.size();
        } else if (k == 1) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.vecSprites.size() - 1;
            }
        } else if (k == 8) {
            Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
            this.pointerReleased(sp.getX(), sp.getY());
        }
        Main.container.repaint();
    }

    public void input(int keyStates) {
    }
}

