/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.objects;

import com.inodesoft.game.GameEngine;
import com.inodesoft.game.objects.InvObject;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICResourceManager;
import javax.microedition.lcdui.Graphics;

public class InvAbductee
extends InvObject {
    public static final int AB_RANCHERO = 0;
    public static final int AB_MIB = 1;
    public static final int AB_MAN_AUS = 2;
    public static final int AB_GIRL_RUS = 3;
    public static final int AB_GIRL_FR = 4;
    public static final int AB_MAN_CH = 5;
    public static final int AB_GIRL_CH = 6;
    public static final int AB_MAN_BEACH = 7;
    public static final int AB_BOY_ARAB = 8;
    public static final int AB_MAN_ARAB = 9;
    public static final int AB_MAN_TEO = 10;
    public static final int AB_GIRL_TEO = 11;
    public static final int AB_MAN_COW = 12;
    public static final int NUM_ABDUCTEES = 13;
    public static final int STATE_IDLE = 0;
    public static final int STATE_WALKING = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_FLOATING = 3;
    public static final int STATE_DEAD = 4;
    public static final int[][] car_per_level = new int[][]{{12}, {7}, {0}, {2}, {8, 9}, {10, 11}, {5, 6}, {3}, {4}, {1}};
    static ICAnimation m_abductees = null;
    static int max_sprite_width = -1;
    public int m_type = -1;
    boolean abducted = false;
    boolean being_abducted = false;
    long abduct_start_time = 0L;

    public InvAbductee(GameEngine ge, int level) {
        super(ge);
        int type;
        if (m_abductees == null) {
            m_abductees = new ICAnimation(ICResourceManager.getInstance().getResourceAsStream("abductee.lqa"));
        }
        this.m_sprite = m_abductees;
        if (max_sprite_width == -1) {
            for (int i = 0; i < this.m_sprite.getNumSprites(); ++i) {
                if (max_sprite_width >= this.m_sprite.getSpriteWidth(i)) continue;
                max_sprite_width = this.m_sprite.getSpriteWidth(i);
            }
        }
        int ran_car = (int)(System.currentTimeMillis() % (long)car_per_level[level].length);
        this.m_type = type = car_per_level[level][ran_car];
        this.col_x = 0;
        this.col_y = 0;
        this.col_w = 30;
        this.col_h = 55;
        this.dir = 0;
    }

    public void setAbPosition(int x, int y) {
        super.setAbPosition(x, y);
        this.m_y_pos -= this.m_sprite.getFrameHeight(this.m_type, 0L);
    }

    public void paint(Graphics g, int world_offset) {
        if (this.abducted) {
            return;
        }
        this.m_x_pos = this.ab_pos_x + world_offset;
        if (this.m_x_pos < -max_sprite_width || this.m_x_pos > this.ge.getWidth() + max_sprite_width) {
            return;
        }
        if (this.being_abducted) {
            int py = this.ge.getPlayerY();
            int px = this.ge.getPlayerX() - (this.m_sprite.getFrameWidth(this.m_type) >> 1);
            int tdy = py - this.m_y_pos;
            int tdx = px - this.m_x_pos;
            long ltdy = tdy << 10;
            long ltdx = tdx << 10;
            long ldy = ltdy / 3000L;
            long ldx = ltdx / 3000L;
            int dy = (int)(ldy >> 10);
            int dx = (int)(ldx >> 10);
            long mypos = this.m_y_pos << 10;
            long mxpos = this.m_x_pos << 10;
            long curr_y_pos = mypos + ldy * (System.currentTimeMillis() - this.abduct_start_time);
            long curr_x_pos = mxpos + ldx * (System.currentTimeMillis() - this.abduct_start_time);
            this.m_sprite.drawAnimation(g, this.m_type + 26, System.currentTimeMillis(), (int)(curr_x_pos >> 10), (int)(curr_y_pos >> 10), true, 0);
        } else if (this.dir == 0) {
            this.m_sprite.drawAnimation(g, this.m_type + 13, System.currentTimeMillis(), this.m_x_pos, this.m_y_pos, true, 0);
            this.ge.hud.drawSprite(g, this.ge.me.curr_language == 0 ? 0 : 20, this.m_x_pos, this.m_y_pos - 19, 0);
            this.ge.hud.drawSprite(g, 3, this.m_x_pos + 1, this.m_y_pos - 10, 0);
        } else {
            this.m_sprite.drawAnimation(g, this.m_type, System.currentTimeMillis(), this.m_x_pos, this.m_y_pos, true, 0);
            this.ge.hud.drawSprite(g, this.ge.me.curr_language == 0 ? 0 : 20, this.m_x_pos, this.m_y_pos - 19, 0);
            this.ge.hud.drawSprite(g, 3, this.m_x_pos + 1, this.m_y_pos - 10, 0);
        }
    }

    public void update(long time, int world_offset) {
        if (!this.abducted && this.being_abducted && System.currentTimeMillis() - this.abduct_start_time > 3000L) {
            this.abducted = true;
            this.being_abducted = false;
            this.ge.incrementAbductees();
        }
        this.tcol_x = this.ab_pos_x + this.col_x;
    }

    public void beginAbduction() {
        this.being_abducted = true;
        this.abduct_start_time = System.currentTimeMillis();
    }

    public void stopAbduction() {
        this.being_abducted = false;
    }

    public boolean isAbducted() {
        return this.abducted;
    }

    public boolean isBeingAbducted() {
        return this.being_abducted;
    }
}

