/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.objects;

import com.inodesoft.game.Constants;
import com.inodesoft.game.GameEngine;
import com.inodesoft.game.objects.InvObject;
import com.inodesoft.game.tools.ICAnimation;
import com.inodesoft.game.tools.ICResourceManager;
import javax.microedition.lcdui.Graphics;

public class InvFlyingEnemy
extends InvObject {
    public static final int FLY_ENEMY_PLANE = 0;
    public static final int FLY_ENEMY_HELICOPTER = 1;
    public static final int NUM_TYPES = 2;
    static ICAnimation m_spr_aereal = null;
    static int max_sprite_width = -1;
    int m_type = -1;
    long last_shot;

    public InvFlyingEnemy(GameEngine ge, int type) {
        super(ge);
        if (m_spr_aereal == null) {
            m_spr_aereal = new ICAnimation(ICResourceManager.getInstance().getResourceAsStream("flying_enemies.lqa"));
        }
        this.m_sprite = m_spr_aereal;
        if (max_sprite_width == -1) {
            for (int i = 0; i < this.m_sprite.getNumSprites(); ++i) {
                if (max_sprite_width >= this.m_sprite.getSpriteWidth(i)) continue;
                max_sprite_width = this.m_sprite.getSpriteWidth(i);
            }
        }
        this.m_type = type;
        this.dir = 1;
        switch (type) {
            case 0: {
                this.col_x = 20;
                this.col_y = 12;
                this.col_w = 63;
                this.col_h = 18;
                break;
            }
            case 1: {
                this.col_x = 17;
                this.col_y = 17;
                this.col_w = 40;
                this.col_h = 16;
            }
        }
        this.alive = true;
        this.last_shot = System.currentTimeMillis();
    }

    public void setDirection(int dir) {
        super.setDirection(dir);
        switch (this.m_type) {
            case 0: {
                if (dir >= 0) break;
                this.col_x -= this.m_sprite.getFrameWidth(0);
                break;
            }
            case 1: {
                if (dir <= 0) break;
                this.col_x -= this.m_sprite.getFrameWidth(5);
            }
        }
    }

    public int getType() {
        return this.m_type;
    }

    public void paint(Graphics g, int world_offset) {
        this.m_x_pos = this.ab_pos_x + world_offset;
        if (this.m_x_pos < -max_sprite_width || this.m_x_pos > this.ge.getWidth() + max_sprite_width) {
            return;
        }
        switch (this.m_type) {
            case 0: {
                this.m_sprite.drawFrame(g, 0, this.m_x_pos, this.m_y_pos, this.dir > 0 ? 0 : 2);
                break;
            }
            case 1: {
                this.m_sprite.drawAnimation(g, 2, System.currentTimeMillis() % 10L, this.m_x_pos, this.m_y_pos, true, this.dir > 0 ? 2 : 0);
            }
        }
    }

    public void update(long time, int world_offset) {
        if (this.alive) {
            switch (this.m_type) {
                case 0: {
                    this.ab_pos_x += this.dir * 6;
                    break;
                }
                case 1: {
                    this.ab_pos_x += this.dir * 4;
                }
            }
        }
        if (this.dir > 0 && this.ab_pos_x > 5400 + this.ge.getWidth()) {
            this.alive = false;
        }
        if (this.dir < 0 && this.ab_pos_x < -80) {
            this.alive = false;
        }
        if (this.dir == 0) {
            this.alive = false;
        }
        this.tcol_x = this.ab_pos_x + this.col_x;
        if (System.currentTimeMillis() - this.last_shot >= Constants.ENEMY_AEREAL_SPAWN_TIME[this.ge.getLevel()] >> 2) {
            this.ge.fireAerealEnemy(this, this.dir);
            this.last_shot = System.currentTimeMillis();
        }
    }

    public void explode() {
        this.alive = false;
    }
}

