/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.objects;

import com.inodesoft.game.GameEngine;
import com.inodesoft.game.tools.ICAnimation;
import javax.microedition.lcdui.Graphics;

public class InvObject {
    public ICAnimation m_sprite;
    public int curr_animation = -1;
    public int curr_frame = -1;
    public int m_x_pos;
    public int m_y_pos;
    public int m_w;
    public int m_h;
    protected int state;
    protected long curr_state_time;
    protected long start_state_time;
    protected int delta_x;
    protected int delta_y;
    protected int col_x;
    protected int col_y;
    protected int col_w;
    protected int col_h;
    public int tcol_x;
    public int ab_pos_x;
    protected int dir;
    boolean alive = false;
    protected GameEngine ge;

    public InvObject(GameEngine g_e) {
        this.ge = g_e;
    }

    public void paint(Graphics g) {
    }

    public void paint(Graphics g, int world_offset) {
    }

    public void update(long time) {
    }

    public void update(long time, int world_offset) {
    }

    public void processKey(char key) {
    }

    public void processNewState(int newState) {
    }

    public void explode() {
    }

    public int getDirection() {
        return this.dir;
    }

    public void setDirection(int dir) {
        this.dir = dir;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void changeState(int newState) {
        if (newState == this.state) {
            return;
        }
        this.state = newState;
        this.start_state_time = System.currentTimeMillis();
        this.curr_state_time = 0L;
        this.processNewState(newState);
    }

    public void setPosition(int x, int y) {
        this.m_x_pos = x;
        this.m_y_pos = y;
    }

    public void setAbPosition(int x, int y) {
        this.ab_pos_x = x;
        this.m_y_pos = y;
    }

    public void setCollisionWithFrame(int frame) {
        if (this.m_sprite != null) {
            this.m_w = this.m_sprite.getFrameWidth(frame);
            this.m_h = this.m_sprite.getFrameHeight(frame);
        }
    }

    public void setCollisionWithSprite(int sprite) {
        if (this.m_sprite != null) {
            this.m_w = this.m_sprite.getSpriteWidth(sprite);
            this.m_h = this.m_sprite.getSpriteHeight(sprite);
        }
    }

    public void setCollisionCoords(int x, int y, int w, int h) {
        this.col_x = x;
        this.col_y = y;
        this.col_w = w;
        this.col_h = h;
    }

    public boolean collisionGraph(InvObject obj) {
        return InvObject.collisionGraph(this, obj);
    }

    public boolean collisionGraph(int x, int y, int w, int h) {
        return InvObject.collision(this.ab_pos_x, this.m_y_pos, this.m_w, this.m_h, x, y, w, h);
    }

    public boolean collision(InvObject obj) {
        return InvObject.collision(this, obj);
    }

    public boolean collision(int x, int y, int w, int h) {
        return InvObject.collision(this.ab_pos_x + this.col_x, this.m_y_pos + this.col_y, this.col_w, this.col_h, x, y, w, h);
    }

    public boolean tcollision(int x, int y, int w, int h) {
        return InvObject.collision(this.tcol_x, this.m_y_pos + this.col_y, this.col_w, this.col_h, x, y, w, h);
    }

    public static boolean collisionGraph(InvObject obja, InvObject objb) {
        return InvObject.collision(obja.ab_pos_x, obja.m_y_pos, obja.m_w, obja.m_h, objb.ab_pos_x, objb.m_y_pos, objb.m_w, objb.m_h);
    }

    public static boolean collision(InvObject obja, InvObject objb) {
        return InvObject.collision(obja.ab_pos_x + obja.col_x, obja.m_y_pos + obja.col_y, obja.col_w, obja.col_h, objb.ab_pos_x + objb.col_x, objb.m_y_pos + objb.col_y, objb.col_w, objb.col_h);
    }

    public static boolean tcollision(InvObject obja, InvObject objb) {
        return InvObject.collision(obja.tcol_x, obja.m_y_pos + obja.col_y, obja.col_w, obja.col_h, objb.tcol_x, objb.m_y_pos + objb.col_y, objb.col_w, objb.col_h);
    }

    public static boolean collision(int a_x, int a_y, int a_w, int a_h, int b_x, int b_y, int b_w, int b_h) {
        int tw = a_w;
        int th = a_h;
        int rw = b_w;
        int rh = b_h;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = a_x;
        int ty = a_y;
        int rx = b_x;
        int ry = b_y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }
}

