/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.game.tools.bspr;

import com.inodesoft.game.tools.bspr.BSDebug;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BSAnimation {
    static int[] temp = new int[4096];
    static final boolean USE_MODULE_MAPPINGS = false;
    static final boolean USE_HYPER_FM = true;
    static final boolean USE_INDEX_EX_FMODULES = false;
    static final boolean USE_INDEX_EX_AFRAMES = false;
    static final boolean USE_PRECOMPUTED_FRAME_RECT = false;
    static final boolean ALWAYS_BS_NFM_1_BYTE = false;
    static final boolean ALWAYS_BS_SKIP_FRAME_RC = false;
    static final boolean ALWAYS_BS_NAF_1_BYTE = false;
    static final boolean USE_PIXEL_FORMAT_8888 = true;
    static final boolean USE_PIXEL_FORMAT_4444 = true;
    static final boolean USE_PIXEL_FORMAT_1555 = true;
    static final boolean USE_PIXEL_FORMAT_0565 = true;
    static final boolean USE_ENCODE_FORMAT_I2 = true;
    static final boolean USE_ENCODE_FORMAT_I4 = true;
    static final boolean USE_ENCODE_FORMAT_I16 = true;
    static final boolean USE_ENCODE_FORMAT_I256 = true;
    static final boolean USE_ENCODE_FORMAT_I64RLE = true;
    static final boolean USE_ENCODE_FORMAT_I127RLE = true;
    static final boolean USE_ENCODE_FORMAT_I256RLE = true;
    static final int MAX_SPRITE_PALETTES = 16;
    static final int MAX_MODULE_MAPPINGS = 16;
    static final short BSPRITE_v003 = 991;
    static final int BS_MODULES = 1;
    static final int BS_MODULES_XY = 2;
    static final int BS_MODULES_IMG = 4;
    static final int BS_FRAMES = 256;
    static final int BS_FM_OFF_SHORT = 1024;
    static final int BS_NFM_1_BYTE = 2048;
    static final int BS_SKIP_FRAME_RC = 4096;
    static final int BS_ANIMS = 65536;
    static final int BS_AF_OFF_SHORT = 262144;
    static final int BS_NAF_1_BYTE = 524288;
    static final int BS_MODULE_IMAGES = 0x1000000;
    static final int BS_PNG_CRC = 0x2000000;
    static final int BS_KEEP_PAL = 0x4000000;
    static final int BS_TRANSP_FIRST = 0x8000000;
    static final int BS_TRANSP_LAST = 0x10000000;
    static final int BS_DEFAULT_DOJA = 65793;
    static final int BS_DEFAULT_MIDP2 = 0x1010101;
    static final int BS_DEFAULT_NOKIA = 0x1010101;
    static final int BS_DEFAULT_MIDP1 = 65795;
    static final int BS_DEFAULT_MIDP1b = 0x3010101;
    static final short PIXEL_FORMAT_8888 = -30584;
    static final short PIXEL_FORMAT_4444 = 17476;
    static final short PIXEL_FORMAT_1555 = 21781;
    static final short PIXEL_FORMAT_0565 = 25861;
    static final short ENCODE_FORMAT_I2 = 512;
    static final short ENCODE_FORMAT_I4 = 1024;
    static final short ENCODE_FORMAT_I16 = 5632;
    static final short ENCODE_FORMAT_I256 = 22018;
    static final short ENCODE_FORMAT_I64RLE = 25840;
    static final short ENCODE_FORMAT_I127RLE = 10225;
    static final short ENCODE_FORMAT_I256RLE = 22258;
    static final byte FLAG_FLIP_X = 1;
    static final byte FLAG_FLIP_Y = 2;
    static final byte FLAG_ROT_90 = 4;
    static final byte FLAG_USER0 = 16;
    static final byte FLAG_USER1 = 32;
    static final byte FLAG_HYPER_FM = 16;
    static final int FLAG_INDEX_EX_MASK = 192;
    static final int INDEX_MASK = 1023;
    static final int INDEX_EX_MASK = 768;
    static final int INDEX_EX_SHIFT = 2;
    static final byte FLAG_OFFSET_FM = 16;
    static final byte FLAG_OFFSET_AF = 32;
    int _nModules;
    byte[] _modules_w;
    byte[] _modules_h;
    byte[] _frames_nfm;
    short[] _frames_fm_start;
    byte[] _frames_rc;
    byte[] _fmodules;
    byte[] _anims_naf;
    short[] _anims_af_start;
    byte[] _aframes;
    int[][] _map;
    private int _cur_map;
    int[][] _pal;
    int _palettes;
    private int _crt_pal;
    boolean _alpha;
    short _data_format;
    int _i64rle_color_mask;
    int _i64rle_color_bits;
    byte[] _modules_data;
    short[] _modules_data_off;
    Image[][] _modules_image;
    int newSizeX;
    int newSizeY;
    static int _text_w;
    static int _text_h;
    byte[] _map_char;
    private int _line_spacing = 0;
    static int _index1;
    static int _index2;

    BSAnimation() {
    }

    void Load(byte[] file, int offset) {
        try {
            int colors;
            int nAnims;
            int nAFrames;
            int nFrames;
            int nFModules;
            int bs_flags;
            System.gc();
            short bs_version = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            if (bs_version != 991) {
                System.out.println("ERROR: Invalid BSprite version !");
            }
            if ((bs_flags = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8) + ((file[offset++] & 0xFF) << 16) + ((file[offset++] & 0xFF) << 24)) != 0x1010101) {
                System.out.println("ERROR: Invalid BSprite flags !");
            }
            this._nModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
            if (this._nModules > 0) {
                this._modules_w = new byte[this._nModules];
                this._modules_h = new byte[this._nModules];
                for (int i = 0; i < this._nModules; ++i) {
                    this._modules_w[i] = file[offset++];
                    this._modules_h[i] = file[offset++];
                }
            }
            if ((nFModules = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._fmodules = new byte[nFModules << 2];
                System.arraycopy(file, offset, this._fmodules, 0, this._fmodules.length);
                offset += this._fmodules.length;
            }
            if ((nFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._frames_nfm = new byte[nFrames];
                this._frames_fm_start = new short[nFrames];
                for (int i = 0; i < nFrames; ++i) {
                    this._frames_nfm[i] = file[offset++];
                    int n = ++offset;
                    int n2 = ++offset;
                    ++offset;
                    this._frames_fm_start[i] = (short)((file[n] & 0xFF) + ((file[n2] & 0xFF) << 8));
                }
                offset += nFrames << 2;
            }
            if ((nAFrames = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._aframes = new byte[nAFrames * 5];
                System.arraycopy(file, offset, this._aframes, 0, this._aframes.length);
                offset += this._aframes.length;
            }
            if ((nAnims = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8)) > 0) {
                this._anims_naf = new byte[nAnims];
                this._anims_af_start = new short[nAnims];
                for (int i = 0; i < nAnims; ++i) {
                    this._anims_naf[i] = file[offset++];
                    int n = ++offset;
                    int n3 = ++offset;
                    ++offset;
                    this._anims_af_start[i] = (short)((file[n] & 0xFF) + ((file[n3] & 0xFF) << 8));
                }
            }
            if (this._nModules <= 0) {
                System.out.println("WARNING: sprite with num modules = " + this._nModules);
                System.gc();
                return;
            }
            short _pixel_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            this._palettes = file[offset++] & 0xFF;
            if ((colors = file[offset++] & 0xFF) == 0) {
                colors = 256;
            }
            this._pal = new int[16][];
            for (int p = 0; p < this._palettes; ++p) {
                int a;
                int c;
                this._pal[p] = new int[colors];
                if (_pixel_format == -30584) {
                    for (c = 0; c < colors; ++c) {
                        int _8888 = file[offset++] & 0xFF;
                        _8888 += (file[offset++] & 0xFF) << 8;
                        _8888 += (file[offset++] & 0xFF) << 16;
                        if (((_8888 += (file[offset++] & 0xFF) << 24) & 0xFF000000) != -16777216) {
                            this._alpha = true;
                        }
                        this._pal[p][c] = _8888;
                    }
                    continue;
                }
                if (_pixel_format == 17476) {
                    for (c = 0; c < colors; ++c) {
                        int _4444 = file[offset++] & 0xFF;
                        if (((_4444 += (file[offset++] & 0xFF) << 8) & 0xF000) != 61440) {
                            this._alpha = true;
                        }
                        this._pal[p][c] = (_4444 & 0xF000) << 16 | (_4444 & 0xF000) << 12 | (_4444 & 0xF00) << 12 | (_4444 & 0xF00) << 8 | (_4444 & 0xF0) << 8 | (_4444 & 0xF0) << 4 | (_4444 & 0xF) << 4 | _4444 & 0xF;
                    }
                    continue;
                }
                if (_pixel_format == 21781) {
                    for (c = 0; c < colors; ++c) {
                        int _1555 = file[offset++] & 0xFF;
                        int n = offset++;
                        a = -16777216;
                        if (((_1555 += (file[n] & 0xFF) << 8) & 0x8000) != 32768) {
                            a = 0;
                            this._alpha = true;
                        }
                        this._pal[p][c] = a | (_1555 & 0x7C00) << 9 | (_1555 & 0x3E0) << 6 | (_1555 & 0x1F) << 3;
                    }
                    continue;
                }
                if (_pixel_format != 25861) continue;
                for (c = 0; c < colors; ++c) {
                    int _0565 = file[offset++] & 0xFF;
                    int n = offset++;
                    a = -16777216;
                    if ((_0565 += (file[n] & 0xFF) << 8) == 63519) {
                        a = 0;
                        this._alpha = true;
                    }
                    this._pal[p][c] = a | (_0565 & 0xF800) << 8 | (_0565 & 0x7E0) << 5 | (_0565 & 0x1F) << 3;
                }
            }
            this._data_format = (short)((file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8));
            if (this._data_format == 25840) {
                int clrs = colors - 1;
                this._i64rle_color_mask = 1;
                this._i64rle_color_bits = 1;
                while (clrs != 0) {
                    clrs >>= 1;
                    this._i64rle_color_mask <<= 1;
                    ++this._i64rle_color_bits;
                }
                --this._i64rle_color_mask;
            }
            if (this._nModules > 0) {
                int size;
                int m;
                this._modules_data_off = new short[this._nModules];
                int len = 0;
                int off = offset;
                for (m = 0; m < this._nModules; ++m) {
                    size = (file[off++] & 0xFF) + ((file[off++] & 0xFF) << 8);
                    this._modules_data_off[m] = (short)len;
                    off += size;
                    len += size;
                }
                this._modules_data = new byte[len];
                for (m = 0; m < this._nModules; ++m) {
                    size = (file[offset++] & 0xFF) + ((file[offset++] & 0xFF) << 8);
                    System.arraycopy(file, offset, this._modules_data, this._modules_data_off[m] & 0xFFFF, size);
                    offset += size;
                }
            }
            System.gc();
        }
        catch (Exception e) {
            BSDebug.CatchException(e, "ASprite.Load()");
        }
    }

    void ClearCompressedImageData() {
        this._modules_data = null;
        this._modules_data_off = null;
        System.gc();
    }

    void BuildCacheImages(int pal, int m1, int m2, int pal_copy) {
        if (this._nModules == 0) {
            return;
        }
        if (m2 == -1) {
            m2 = this._nModules - 1;
        }
        if (this._modules_image == null) {
            this._modules_image = new Image[this._palettes][];
        }
        if (this._modules_image[pal] == null) {
            this._modules_image[pal] = new Image[this._nModules];
        }
        if (pal_copy >= 0) {
            for (int i = m1; i <= m2; ++i) {
                this._modules_image[pal][i] = this._modules_image[pal_copy][i];
            }
        } else {
            int old_pal = this._crt_pal;
            this._crt_pal = pal;
            int total_area = 0;
            int total_size = 0;
            System.gc();
            long mem = Runtime.getRuntime().freeMemory();
            for (int i = m1; i <= m2; ++i) {
                int[] image_data;
                int sizeX = this._modules_w[i] & 0xFF;
                int sizeY = this._modules_h[i] & 0xFF;
                if (sizeX <= 0 || sizeY <= 0 || (image_data = this.DecodeImage(i, 0)) == null) continue;
                boolean bAlpha = false;
                int size = sizeX * sizeY;
                total_area += size;
                for (int ii = 0; ii < size; ++ii) {
                    if ((image_data[ii] & 0xFF000000) == -16777216) continue;
                    bAlpha = true;
                    break;
                }
                total_size += bAlpha & false ? size * 3 : size * 2;
                this._modules_image[pal][i] = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)bAlpha);
                image_data = null;
            }
            System.gc();
            this._crt_pal = old_pal;
        }
        System.gc();
    }

    private void MODULE_MAPPING___() {
    }

    void SetModuleMapping(int map, byte[] mmp) {
        if (this._map[map] == null) {
            this._map[map] = new int[this._nModules];
            for (int i = 0; i < this._nModules; ++i) {
                this._map[map][i] = i;
            }
        }
        if (mmp == null) {
            return;
        }
        int off = 0;
        while (off < mmp.length) {
            int i2;
            int i1 = (mmp[off++] & 0xFF) + ((mmp[off++] & 0xFF) << 8);
            this._map[map][i1] = i2 = (mmp[off++] & 0xFF) + ((mmp[off++] & 0xFF) << 8);
        }
    }

    void ApplyModuleMapping(int dst_pal, int src_pal, byte[] mmp) {
        int off = 0;
        while (off < mmp.length) {
            int i1 = (mmp[off++] & 0xFF) + ((mmp[off++] & 0xFF) << 8);
            int i2 = (mmp[off++] & 0xFF) + ((mmp[off++] & 0xFF) << 8);
            this._modules_image[dst_pal][i1] = this._modules_image[src_pal][i2];
        }
        System.gc();
    }

    void SetCurrentMMapping(int map) {
        this._cur_map = map;
    }

    int GetCurrentMMapping() {
        return this._cur_map;
    }

    private void ___MODULE_MAPPING() {
    }

    int GetAFrameTime(int anim, int aframe) {
        return this._aframes[(this._anims_af_start[anim] + aframe) * 5 + 1] & 0xFF;
    }

    int GetAFrames(int anim) {
        return this._anims_naf[anim] & 0xFF;
    }

    int GetFModules(int frame) {
        return this._frames_nfm[frame] & 0xFF;
    }

    int GetModuleWidth(int module) {
        return this._modules_w[module] & 0xFF;
    }

    int GetModuleHeight(int module) {
        return this._modules_h[module] & 0xFF;
    }

    int GetFrameWidth(int frame) {
        return this._frames_rc[frame * 4 + 2] & 0xFF;
    }

    int GetFrameHeight(int frame) {
        return this._frames_rc[frame * 4 + 3] & 0xFF;
    }

    int GetFrameModuleX(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        return this._fmodules[off + 1];
    }

    int GetFrameModuleY(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        return this._fmodules[off + 2];
    }

    int GetFrameModuleWidth(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        int index = this._fmodules[off] & 0xFF;
        return this._modules_w[index] & 0xFF;
    }

    int GetFrameModuleHeight(int frame, int fmodule) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        int index = this._fmodules[off] & 0xFF;
        return this._modules_h[index] & 0xFF;
    }

    int GetAnimFrame(int anim, int aframe) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        return this._aframes[off] & 0xFF;
    }

    void GetAFrameRect(int[] rc, int anim, int aframe, int posX, int posY, int flags, int hx, int hy) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        int frame = this._aframes[off] & 0xFF;
        if ((flags & 0x20) != 0) {
            hx = (flags & 1) != 0 ? (hx += this._aframes[off + 2]) : (hx -= this._aframes[off + 2]);
            hy = (flags & 2) != 0 ? (hy += this._aframes[off + 3]) : (hy -= this._aframes[off + 3]);
        }
        this.GetFrameRect(rc, frame, posX, posY, flags ^ this._aframes[off + 4] & 0xF, hx, hy);
    }

    void GetFrameRect(int[] rc, int frame, int posX, int posY, int flags, int hx, int hy) {
        int fx = 0;
        int fy = 0;
        int fw = 0;
        int fh = 0;
        int nFModules = this._frames_nfm[frame] & 0xFF;
        for (int fmodule = 0; fmodule < nFModules; ++fmodule) {
            this.GetFModuleRect(rc, frame, fmodule, posX, posY, flags, hx, hy);
            if (rc[0] < fx) {
                fw = fx + fw - rc[0];
                fx = rc[0];
            }
            if (rc[1] < fy) {
                fh = fy + fh - rc[1];
                fy = rc[1];
            }
            if (rc[2] > fx + fw) {
                fw = rc[2] - fx;
            }
            if (rc[3] <= fy + fh) continue;
            fh = rc[3] - fy;
        }
        hx <<= 8;
        hy <<= 8;
        hx = (flags & 1) != 0 ? (hx += fx + fw) : (hx -= fx);
        hy = (flags & 2) != 0 ? (hy += fy + fh) : (hy -= fy);
        rc[0] = posX - hx;
        rc[1] = posY - hy;
        rc[2] = rc[0] + fw;
        rc[3] = rc[1] + fh;
    }

    void GetFModuleRect(int[] rc, int frame, int fmodule, int posX, int posY, int flags, int hx, int hy) {
        rc[0] = this.GetFrameModuleX(frame, fmodule) << 8;
        rc[1] = this.GetFrameModuleY(frame, fmodule) << 8;
        rc[2] = rc[0] + (this.GetFrameModuleWidth(frame, fmodule) << 8);
        rc[3] = rc[1] + (this.GetFrameModuleHeight(frame, fmodule) << 8);
    }

    void GetModuleRect(int[] rc, int module, int posX, int posY, int flags) {
        rc[0] = posX;
        rc[1] = posY;
        rc[2] = posX + ((this._modules_w[module] & 0xFF) << 8);
        rc[3] = posY + ((this._modules_h[module] & 0xFF) << 8);
    }

    void PaintAFrame(Graphics g, int anim, int aframe, int posX, int posY, int flags, int hx, int hy) {
        int off = (this._anims_af_start[anim] + aframe) * 5;
        int frame = this._aframes[off] & 0xFF;
        hx = (flags & 1) != 0 ? (hx += this._aframes[off + 2]) : (hx -= this._aframes[off + 2]);
        hy = (flags & 2) != 0 ? (hy += this._aframes[off + 3]) : (hy -= this._aframes[off + 3]);
        this.PaintFrame(g, frame, posX - hx, posY - hy, flags ^ this._aframes[off + 4] & 0xF, hx, hy);
    }

    void PaintFrame(Graphics g, int frame, int posX, int posY, int flags, int hx, int hy) {
        int nFModules = this._frames_nfm[frame] & 0xFF;
        for (int fmodule = 0; fmodule < nFModules; ++fmodule) {
            this.PaintFModule(g, frame, fmodule, posX, posY, flags, hx, hy);
        }
    }

    void PaintFModule(Graphics g, int frame, int fmodule, int posX, int posY, int flags, int hx, int hy) {
        int off = this._frames_fm_start[frame] + fmodule << 2;
        int fm_flags = this._fmodules[off + 3] & 0xFF;
        int index = this._fmodules[off] & 0xFF;
        posX = (flags & 1) != 0 ? (posX -= this._fmodules[off + 1]) : (posX += this._fmodules[off + 1]);
        posY = (flags & 2) != 0 ? (posY -= this._fmodules[off + 2]) : (posY += this._fmodules[off + 2]);
        if ((fm_flags & 0x10) != 0) {
            this.PaintFrame(g, index, posX, posY, flags ^ fm_flags & 0xF, hx, hy);
        } else {
            if ((flags & 1) != 0) {
                posX -= this._modules_w[index] & 0xFF;
            }
            if ((flags & 2) != 0) {
                posY -= this._modules_h[index] & 0xFF;
            }
            this.PaintModule(g, index, posX, posY, flags ^ fm_flags & 0xF);
        }
    }

    void PaintModule(Graphics g, int module, int posX, int posY, int flags) {
        int sizeX = this._modules_w[module] & 0xFF;
        int sizeY = this._modules_h[module] & 0xFF;
        if (sizeX <= 0 || sizeY <= 0) {
            return;
        }
        Image img = null;
        if (this._modules_image != null && this._modules_image[this._crt_pal] != null) {
            img = this._modules_image[this._crt_pal][module];
        }
        if (img == null) {
            int[] image_data = this.DecodeImage(module, flags);
            if (image_data == null) {
                System.out.println("DecodeImage() FAILED !");
                return;
            }
            img = Image.createRGBImage((int[])image_data, (int)sizeX, (int)sizeY, (boolean)this._alpha);
        }
        sizeX = img.getWidth();
        sizeY = img.getHeight();
        boolean x = false;
        boolean y = false;
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                g.drawRegion(img, 0, 0, sizeX, sizeY, 3, posX, posY, 0);
            } else {
                g.drawRegion(img, 0, 0, sizeX, sizeY, 2, posX, posY, 0);
            }
        } else if ((flags & 2) != 0) {
            g.drawRegion(img, 0, 0, sizeX, sizeY, 1, posX, posY, 0);
        } else {
            g.drawRegion(img, 0, 0, sizeX, sizeY, 0, posX, posY, 0);
        }
    }

    public byte[] ScaleImageI256(int module, int factor1, int factor2) {
        byte[] buf_img_data = new byte[5000];
        if (this._modules_data == null || this._modules_data_off == null) {
            return null;
        }
        int m = module << 1;
        int sizeX = this._modules_w[m] & 0xFF;
        int sizeY = this._modules_h[m] & 0xFF;
        this.newSizeX = factor1 * sizeX / factor2;
        this.newSizeY = factor1 * sizeY / factor2;
        byte[] image = this._modules_data;
        short si = this._modules_data_off[module];
        boolean di = false;
        int ds = this.newSizeX * this.newSizeY;
        int i = 0;
        int j = 0;
        for (i = 0; i < this.newSizeY; ++i) {
            int i0 = i * sizeY / this.newSizeY * sizeX;
            int i1 = i * this.newSizeX;
            for (j = 0; j < this.newSizeX; ++j) {
                buf_img_data[j + i1] = image[si + j * sizeX / this.newSizeX + i0];
            }
        }
        return buf_img_data;
    }

    int[] DecodeImage(int module, int flags) {
        int[] img_data;
        block17: {
            int ds;
            int di;
            int si;
            byte[] image;
            int[] pal;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block16: {
                                    if (this._modules_data == null || this._modules_data_off == null) {
                                        return null;
                                    }
                                    int sizeX = this._modules_w[module] & 0xFF;
                                    int sizeY = this._modules_h[module] & 0xFF;
                                    if (sizeX * sizeY > temp.length) {
                                        System.out.println("ERROR: sizeX x sizeY > temp.length (" + sizeX + " x " + sizeY + " = " + sizeX * sizeY + " > " + temp.length + ") !!!");
                                        return null;
                                    }
                                    img_data = temp;
                                    pal = this._pal[this._crt_pal];
                                    if (pal == null) {
                                        return null;
                                    }
                                    image = this._modules_data;
                                    si = this._modules_data_off[module] & 0xFFFF;
                                    di = 0;
                                    ds = sizeX * sizeY;
                                    if (this._data_format != 25840) break block16;
                                    while (di < ds) {
                                        int c = image[si++] & 0xFF;
                                        int clr = pal[c & this._i64rle_color_mask];
                                        c >>= this._i64rle_color_bits;
                                        while (c-- >= 0) {
                                            img_data[di++] = clr;
                                        }
                                    }
                                    break block17;
                                }
                                if (this._data_format != 10225) break block18;
                                while (di < ds) {
                                    int c;
                                    if ((c = image[si++] & 0xFF) > 127) {
                                        int c2 = image[si++] & 0xFF;
                                        int clr = pal[c2];
                                        c -= 128;
                                        while (c-- > 0) {
                                            img_data[di++] = clr;
                                        }
                                        continue;
                                    }
                                    img_data[di++] = pal[c];
                                }
                                break block17;
                            }
                            if (this._data_format != 22258) break block19;
                            while (di < ds) {
                                int c;
                                if ((c = image[si++] & 0xFF) > 127) {
                                    c -= 128;
                                    while (c-- > 0) {
                                        img_data[di++] = pal[image[si++] & 0xFF];
                                    }
                                    continue;
                                }
                                int clr = pal[image[si++] & 0xFF];
                                while (c-- > 0) {
                                    img_data[di++] = clr;
                                }
                            }
                            break block17;
                        }
                        if (this._data_format != 5632) break block20;
                        while (di < ds) {
                            img_data[di++] = pal[image[si] >> 4 & 0xF];
                            img_data[di++] = pal[image[si] & 0xF];
                            ++si;
                        }
                        break block17;
                    }
                    if (this._data_format != 1024) break block21;
                    while (di < ds) {
                        img_data[di++] = pal[image[si] >> 6 & 3];
                        img_data[di++] = pal[image[si] >> 4 & 3];
                        img_data[di++] = pal[image[si] >> 2 & 3];
                        img_data[di++] = pal[image[si] & 3];
                        ++si;
                    }
                    break block17;
                }
                if (this._data_format != 512) break block22;
                while (di < ds) {
                    img_data[di++] = pal[image[si] >> 7 & 1];
                    img_data[di++] = pal[image[si] >> 6 & 1];
                    img_data[di++] = pal[image[si] >> 5 & 1];
                    img_data[di++] = pal[image[si] >> 4 & 1];
                    img_data[di++] = pal[image[si] >> 3 & 1];
                    img_data[di++] = pal[image[si] >> 2 & 1];
                    img_data[di++] = pal[image[si] >> 1 & 1];
                    img_data[di++] = pal[image[si] & 1];
                    ++si;
                }
                break block17;
            }
            if (this._data_format != 22018) break block17;
            while (di < ds) {
                img_data[di++] = pal[image[si++] & 0xFF];
            }
        }
        return img_data;
    }

    void SetCurrentPalette(int pal) {
        this._crt_pal = pal;
    }

    int GetCurrentPalette() {
        return this._crt_pal;
    }

    private void DRAW_STRINGS_SYSTEM___() {
    }

    int GetLineSpacing() {
        return this._line_spacing;
    }

    void SetLineSpacing(int spacing) {
        this._line_spacing = spacing;
    }

    void SetLineSpacingToDefault() {
        this._line_spacing = (this._modules_h[0] & 0xFF) >> 1;
    }

    static void SetSubString(int i1, int i2) {
        _index1 = i1;
        _index2 = i2;
    }

    int UpdateStringSize(String s) {
        _text_w = 0;
        _text_h = this._modules_h[0] & 0xFF;
        int tw = 0;
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : s.length();
        for (int i = index1; i < index2; ++i) {
            int m;
            int c = s.charAt(i);
            if (c > 32) {
                if (c > 255) {
                    System.out.println("Unknown char: " + c);
                    c = 0;
                }
                if (this._map_char == null) {
                    System.out.println("ERROR: _map_char is null !!!");
                    break;
                }
                c = this._map_char[c] & 0xFF;
            } else {
                if (c == 32) {
                    tw += (this._modules_w[0] & 0xFF) + this._fmodules[1];
                    continue;
                }
                if (c == 10) {
                    if (tw > _text_w) {
                        _text_w = tw;
                    }
                    tw = 0;
                    _text_h += this._line_spacing + (this._modules_h[0] & 0xFF);
                    continue;
                }
                if (c == 1) {
                    ++i;
                    continue;
                }
                if (c != 2) continue;
                c = s.charAt(++i);
            }
            if (c >= this.GetFModules(0)) {
                System.out.println("Character not available: c = " + c);
                c = 0;
            }
            if ((m = this._fmodules[c << 2] & 0xFF) >= this._nModules) {
                System.out.println("Character module not available: c = " + c + "  m = " + m);
                m = 0;
                c = 0;
            }
            tw += (this._modules_w[m] & 0xFF) - this._fmodules[(c << 2) + 1] + this._fmodules[1];
        }
        if (tw > _text_w) {
            _text_w = tw;
        }
        if (_text_w > 0) {
            _text_w -= this._fmodules[1];
        }
        return _text_w;
    }

    void DrawString(Graphics g, String s, int x, int y, int anchor) {
        y -= this._fmodules[2];
        if ((anchor & 0x2B) != 0) {
            this.UpdateStringSize(s);
            if ((anchor & 8) != 0) {
                x -= _text_w;
            } else if ((anchor & 1) != 0) {
                x -= _text_w >> 1;
            }
            if ((anchor & 0x20) != 0) {
                y -= _text_h;
            } else if ((anchor & 2) != 0) {
                y -= _text_h >> 1;
            }
        }
        int xx = x;
        int yy = y;
        int old_pal = this._crt_pal;
        int index1 = _index1 >= 0 ? _index1 : 0;
        int index2 = _index2 >= 0 ? _index2 : s.length();
        for (int i = index1; i < index2; ++i) {
            int m;
            int c = s.charAt(i);
            if (c > 32) {
                if (c > 255) {
                    System.out.println("Unknown char: " + c);
                    c = 0;
                }
                if (this._map_char == null) {
                    System.out.println("ERROR: _map_char is null !!!");
                    break;
                }
                c = this._map_char[c] & 0xFF;
            } else {
                if (c == 32) {
                    xx += (this._modules_w[0] & 0xFF) + this._fmodules[1];
                    continue;
                }
                if (c == 10) {
                    xx = x;
                    yy += this._line_spacing + (this._modules_h[0] & 0xFF);
                    continue;
                }
                if (c == 1) {
                    this._crt_pal = s.charAt(++i);
                    continue;
                }
                if (c != 2) continue;
                c = s.charAt(++i);
            }
            if (c >= this.GetFModules(0)) {
                System.out.println("Character not available: c = " + c);
                c = 0;
            }
            if ((m = this._fmodules[c << 2] & 0xFF) >= this._nModules) {
                System.out.println("Character module not available: c = " + c + "  m = " + m);
                m = 0;
                c = 0;
            }
            this.PaintFModule(g, 0, c, xx, yy, 0, 0, 0);
            xx += (this._modules_w[m] & 0xFF) - this._fmodules[(c << 2) + 1] + this._fmodules[1];
        }
        this._crt_pal = old_pal;
    }

    void DrawPage(Graphics g, String s, int x, int y, int anchor) {
        int lines = 0;
        int len = s.length();
        int[] off = new int[100];
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != '\n') continue;
            off[lines++] = i;
        }
        off[lines++] = len;
        int th = this._line_spacing + (this._modules_h[0] & 0xFF);
        if ((anchor & 0x20) != 0) {
            y -= th * (lines - 1);
        } else if ((anchor & 2) != 0) {
            y -= th * (lines - 1) >> 1;
        }
        for (int j = 0; j < lines; ++j) {
            _index1 = j > 0 ? off[j - 1] + 1 : 0;
            _index2 = off[j];
            this.DrawString(g, s, x, y + j * th, anchor);
        }
        _index1 = -1;
        _index2 = -1;
    }

    private void ___DRAW_STRINGS_SYSTEM() {
    }

    static int[] GenPalette(int type, int[] pal) {
        if (type < 0) {
            return pal;
        }
        if (type == 0) {
            return null;
        }
        int[] new_pal = new int[pal.length];
        switch (type) {
            case 4: {
                for (int i = 0; i < pal.length; ++i) {
                    int a = pal[i] & 0xFF000000;
                    int r = (pal[i] & 0xFF0000) >> 16;
                    int g = (pal[i] & 0xFF00) >> 8;
                    int b = pal[i] & 0xFF;
                    int l = (r + b + g) / 3 & 0xFF;
                    new_pal[i] = l << 16 | l << 8 | l | a;
                }
                break;
            }
        }
        return new_pal;
    }

    static {
        _index1 = -1;
        _index2 = -1;
    }
}

