/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.EdgeSweep;
import net.phys2d.raw.collide.Intersection;
import net.phys2d.raw.collide.PolygonPolygonCollider;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Polygon;

public class PolygonBoxCollider
extends PolygonPolygonCollider {
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        Polygon poly = (Polygon)bodyA.getShape();
        Box box = (Box)bodyB.getShape();
        Vector2f[] vertsA = poly.getVertices(bodyA.getPosition(), bodyA.getRotation());
        Vector2f[] vertsB = box.getPoints(bodyB.getPosition(), bodyB.getRotation());
        Vector2f sweepline = new Vector2f(vertsB[1]);
        sweepline.sub(vertsB[2]);
        EdgeSweep sweep = new EdgeSweep(sweepline);
        sweep.addVerticesToSweep(true, vertsA);
        sweep.addVerticesToSweep(false, vertsB);
        int[][] collEdgeCands = sweep.getOverlappingEdges();
        Intersection[][] intersections = this.getIntersectionPairs(vertsA, vertsB, collEdgeCands);
        return this.populateContacts(contacts, vertsA, vertsB, intersections);
    }
}

