/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.AbstractShape;
import net.phys2d.raw.shapes.DynamicShape;

public strictfp class Box
extends AbstractShape
implements DynamicShape {
    private Vector2f size = new Vector2f();

    public Box(float width, float height) {
        this.size.set(width, height);
        this.bounds = new AABox(this.size.length(), this.size.length());
    }

    public ROVector2f getSize() {
        return this.size;
    }

    public float getSurfaceFactor() {
        float x = this.size.getX();
        float y = this.size.getY();
        return x * x + y * y;
    }

    public Vector2f[] getPoints(ROVector2f pos, float rotation) {
        Matrix2f R = new Matrix2f(rotation);
        Vector2f[] pts = new Vector2f[4];
        Vector2f h = MathUtil.scale(this.getSize(), 0.5f);
        pts[0] = MathUtil.mul(R, new Vector2f(-h.getX(), -h.getY()));
        pts[0].add(pos);
        pts[1] = MathUtil.mul(R, new Vector2f(h.getX(), -h.getY()));
        pts[1].add(pos);
        pts[2] = MathUtil.mul(R, new Vector2f(h.getX(), h.getY()));
        pts[2].add(pos);
        pts[3] = MathUtil.mul(R, new Vector2f(-h.getX(), h.getY()));
        pts[3].add(pos);
        return pts;
    }
}

