/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.Vector2;
import javax.microedition.lcdui.Graphics;

public class Spring {
    public PhysicalObject obj1;
    public PhysicalObject obj2;
    private Vector2 localAnchor1;
    private Vector2 localAnchor2;
    private int restLength;
    private int stiffness;
    private int damping;
    private static Vector2 tmpVector = new Vector2();
    public static final byte CONSTRAINT_BOTH = 0;
    public static final byte CONSTRAINT_TO = 1;
    public static final byte CONSTRAINT_FROM = 2;
    private byte constraintType;
    private static int[] aabb = new int[4];
    private static Vector2 absoluteAnchor1 = new Vector2();
    private static Vector2 absoluteAnchor2 = new Vector2();
    private static Vector2 direction = new Vector2();
    private static Vector2 v1 = new Vector2();
    private static Vector2 v2 = new Vector2();

    public Spring(PhysicalObject pObj1, PhysicalObject pObj2, Vector2 pAnchor1, Vector2 pAnchor2, int pStiffness, int pDamping) {
        this.obj1 = pObj1;
        this.obj2 = pObj2;
        this.localAnchor1 = new Vector2(pAnchor1);
        this.localAnchor2 = new Vector2(pAnchor2);
        this.stiffness = pStiffness;
        this.damping = pDamping;
        this.restLength = this.getAbsoluteAnchor1().minus(this.getAbsoluteAnchor2()).length();
        this.constraintType = 1;
    }

    public Spring(PhysicalObject pObj1, PhysicalObject pObj2, Vector2 pAnchor1, Vector2 pAnchor2, int pStiffness, int pDamping, int pRestLength) {
        this.obj1 = pObj1;
        this.obj2 = pObj2;
        this.localAnchor1 = new Vector2(pAnchor1);
        this.localAnchor2 = new Vector2(pAnchor2);
        this.stiffness = pStiffness;
        this.damping = pDamping;
        this.restLength = pRestLength;
        this.constraintType = 1;
    }

    public Vector2 getAbsoluteAnchor1() {
        absoluteAnchor1.copy(this.localAnchor1);
        absoluteAnchor1.multiplyWithShift(this.obj1.getOrientation());
        absoluteAnchor1.add(this.obj1.getPosition());
        return absoluteAnchor1;
    }

    public Vector2 getAbsoluteAnchor2() {
        absoluteAnchor2.copy(this.localAnchor2);
        absoluteAnchor2.multiplyWithShift(this.obj2.getOrientation());
        absoluteAnchor2.add(this.obj2.getPosition());
        return absoluteAnchor2;
    }

    public void _applyForces() {
        direction.copy(this.getAbsoluteAnchor2());
        direction.subtract(this.getAbsoluteAnchor1());
        if (direction.isNull()) {
            return;
        }
        int currentLength = direction.normaliseWithShift();
        if (this.constraintType == 1 && currentLength < this.restLength || this.constraintType == 2 && currentLength > this.restLength) {
            return;
        }
        v1.copy(this.localAnchor1);
        v1.multiplyWithShift(this.obj1.getOrientation());
        v1.makePerpendicular();
        v1.multiplyWithShift(this.obj1.getAngularVelocity_shifted(), 2);
        v1.add(this.obj1.getLinearVelocity());
        v2.copy(this.localAnchor2);
        v2.multiplyWithShift(this.obj2.getOrientation());
        v2.makePerpendicular();
        v2.multiplyWithShift(this.obj2.getAngularVelocity_shifted(), 2);
        v2.add(this.obj2.getLinearVelocity());
        tmpVector.copy(v2);
        tmpVector.subtract(v1);
        int relativeVelocity = tmpVector.dotProductWithShift(direction);
        int forceMagnitude = (int)((long)(-this.stiffness) * (long)(currentLength - this.restLength) >> 10);
        Vector2 F = direction;
        F.multiplyWithShift(forceMagnitude += (int)((long)(-this.damping) * (long)relativeVelocity >> 10));
        if (this.obj2.isDynamic) {
            ((DynamicObject)this.obj2).wakeUp();
            ((DynamicObject)this.obj2).addForceAtPointInLocalCoords(F, this.localAnchor2);
        }
        F.set(-F.x, -F.y);
        if (this.obj1.isDynamic) {
            ((DynamicObject)this.obj1).wakeUp();
            ((DynamicObject)this.obj1).addForceAtPointInLocalCoords(F, this.localAnchor1);
        }
    }

    public int[] getBoundingBox() {
        Vector2 anchor1 = this.getAbsoluteAnchor1();
        Vector2 anchor2 = this.getAbsoluteAnchor2();
        if (anchor1.x < anchor2.x) {
            Spring.aabb[0] = anchor1.x;
            Spring.aabb[2] = anchor2.x;
        } else {
            Spring.aabb[0] = anchor2.x;
            Spring.aabb[2] = anchor1.x;
        }
        if (anchor1.y < anchor2.y) {
            Spring.aabb[1] = anchor1.y;
            Spring.aabb[3] = anchor2.y;
        } else {
            Spring.aabb[1] = anchor2.y;
            Spring.aabb[3] = anchor1.y;
        }
        return aabb;
    }

    public byte getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(byte constraintOrientation) {
        this.constraintType = constraintOrientation;
    }

    public int getDamping() {
        return this.damping;
    }

    public void setDamping(int damping) {
        this.damping = damping;
    }

    public int getRestLength() {
        return this.restLength;
    }

    public void setRestLength(int restLength) {
        this.restLength = restLength;
    }

    public int getStiffness() {
        return this.stiffness;
    }

    public void setStiffness(int stiffness) {
        this.stiffness = stiffness;
    }

    public Vector2 getLocalAnchor1() {
        return this.localAnchor1;
    }

    public Vector2 getLocalAnchor2() {
        return this.localAnchor2;
    }

    public void draw(Graphics pGraph, Vector2 pCoordSystemPosition) {
        v1.copy(this.getAbsoluteAnchor1());
        v1.shiftRight();
        v1.add(pCoordSystemPosition);
        v2.copy(this.getAbsoluteAnchor2());
        v2.shiftRight();
        v2.add(pCoordSystemPosition);
        pGraph.drawLine(Spring.v1.x, Spring.v1.y, Spring.v2.x, Spring.v2.y);
    }
}

