/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.IVideoListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

public class VideoHandler
implements PlayerListener {
    private static final VideoHandler INSTANCE = new VideoHandler();
    private static final Object LOCK = new Object();
    private Hashtable players = new Hashtable();
    private Hashtable videos = new Hashtable();
    private Hashtable types = new Hashtable();
    private int totalVideoCount = 0;
    private int displayX = 0;
    private int displayY = 0;
    private int displayWidth = 0;
    private int displayHeight = 0;
    private boolean fullScreen = false;
    private Canvas canvas;
    private IVideoListener listener;

    public static VideoHandler getInstance() {
        return INSTANCE;
    }

    private VideoHandler() {
        this.types.put("3gp", "video/3gpp");
        this.types.put("mp4", "video/mpeg4");
    }

    public IVideoListener getListener() {
        return this.listener;
    }

    public void setListener(IVideoListener listener) {
        this.listener = listener;
    }

    private String extractFileExtension(String path) {
        return path.substring(path.lastIndexOf(46) + 1, path.length());
    }

    private String getFileType(String extension) {
        return (String)this.types.get(extension);
    }

    public void load(final String[] paths) {
        this.totalVideoCount += paths.length;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = paths.length - 1; i >= 0; --i) {
                    Object object = LOCK;
                    synchronized (object) {
                        try {
                            Player player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(paths[i]), (String)VideoHandler.this.getFileType(VideoHandler.this.extractFileExtension(paths[i])));
                            player.prefetch();
                            player.addPlayerListener((PlayerListener)INSTANCE);
                            VideoHandler.this.players.put(paths[i], player);
                            VideoControl video = (VideoControl)player.getControl("VideoControl");
                            VideoHandler.this.videos.put(paths[i], video);
                        }
                        catch (IOException ex) {
                            VideoHandler.this.totalVideoCount--;
                            ex.printStackTrace();
                        }
                        catch (MediaException ex) {
                            VideoHandler.this.totalVideoCount--;
                            ex.printStackTrace();
                        }
                    }
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (VideoHandler.this.listener != null) {
                    VideoHandler.this.listener.onHandlerLoaded();
                }
            }
        });
        thread.start();
    }

    public void load(String path) {
        ++this.totalVideoCount;
        try {
            Player player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(path), (String)this.getFileType(this.extractFileExtension(path)));
            player.realize();
            player.addPlayerListener((PlayerListener)INSTANCE);
            this.players.put(path, player);
            VideoControl video = (VideoControl)player.getControl("VideoControl");
            this.videos.put(path, video);
        }
        catch (IOException ex) {
            --this.totalVideoCount;
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            --this.totalVideoCount;
            ex.printStackTrace();
        }
    }

    public void initializeVideosOn(Canvas canvas) {
        this.canvas = canvas;
    }

    public void clear() {
        Enumeration playerEnum = this.players.elements();
        while (playerEnum.hasMoreElements()) {
            Player player = (Player)playerEnum.nextElement();
            player.close();
        }
        this.players.clear();
        this.videos.clear();
        this.totalVideoCount = 0;
        this.canvas = null;
    }

    public void clear(String path) {
        if (!this.players.containsKey(path)) {
            return;
        }
        Player player = (Player)this.players.get(path);
        player.close();
        this.players.remove(path);
        this.videos.remove(path);
        --this.totalVideoCount;
        if (this.players.isEmpty()) {
            this.canvas = null;
        }
    }

    public boolean isEmpty() {
        return this.players.isEmpty();
    }

    public boolean isLoaded() {
        return this.players.size() == this.totalVideoCount;
    }

    public int getTotalCount() {
        return this.totalVideoCount;
    }

    public int getLoadedCount() {
        return this.players.size();
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreenMode) {
        this.fullScreen = fullScreenMode;
        Enumeration playerEnum = this.players.keys();
        while (playerEnum.hasMoreElements()) {
            String id = (String)playerEnum.nextElement();
            Player player = (Player)this.players.get(id);
            if (player.getState() != 400) continue;
            try {
                VideoControl video = (VideoControl)this.videos.get(id);
                video.setDisplayFullScreen(fullScreenMode);
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplaySize(int width, int height) {
        this.displayWidth = width;
        this.displayHeight = height;
    }

    public int getDisplayX() {
        return this.displayX;
    }

    public int getDisplayY() {
        return this.displayY;
    }

    public void setDisplayLocation(int x, int y) {
        this.displayX = x;
        this.displayY = y;
    }

    public int getVideoWidth(String path) {
        if (!this.videos.containsKey(path)) {
            return 0;
        }
        VideoControl video = (VideoControl)this.videos.get(path);
        return video.getSourceWidth();
    }

    public int getVideoHeight(String path) {
        if (!this.videos.containsKey(path)) {
            return 0;
        }
        VideoControl video = (VideoControl)this.videos.get(path);
        return video.getSourceHeight();
    }

    public void play(String path) {
        Player player;
        Enumeration idEnum = this.players.keys();
        while (idEnum.hasMoreElements()) {
            String videoId = (String)idEnum.nextElement();
            player = (Player)this.players.get(videoId);
            VideoControl video = (VideoControl)this.videos.get(videoId);
            if (player.getState() != 400) continue;
            try {
                player.stop();
                player.setMediaTime(0L);
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            video.setVisible(false);
        }
        if (this.canvas == null) {
            throw new IllegalStateException("Videos are not initialized yet.");
        }
        if (!this.players.containsKey(path)) {
            return;
        }
        VideoControl video = (VideoControl)this.videos.get(path);
        try {
            video.initDisplayMode(1, (Object)this.canvas);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            video.setDisplayFullScreen(this.fullScreen);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        video.setDisplayLocation(this.displayX, this.displayY);
        try {
            if (this.displayWidth <= 0 || this.displayHeight <= 0) {
                video.setDisplaySize(video.getSourceWidth(), video.getSourceHeight());
            } else {
                video.setDisplaySize(this.displayWidth, this.displayHeight);
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        video.setVisible(true);
        player = (Player)this.players.get(path);
        try {
            player.start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void pause(String path) {
        if (!this.players.containsKey(path)) {
            return;
        }
        Player player = (Player)this.players.get(path);
        try {
            player.stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stop(String path) {
        if (!this.players.containsKey(path)) {
            return;
        }
        Player player = (Player)this.players.get(path);
        try {
            player.stop();
            player.setMediaTime(0L);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        VideoControl video = (VideoControl)this.videos.get(path);
        video.setVisible(false);
    }

    public final void playerUpdate(Player player, String event, Object eventData) {
        try {
            if (event.equals("endOfMedia")) {
                if (this.listener != null) {
                    this.listener.onVideoFinished();
                }
            } else if (event.equals("deviceUnavailable")) {
                player.stop();
            } else if (event.equals("deviceAvailable")) {
                player.start();
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }
}

