/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.text;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class EFont {
    public static final int TYPE_HEX = 0;
    public static final int TYPE_WEX = 1;
    private String fontName;
    private String fontImagePath;
    private String fontMappingFilePath;
    private Hashtable mappingHash = new Hashtable();
    private int fontType;

    public EFont(String fontName, String fontImagePath, String fontMappingFilePath, int fontType) {
        this.fontName = fontName;
        this.fontImagePath = fontImagePath;
        this.fontMappingFilePath = fontMappingFilePath;
        this.fillMappingHash();
    }

    private void fillMappingHash() {
        StringBuffer fileContent = new StringBuffer();
        try {
            int ch;
            InputStream in = this.getClass().getResourceAsStream(this.fontMappingFilePath);
            InputStreamReader inr = new InputStreamReader(in, "UTF-8");
            while ((ch = inr.read()) != -1) {
                fileContent.append((char)ch);
            }
            in.close();
            inr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        while (content.indexOf(10) != -1) {
            int index = content.indexOf(10);
            String line = content.substring(0, index);
            content = content.substring(index + 1);
            String hexCode = line.substring(0, line.indexOf(124));
            line = line.substring(line.indexOf(124) + 1);
            int x = Integer.parseInt(line.substring(0, line.indexOf(124)));
            line = line.substring(line.indexOf(124) + 1);
            int y = Integer.parseInt(line.substring(0, line.indexOf(124)));
            line = line.substring(line.indexOf(124) + 1);
            int w = Integer.parseInt(line.substring(0, line.indexOf(124)));
            line = line.substring(line.indexOf(124) + 1);
            int h = Integer.parseInt(line.substring(0, line.indexOf(124)));
            this.mappingHash.put(hexCode.length() > 1 ? this._convertString(hexCode) : hexCode, new int[]{x, y, w, h});
        }
    }

    public int[] getUnitMapping(String text) {
        return (int[])this.mappingHash.get(text);
    }

    public Hashtable getMappingHash() {
        return this.mappingHash;
    }

    public int getUnitX(String unit) {
        return ((int[])this.mappingHash.get(unit))[0];
    }

    public int getUnitY(String unit) {
        return ((int[])this.mappingHash.get(unit))[1];
    }

    public int getUnitWidth(String text) {
        return ((int[])this.mappingHash.get(text))[2];
    }

    public int getUnitHeight(String text) {
        return ((int[])this.mappingHash.get(text))[3];
    }

    public String getFontImagePath() {
        return this.fontImagePath;
    }

    public String getFontMappingFilePath() {
        return this.fontMappingFilePath;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontType() {
        return this.fontType;
    }

    private String _convertString(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                return "?";
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

