/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.util.StringEx;
import javax.microedition.lcdui.Graphics;

public class BuyText
extends Component {
    private String text;
    private int adStartX;
    private int adStartY;
    private int adEndX;
    private int adEndY;

    public BuyText(String id) {
        super(id);
        this.width = 150;
        this.height = 150;
        this.x = 0;
        this.y = 0;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        g.translate(this.x, this.y);
        this.saveClip(g);
        g.setClip(0, 0, this.width, this.height);
        if (this.bgColor != -1) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.width - 1, this.height - 1);
        }
        if (this.bg != null) {
            this.bg.paint(g);
        }
        g.setColor(this.fgColor);
        String adText = this.text;
        if (TextWriter.getInstance().getTextWidth(adText) <= this.width) {
            this.adStartX = (this.width - TextWriter.getInstance().getTextWidth(adText)) / 2;
            this.adStartY = (this.height - TextWriter.getInstance().getTextHeight(adText)) / 2;
            this.adEndX = (this.width + TextWriter.getInstance().getTextWidth(adText)) / 2;
            this.adEndY = (this.height + TextWriter.getInstance().getTextHeight(adText)) / 2;
            TextWriter.getInstance().drawText(g, adText, this.adStartX, this.adStartY);
        } else {
            int startY;
            String[] words = StringEx.split(adText, " ");
            int rowNo = TextWriter.getInstance().getTextWidth(adText) % this.width == 0 ? TextWriter.getInstance().getTextWidth(adText) / this.width : TextWriter.getInstance().getTextWidth(adText) / this.width + 1;
            int startX = 0;
            this.adStartX = 0;
            this.adEndX = this.width;
            this.adStartY = startY = (this.height - rowNo * TextWriter.getInstance().getTextHeight(adText)) / 2;
            this.adEndY = (this.height + rowNo * TextWriter.getInstance().getTextHeight(adText)) / 2;
            for (int i = 0; i < words.length; ++i) {
                TextWriter.getInstance().drawText(g, words[i], startX, startY);
                if (i + 2 > words.length || (startX += TextWriter.getInstance().getTextWidth(words[i] + " ")) + TextWriter.getInstance().getTextWidth(words[i + 1] + " ") <= this.width) continue;
                startY += TextWriter.getInstance().getTextHeight(" ");
                startX = 0;
            }
        }
        if (this.fg != null) {
            this.fg.paint(g);
        }
        g.setColor(this.borderColor);
        for (int i = 0; i < this.borderSize; ++i) {
            g.drawRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1);
        }
        this.restoreClip(g);
        g.translate(-this.x, -this.y);
    }
}

