/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.screens;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.manager.IActionListener;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Button;
import com.jarbull.efw.ui.Label;
import com.jarbull.efw.ui.Layout;
import com.jarbull.efw.ui.Screen;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.main.GameStateController;
import javax.microedition.lcdui.Graphics;

public class SelectGameScreen
extends Screen {
    int demoLevelCount;
    boolean active = false;

    public SelectGameScreen(String id, int demoLevelCount) {
        super(id);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.initialize();
    }

    private void initialize() {
        this.clear();
        this.setWriterType(0);
        Label label = new Label("label", "a");
        TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("lao"));
        label.setText("shooseGame", true);
        label.setBgColor(-1);
        label.setSize(ResolutionHandler.getInstance().getCurrentWidth(), TextWriter.getInstance().getTextHeight("a") + 2);
        label.setAlignment(1);
        label.setBorderSize(0);
        label.setFgColor(0xFFFFFF);
        label.setAutoPos(false);
        label.setPosition(ResolutionHandler.getInstance().getCurrentWidth() / 2 - label.getWidth() / 2, 0);
        this.addChild(label);
        Layout lay = new Layout();
        lay.setType(7);
        lay.setArea(0, this.height / 4, this.width, 2 * this.height / 5);
        this.setLayout(lay);
        DataManager.getInstance();
        if (!DataManager.checkNewGameFlag()) {
            this.addChild(this.createButton(LocalizationSupport.getMessage("cont"), "2"));
            this.addChild(this.createButton(LocalizationSupport.getMessage("newGame"), "1"));
        } else {
            this.addChild(this.createButton(LocalizationSupport.getMessage("newGame"), "1"));
        }
    }

    private Button createButton(String text, final String id) {
        Button b = new Button(id);
        EFLiteSprite bgEnabled = new EFLiteSprite("/res/framework/images/button_on.png");
        EFLiteSprite bgDisabled = new EFLiteSprite("/res/framework/images/button_off.png");
        b.setBorderSize(0);
        b.setSelectedBorderSize(0);
        b.setBorderColor(-1);
        b.setSelectedBorderColor(-1);
        b.setBg(bgDisabled);
        b.setSelectedBg(bgEnabled);
        b.setText(text);
        b.setAlignment(2);
        b.setSize(bgEnabled.getWidth(), bgEnabled.getHeight());
        final Action a = new Action(b, "SETCURRENTLEVEL", "0");
        IActionListener al = new IActionListener(){

            public void addAction(int actionType, Action action) {
            }

            public void actionPerformed() {
                if (id.equals("1")) {
                    DataManager.getInstance().resetAllData();
                    LevelHolder.getInstance().resetAllLevels();
                }
                GameStateController.getInstance().setState((byte)1);
                a.doAction();
            }

            public void onSelected() {
            }

            public void onDeselected() {
            }

            public void onValueChange(String newValue) {
            }

            public void onShown() {
            }

            public void onClose() {
            }

            public void onAnimationTimeChange() {
            }
        };
        b.setActionListener(al);
        return b;
    }

    public void pointerPressed(int x, int y) {
        if (y < this.height / 4 - 5) {
            this.selectPrevious();
            return;
        }
        if (y > 3 * this.height / 4 + 5) {
            this.selectNext();
            return;
        }
        super.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        if (y < this.height / 4 - 5) {
            return;
        }
        if (y > 3 * this.height / 4 + 5) {
            return;
        }
        super.pointerReleased(x, y);
    }

    public void paint(Graphics g) {
        g.drawImage(ImageHandler.getInstance().getImage("/res/framework/images/page.png"), 0, 0, 0);
        super.paint(g);
    }
}

