/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.shop;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.patterns.observer.IObserver;
import com.jarbull.platform.shop.ItemsObservable;
import javax.microedition.lcdui.Graphics;

public class Item
implements IObserver {
    private EFSprite sprItem;
    private String[] sItemImgsPaths;
    private String sCursorImgPath;
    private String cost;
    private int x;
    private int y;
    private int id;
    private int orderNo;
    private int state;
    private String name;
    private boolean isSelected;
    private boolean isFocused;

    public Item(int x, int y, int state, String name, String[] sItemImgsPaths, String cursorImgPath, String cost, int id, int orderNo) {
        ItemsObservable.getInstance().registerObserver(this);
        this.cost = cost;
        this.x = x;
        this.y = y;
        this.id = id;
        this.orderNo = orderNo;
        this.name = name;
        this.state = state;
        this.sItemImgsPaths = sItemImgsPaths;
        this.sCursorImgPath = cursorImgPath;
        this.setState(state);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (this.sprItem == null) {
            this.sprItem = new EFSprite(this.sItemImgsPaths[state]);
            this.sprItem.setPosition(this.x, this.y);
        } else {
            this.sprItem.setImage(this.sItemImgsPaths[state], ImageHandler.getInstance().getImage(this.sItemImgsPaths[state]).getWidth(), ImageHandler.getInstance().getImage(this.sItemImgsPaths[state]).getHeight());
        }
    }

    public void update() {
        if (this.id == ItemsObservable.getInstance().getItemId()) {
            if (ItemsObservable.getInstance().isActiveItem()) {
                this.isFocused = true;
                if (this.state > 0) {
                    this.setState(--this.state);
                }
            }
            if (ItemsObservable.getInstance().isSelectedItem()) {
                this.isSelected = true;
                this.setState(this.state);
            }
        } else {
            this.isFocused = false;
            this.isSelected = false;
            this.setState(this.state);
        }
    }

    public boolean getIsPointerPressed(int x, int y) {
        return x > this.x && x < this.x + this.sprItem.getWidth() && y > this.y && y < this.y + this.sprItem.getHeight();
    }

    public void paint(Graphics g) {
        this.sprItem.paint(g);
        if (this.isSelected && this.sCursorImgPath != null) {
            g.drawImage(ImageHandler.getInstance().getImage(this.sCursorImgPath), this.x, this.y, 0);
        }
        if (this.state > 0 && this.cost != null) {
            if (this.id == 7) {
                TextWriter.getInstance().drawText(g, "" + this.cost, this.x + ImageHandler.getInstance().getImage(this.sCursorImgPath).getWidth() / 2 - TextWriter.getInstance().getTextWidth(this.cost) / 2, this.y + ImageHandler.getInstance().getImage(this.sCursorImgPath).getHeight() / 2 - TextWriter.getInstance().getTextHeight(this.cost) / 2);
            } else {
                TextWriter.getInstance().drawText(g, "" + this.cost, this.x + ImageHandler.getInstance().getImage(this.sCursorImgPath).getWidth() / 2 - TextWriter.getInstance().getTextWidth(this.cost) / 2, this.y);
            }
        }
        if (this.id < 6) {
            if (DataManager.getInstance().getUpdateX2() == 1) {
                TextWriter.getInstance().drawText(g, "2", this.x + ImageHandler.getInstance().getImage(this.sCursorImgPath).getWidth() - TextWriter.getInstance().getTextWidth("2"), this.y + ImageHandler.getInstance().getImage(this.sCursorImgPath).getHeight() - TextWriter.getInstance().getTextHeight("2"));
            } else {
                TextWriter.getInstance().drawText(g, "1", this.x + ImageHandler.getInstance().getImage(this.sCursorImgPath).getWidth() - TextWriter.getInstance().getTextWidth("1"), this.y + ImageHandler.getInstance().getImage(this.sCursorImgPath).getHeight() - TextWriter.getInstance().getTextHeight("1"));
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public String getName() {
        return this.name;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }

    public String getCost() {
        return this.cost;
    }

    public boolean isSelected() {
        return this.isSelected;
    }
}

