/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.shop;

import com.jarbull.platform.patterns.observer.IObservable;
import com.jarbull.platform.patterns.observer.IObserver;
import java.util.Vector;

public class ItemsObservable
implements IObservable {
    private static final ItemsObservable instance = new ItemsObservable();
    private Vector observers = new Vector();
    private int currItemId;
    private boolean isSelected;
    private boolean isActive;

    public static ItemsObservable getInstance() {
        return instance;
    }

    public void registerObserver(IObserver o) {
        this.observers.addElement(o);
    }

    public void removeObserver(IObserver o) {
        this.observers.removeElement(o);
    }

    public void removeAllObservers() {
        this.observers.removeAllElements();
    }

    public void notifyObservers() {
        for (int i = this.observers.size() - 1; i >= 0; --i) {
            ((IObserver)this.observers.elementAt(i)).update();
        }
    }

    public void selectedChanged() {
        this.notifyObservers();
    }

    public void selectedItem(int id, boolean isSelected) {
        this.currItemId = id;
        this.isSelected = isSelected;
        this.isActive = false;
        this.selectedChanged();
    }

    public void activeItem(int id, boolean isActive) {
        this.currItemId = id;
        this.isActive = isActive;
        this.isSelected = false;
        this.selectedChanged();
    }

    public int getItemId() {
        return this.currItemId;
    }

    public boolean isSelectedItem() {
        return this.isSelected;
    }

    public boolean isActiveItem() {
        return this.isActive;
    }
}

