/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.IMemoryListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class ImageHandler {
    private static final ImageHandler INSTANCE = new ImageHandler();
    private static final Object LOCK = new Object();
    private Hashtable images = new Hashtable();
    private int totalImageCount = 0;
    private IMemoryListener listener;

    public static ImageHandler getInstance() {
        return INSTANCE;
    }

    private ImageHandler() {
    }

    public IMemoryListener getListener() {
        return this.listener;
    }

    public void setListener(IMemoryListener listener) {
        this.listener = listener;
    }

    public void load(final String[] paths) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    for (int i2 = paths.length - 1; i2 >= 0; --i2) {
                        if (ImageHandler.this.images.containsKey(paths[i2])) continue;
                        ImageHandler.this.totalImageCount++;
                    }
                }
                for (int i = paths.length - 1; i >= 0; --i) {
                    Object i2 = LOCK;
                    synchronized (i2) {
                        try {
                            if (!ImageHandler.this.images.containsKey(paths[i])) {
                                ImageHandler.this.images.put(paths[i], Image.createImage((String)paths[i]));
                            }
                        }
                        catch (IOException ex) {
                            System.out.println("File not found: " + paths[i]);
                        }
                    }
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (ImageHandler.this.listener != null) {
                    ImageHandler.this.listener.onHandlerLoaded();
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) {
        try {
            Object object = LOCK;
            synchronized (object) {
                if (!this.images.containsKey(path)) {
                    ++this.totalImageCount;
                    this.images.put(path, Image.createImage((String)path));
                }
            }
        }
        catch (IOException ex) {
            System.out.println("File not found: " + path);
        }
    }

    public void clear() {
        this.images.clear();
        this.totalImageCount = 0;
    }

    public void clear(String path) {
        if (!this.images.containsKey(path)) {
            return;
        }
        this.images.remove(path);
        --this.totalImageCount;
    }

    public void keep(String[] paths) {
        Enumeration imageEnum = this.images.keys();
        while (imageEnum.hasMoreElements()) {
            String path = (String)imageEnum.nextElement();
            boolean keep = false;
            for (int i = 0; i < paths.length; ++i) {
                if (!path.equals(paths[i])) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.images.remove(path);
        }
        this.totalImageCount = this.images.size();
    }

    void setImage(String path, Image image) {
        if (!this.images.containsKey(path)) {
            ++this.totalImageCount;
        }
        this.images.put(path, image);
    }

    public Image getImage(String path) {
        return (Image)this.images.get(path);
    }

    public boolean isEmpty() {
        return this.images.isEmpty();
    }

    public boolean isLoaded() {
        return this.images.size() == this.totalImageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoadedCount() {
        Object object = LOCK;
        synchronized (object) {
            return this.images.size();
        }
    }

    public int getTotalCount() {
        return this.totalImageCount;
    }
}

