/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.domain;

import com.hardwire.dymix.DynamicWorld;
import com.hardwire.utils.MathUtils;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.domain.Player;
import com.jarbull.platform.domain.PlayersObjList;
import com.jarbull.platform.main.BoombaCanvas;
import com.jarbull.platform.util.Utils;
import javax.microedition.lcdui.Graphics;

public class PlayersManager {
    private static final PlayersManager instance = new PlayersManager();
    PlayersObjList playersObjList;

    public static PlayersManager getInstance() {
        return instance;
    }

    public void initialize(DynamicWorld world) {
        this.playersObjList = new PlayersObjList();
        int boombasCnt = 3 * DataManager.getInstance().getUpdateX2() + DataManager.getInstance().getBoombasCnt();
        int armorsCnt = 3 * DataManager.getInstance().getUpdateX2() + DataManager.getInstance().getArmorsCnt();
        for (int i = 0; i < boombasCnt; ++i) {
            Player player = i >= boombasCnt - armorsCnt ? new Player(world, 30 + i * 8, 192, true, 10000 + i) : new Player(world, 30 + i * 8, 192, false, 10000 + i);
            this.playersObjList.addElement(player);
        }
    }

    public void pointerPressed(int x, int y) {
        int[] tempArr = new int[this.playersObjList.size()];
        for (int i = 0; i < this.playersObjList.size(); ++i) {
            tempArr[i] = ((Player)this.playersObjList.elementAt((int)i)).getPosition().x;
        }
        int[] newArr = Utils.bubleSort(tempArr);
        for (int i = 0; i < this.playersObjList.size(); ++i) {
            ((Player)this.playersObjList.elementAt(newArr[i])).jump((this.playersObjList.size() - i - 1) * 112);
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 202: 
            case 221: {
                int[] tempArr = new int[this.playersObjList.size()];
                for (int i = 0; i < this.playersObjList.size(); ++i) {
                    tempArr[i] = ((Player)this.playersObjList.elementAt((int)i)).getPosition().x;
                }
                int[] newArr = Utils.bubleSort(tempArr);
                for (int i = 0; i < this.playersObjList.size(); ++i) {
                    ((Player)this.playersObjList.elementAt(newArr[i])).jump((this.playersObjList.size() - i - 1) * 112);
                }
                break;
            }
        }
    }

    public PlayersObjList getPlayersObjList() {
        return this.playersObjList;
    }

    public void draw(Graphics g) {
        if (this.playersObjList != null) {
            for (int i = 0; i < this.playersObjList.size(); ++i) {
                ((Player)this.playersObjList.elementAt(i)).draw(g);
            }
        }
    }

    public void tick() {
        if (this.playersObjList != null) {
            int startPosPlayers = BoombaCanvas.distance + 30;
            int endPosPlayers = startPosPlayers + this.playersObjList.size() * 8;
            for (int i = 0; i < this.playersObjList.size(); ++i) {
                Player player = (Player)this.playersObjList.elementAt(i);
                player.tick();
                int playerX = player.getPosition_shiftedRight().x;
                if (player.isActive) {
                    if (playerX < startPosPlayers + i * 8) {
                        player.getLinearVelocity().set(5046, player.getLinearVelocity().y);
                    } else if (playerX > endPosPlayers - (this.playersObjList.size() - i) * 8) {
                        player.getLinearVelocity().set(3096, player.getLinearVelocity().y);
                    } else {
                        player.getLinearVelocity().set(4096, player.getLinearVelocity().y);
                    }
                }
                if (playerX + 32 >= BoombaCanvas.distance && !player.isRemoved && player.getPosition_shiftedRight().y <= 400) continue;
                player.despawnPlayer();
                this.playersObjList.removeElement(player);
            }
        }
    }

    public void moveInStartPos(int[] dx) {
        if (this.playersObjList != null) {
            for (int i = 0; i < this.playersObjList.size(); ++i) {
                ((Player)this.playersObjList.elementAt(i)).moveInStartPos(dx[i]);
            }
        }
    }

    public void despawnPlayers() {
        if (this.playersObjList != null) {
            for (int i = 0; i < this.playersObjList.size(); ++i) {
                ((Player)this.playersObjList.elementAt(i)).despawnPlayer();
                this.playersObjList.removeElementAt(i);
            }
        }
    }

    public int getX() {
        int x = 0;
        for (int i = 0; i < this.playersObjList.size(); ++i) {
            int playerX = ((Player)this.playersObjList.elementAt((int)i)).getPosition().x;
            if (x >= playerX) continue;
            x = playerX;
        }
        return MathUtils.shiftRight(x);
    }

    public int getY() {
        int y = 0;
        for (int i = 0; i < this.playersObjList.size(); ++i) {
            y += ((Player)this.playersObjList.elementAt((int)i)).getPosition().y;
        }
        if (this.playersObjList.isEmpty()) {
            return 0;
        }
        return MathUtils.shiftRight(y / this.playersObjList.size());
    }
}

