/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.util;

import com.hardwire.dymix.DynamicWorld;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.EFTiledLayer;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.platform.data.MapBgManager;
import com.jarbull.platform.data.MapFgManager1;
import com.jarbull.platform.data.MapFgManager2;
import com.jarbull.platform.data.MapFgManager3;
import com.jarbull.platform.data.MapFgManager4;
import com.jarbull.platform.domain.PhyObjManager;
import com.jarbull.platform.domain.Player;
import com.jarbull.platform.domain.PlayersManager;
import com.jarbull.platform.main.BoombaCanvas;
import com.jarbull.platform.util.Pattern;
import com.jarbull.platform.util.PatternGenerator;
import com.jarbull.platform.util.RandomGenerator;
import com.jarbull.platform.util.Utils;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class PatternManager {
    private static final PatternManager instance = new PatternManager();
    private Vector vecPattern = new Vector();
    private byte[][] currPatternArr;
    EFTiledLayer patternFon4;
    EFTiledLayer patternFon2;
    EFTiledLayer patternFon3;
    private byte[][] patternFon2Arr;
    private byte[][] patternFon3Arr;
    private int startPosXFon2;
    private int startPosXFon3;
    private int tileCntForWidth = ResolutionHandler.getInstance().getScreenWidth() % 16 > 0 ? ResolutionHandler.getInstance().getScreenWidth() / 16 + 1 : ResolutionHandler.getInstance().getScreenWidth() / 16;

    public static PatternManager getInstance() {
        return instance;
    }

    public void checkCreatePattern(int distance, DynamicWorld world) {
        if (this.vecPattern.isEmpty()) {
            this.currPatternArr = this.getPatternArr(0, 0);
            PhyObjManager.getInstance().createPhyObjects(this.currPatternArr, 0, world);
            Pattern pattern = PatternGenerator.getInstance().createPattern(world, this.currPatternArr, ImageHandler.getInstance().getImage("/res/game/images/tilesets" + LevelHolder.getInstance().getCurrentLevel() + "/fonMain.png"), "platform");
            this.vecPattern.addElement(pattern);
            this.createBgPattern();
            System.out.println("PATTERN IS EMPTY");
        }
        for (int i = this.vecPattern.size() - 1; i >= 0; --i) {
            Pattern currPattern = (Pattern)this.vecPattern.elementAt(i);
            if (BoombaCanvas.distance < currPattern.getWidth() - this.tileCntForWidth * 16 || this.vecPattern.size() >= 2) continue;
            this.vecPattern.removeElement(currPattern);
            int patternNumber = RandomGenerator.getInstance().generateRandomBetween(0, 3);
            int typePattern = 0;
            if (BoombaCanvas.distanceTotal < 2000) {
                typePattern = 0;
                System.out.println("EASY PATTERN");
            } else if (BoombaCanvas.distanceTotal < 6000) {
                typePattern = 1;
                System.out.println("MEDIUM PATTERN");
            } else {
                typePattern = 2;
                System.out.println("HARD PATTERN");
            }
            byte[][] newPatternArr = this.getPatternArr(typePattern, patternNumber);
            int startColumnArr = this.currPatternArr[0].length - this.tileCntForWidth;
            byte[][] currMap = Utils.concatArrays(this.currPatternArr, newPatternArr, startColumnArr);
            PhyObjManager.getInstance().moveInStartPos(startColumnArr * 16);
            PhyObjManager.getInstance().createPhyObjects(currMap, currMap[0].length - newPatternArr[0].length, world);
            for (int j = 0; j < currMap.length; ++j) {
                for (int k = 0; k < currMap[j].length; ++k) {
                    switch (currMap[j][k]) {
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: {
                            currMap[j][k] = 0;
                        }
                    }
                }
            }
            Pattern pattern = PatternGenerator.getInstance().createPattern(world, currMap, ImageHandler.getInstance().getImage("/res/game/images/tilesets" + LevelHolder.getInstance().getCurrentLevel() + "/fonMain.png"), "platform");
            int[] dxForPlayers = new int[PlayersManager.getInstance().getPlayersObjList().size()];
            for (int j = 0; j < PlayersManager.getInstance().getPlayersObjList().size(); ++j) {
                dxForPlayers[j] = ((Player)PlayersManager.getInstance().getPlayersObjList().elementAt((int)j)).getPosition_shiftedRight().x - BoombaCanvas.distance;
            }
            this.createBgPattern();
            PlayersManager.getInstance().moveInStartPos(dxForPlayers);
            BoombaCanvas.distance = 0;
            PhyObjManager.getInstance().tick();
            this.currPatternArr = currMap;
            this.vecPattern.removeAllElements();
            this.vecPattern.addElement(pattern);
            System.gc();
        }
    }

    private byte[][] getPatternArr(int type, int patternNo) {
        byte[][] patternArr = new byte[0][0];
        if (BoombaCanvas.levelNo < 1) {
            switch (type) {
                case 0: {
                    patternArr = MapFgManager1.getInstance().generateMainFonEasy(patternNo);
                    break;
                }
                case 1: {
                    patternArr = MapFgManager1.getInstance().generateMainFonMedium(patternNo);
                    break;
                }
                case 2: {
                    patternArr = MapFgManager1.getInstance().generateMainFonHard(patternNo);
                }
            }
        } else if (BoombaCanvas.levelNo < 2) {
            switch (type) {
                case 0: {
                    patternArr = MapFgManager2.getInstance().generateMainFonEasy(patternNo);
                    break;
                }
                case 1: {
                    patternArr = MapFgManager2.getInstance().generateMainFonMedium(patternNo);
                    break;
                }
                case 2: {
                    patternArr = MapFgManager2.getInstance().generateMainFonHard(patternNo);
                }
            }
        } else if (BoombaCanvas.levelNo < 3) {
            switch (type) {
                case 0: {
                    patternArr = MapFgManager3.getInstance().generateMainFonEasy(patternNo);
                    break;
                }
                case 1: {
                    patternArr = MapFgManager3.getInstance().generateMainFonMedium(patternNo);
                    break;
                }
                case 2: {
                    patternArr = MapFgManager3.getInstance().generateMainFonHard(patternNo);
                }
            }
        } else {
            switch (type) {
                case 0: {
                    patternArr = MapFgManager4.getInstance().generateMainFonEasy(patternNo);
                    break;
                }
                case 1: {
                    patternArr = MapFgManager4.getInstance().generateMainFonMedium(patternNo);
                    break;
                }
                case 2: {
                    patternArr = MapFgManager4.getInstance().generateMainFonHard(patternNo);
                }
            }
        }
        return patternArr;
    }

    private void createBgPattern() {
        if (this.patternFon2 == null) {
            this.patternFon2Arr = MapBgManager.getInstance().generateFon2(BoombaCanvas.levelNo);
            this.patternFon2 = Utils.initEFTiledLayer(this.patternFon2Arr, "/res/game/images/tilesets" + LevelHolder.getInstance().getCurrentLevel() + "/fon2.png", 16, 16);
        } else {
            double startColumnArr = (double)this.patternFon2Arr[0].length - ((double)(this.patternFon2Arr[0].length * 16) - (BoombaCanvas.translateX - (double)this.patternFon2.getX())) / 16.0;
            if ((double)this.patternFon2Arr[0].length - startColumnArr < 30.0) {
                this.patternFon2Arr = Utils.concatArrays(this.patternFon2Arr, MapBgManager.getInstance().generateFon2(BoombaCanvas.levelNo), (int)startColumnArr);
                this.patternFon2 = Utils.initEFTiledLayer(this.patternFon2Arr, "/res/game/images/tilesets" + LevelHolder.getInstance().getCurrentLevel() + "/fon2.png", 16, 16);
                System.out.println("<<<<<<30");
                this.startPosXFon2 = (int)((startColumnArr - (double)((int)startColumnArr)) * 16.0);
                System.out.println("startPosXFon2 - " + this.startPosXFon2);
            } else {
                System.out.println(">>>>>30");
                this.startPosXFon2 = (int)(startColumnArr * 16.0);
                System.out.println("startPosXFon2 - " + this.startPosXFon2);
            }
        }
    }

    public void paint(Graphics g) {
        if (BoombaCanvas.levelNo == 0) {
            g.setColor(5406144);
        } else if (BoombaCanvas.levelNo == 1) {
            g.setColor(16754457);
        } else if (BoombaCanvas.levelNo == 2) {
            g.setColor(0x202333);
        } else if (BoombaCanvas.levelNo == 3) {
            g.setColor(3095075);
        }
        g.fillRect((int)BoombaCanvas.translateX, -BoombaCanvas.translateY, ResolutionHandler.getInstance().getCurrentWidth(), ResolutionHandler.getInstance().getCurrentHeight());
        if (this.patternFon2 != null) {
            this.patternFon2.setPosition((int)(BoombaCanvas.translateX / 1.4) - this.startPosXFon2, 0);
            this.patternFon2.paint(g);
        }
        int vecSize = this.vecPattern.size();
        for (int i = this.vecPattern.size() - 1; i >= 0 && vecSize == this.vecPattern.size(); --i) {
            Pattern pattern = (Pattern)this.vecPattern.elementAt(i);
            pattern.paint(g);
        }
    }

    public void tick() {
    }

    public void removeAll() {
        this.vecPattern.removeAllElements();
        this.patternFon4 = null;
        this.patternFon3 = null;
        this.patternFon2 = null;
        this.patternFon2Arr = null;
        this.startPosXFon2 = 0;
    }
}

