/*
 * Decompiled with CFR 0.152.
 */
package json.me.util;

import java.util.Enumeration;
import json.me.JSONArray;
import json.me.JSONObject;
import json.me.JSONTokener;
import json.me.util.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean a(XMLTokener xMLTokener, JSONObject jSONObject, String string) {
        String string2;
        Object object = xMLTokener.nextToken();
        if (object == BANG) {
            char c2 = xMLTokener.next();
            if (c2 == '-') {
                if (xMLTokener.next() == '-') {
                    xMLTokener.skipPast("-->");
                    return false;
                }
                xMLTokener.back();
            } else if (c2 == '[') {
                object = xMLTokener.nextToken();
                if (object.equals("CDATA") && xMLTokener.next() == '[') {
                    String string3 = xMLTokener.nextCDATA();
                    if (string3.length() > 0) {
                        jSONObject.accumulate("content", string3);
                    }
                    return false;
                }
                throw xMLTokener.syntaxError("Expected 'CDATA['");
            }
            int n = 1;
            do {
                if ((object = xMLTokener.nextMeta()) == null) {
                    throw xMLTokener.syntaxError("Missing '>' after '<!'.");
                }
                if (object == LT) {
                    ++n;
                    continue;
                }
                if (object != GT) continue;
                --n;
            } while (n > 0);
            return false;
        }
        if (object == QUEST) {
            xMLTokener.skipPast("?>");
            return false;
        }
        if (object == SLASH) {
            if (string == null || !xMLTokener.nextToken().equals(string)) {
                throw xMLTokener.syntaxError("Mismatched close tag");
            }
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (object instanceof Character) {
            throw xMLTokener.syntaxError("Misshaped tag");
        }
        String string4 = (String)object;
        object = null;
        JSONObject jSONObject2 = new JSONObject();
        while (true) {
            if (object == null) {
                object = xMLTokener.nextToken();
            }
            if (!(object instanceof String)) break;
            string2 = (String)object;
            object = xMLTokener.nextToken();
            if (object == EQ) {
                object = xMLTokener.nextToken();
                if (!(object instanceof String)) {
                    throw xMLTokener.syntaxError("Missing value");
                }
                jSONObject2.accumulate(string2, object);
                object = null;
                continue;
            }
            jSONObject2.accumulate(string2, "");
        }
        if (object == SLASH) {
            if (xMLTokener.nextToken() != GT) {
                throw xMLTokener.syntaxError("Misshaped tag");
            }
            jSONObject.accumulate(string4, jSONObject2);
            return false;
        }
        if (object == GT) {
            while (true) {
                if ((object = xMLTokener.nextContent()) == null) {
                    if (string != null) {
                        throw xMLTokener.syntaxError("Unclosed tag " + string);
                    }
                    return false;
                }
                if (object instanceof String) {
                    string2 = (String)object;
                    if (string2.length() <= 0) continue;
                    jSONObject2.accumulate("content", string2);
                    continue;
                }
                if (object == LT && XML.a(xMLTokener, jSONObject2, string4)) break;
            }
            if (jSONObject2.length() == 0) {
                jSONObject.accumulate(string4, "");
            } else if (jSONObject2.length() == 1 && jSONObject2.opt("content") != null) {
                jSONObject.accumulate(string4, jSONObject2.opt("content"));
            } else {
                jSONObject.accumulate(string4, jSONObject2);
            }
            return false;
        }
        throw xMLTokener.syntaxError("Misshaped tag");
    }

    public static JSONObject toJSONObject(String object) {
        JSONObject jSONObject = new JSONObject();
        object = new XMLTokener((String)object);
        while (((JSONTokener)object).more()) {
            ((JSONTokener)object).skipPast("<");
            XML.a((XMLTokener)object, jSONObject, null);
        }
        return jSONObject;
    }

    public static String toString(Object object) {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof JSONObject) {
            if (string != null) {
                stringBuffer.append('<');
                stringBuffer.append(string);
                stringBuffer.append('>');
            }
            JSONObject jSONObject = (JSONObject)object;
            Enumeration enumeration = jSONObject.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                JSONArray jSONArray;
                String string2 = enumeration.nextElement().toString();
                object = jSONObject.get(string2);
                if (string2.equals("content")) {
                    if (object instanceof JSONArray) {
                        jSONArray = (JSONArray)object;
                        n = jSONArray.length();
                        for (int i = 0; i < n; ++i) {
                            if (i > 0) {
                                stringBuffer.append('\n');
                            }
                            stringBuffer.append(XML.escape(jSONArray.get(i).toString()));
                        }
                        continue;
                    }
                    stringBuffer.append(XML.escape(object.toString()));
                    continue;
                }
                if (object instanceof JSONArray) {
                    jSONArray = (JSONArray)object;
                    n = jSONArray.length();
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(XML.toString(jSONArray.get(i), string2));
                    }
                    continue;
                }
                if (object.equals("")) {
                    stringBuffer.append('<');
                    stringBuffer.append(string2);
                    stringBuffer.append("/>");
                    continue;
                }
                stringBuffer.append(XML.toString(object, string2));
            }
            if (string != null) {
                stringBuffer.append("</");
                stringBuffer.append(string);
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(XML.toString(jSONArray.opt(i), string == null ? "array" : string));
            }
            return stringBuffer.toString();
        }
        Object object2 = object = object == null ? "null" : XML.escape(object.toString());
        if (string == null) {
            return "\"" + (String)object + "\"";
        }
        if (((String)object).length() == 0) {
            return "<" + string + "/>";
        }
        return "<" + string + ">" + (String)object + "</" + string + ">";
    }
}

