/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import mynotes.Commands;
import mynotes.FileDescriptor;
import mynotes.MainMenu;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class Export
extends Form
implements MyDisplayable,
CommandListener {
    private static TextField path;
    private static Alert jsr75NotSupported;
    private static Alert exportError;
    private static Alert exportComplete;
    private static Alert waitExport;
    private static Gauge gauge;
    private boolean exportFinished;
    private boolean errors;

    public Export() {
        super(ResourceBundle.getString("ex-title"));
        if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
            jsr75NotSupported = new Alert("MyNotes", ResourceBundle.getString("ex-nojsr75"), null, AlertType.WARNING);
            jsr75NotSupported.setTimeout(-2);
            MyNotes.display.setCurrent(jsr75NotSupported, MainMenu.menu.getDisplayable());
            return;
        }
        String fullname = "";
        try {
            fullname = System.getProperty("fileconn.dir.photos") + "MN_" + Utils.dateAsString2(System.currentTimeMillis()) + ".mn1";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        path = new TextField(ResourceBundle.getString("ex-path"), fullname, 120, 0);
        this.addCommand(Commands.BACK);
        this.addCommand(Commands.OK);
        this.append((Item)path);
        this.setCommandListener(this);
    }

    public void activate() {
        MyNotes.display.setCurrent((Displayable)this);
    }

    public void updateGauge() {
        if (gauge == null) {
            return;
        }
        int newValue = gauge.getValue() + 1;
        if (newValue < gauge.getMaxValue()) {
            gauge.setValue(gauge.getValue() + 1);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == Commands.OK) {
            String filename = path.getString();
            if (filename.length() == 0) {
                return;
            }
            this.errors = false;
            try {
                FileConnection fc = (FileConnection)Connector.open((String)filename);
                if (!fc.exists()) {
                    fc.create();
                    fc.close();
                    fc = (FileConnection)Connector.open((String)filename, (int)2);
                }
                gauge = new Gauge(null, false, MyNotes.fs.files.size(), 0);
                final OutputStream os = fc.openOutputStream();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Export.this.writeAllDataToStream(os);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }).start();
                waitExport = new Alert("MyNotes", ResourceBundle.getString("ex-wait"), null, AlertType.INFO);
                waitExport.addCommand(Commands.DUMMY);
                waitExport.setTimeout(-2);
                waitExport.setIndicator(gauge);
                waitExport.setCommandListener((CommandListener)this);
                MyNotes.display.setCurrent((Displayable)waitExport);
            }
            catch (Exception ex) {
                this.errors = true;
                ex.printStackTrace();
            }
            new Thread(new Runnable(){

                public void run() {
                    try {
                        while (!Export.this.exportFinished) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (Export.this.errors) {
                        exportError = new Alert("MyNotes", ResourceBundle.getString("ex-errors"), null, AlertType.ERROR);
                        exportError.setTimeout(2000);
                        MyNotes.display.setCurrent(exportError, MainMenu.menu.getDisplayable());
                    } else {
                        exportComplete = new Alert("MyNotes", ResourceBundle.getString("ex-ok"), null, AlertType.INFO);
                        exportComplete.setTimeout(2000);
                        MyNotes.display.setCurrent(exportComplete, MainMenu.menu.getDisplayable());
                    }
                }
            }).start();
        }
        if (c == Commands.BACK) {
            MyNotes.menu.activate();
        }
    }

    public void writeAllDataToStream(OutputStream os) {
        this.exportFinished = false;
        try {
            FileDescriptor fd;
            int i;
            DataOutputStream dos = new DataOutputStream(os);
            Vector files = MyNotes.fs.files;
            dos.writeInt(files.size());
            int notesCount = 0;
            for (i = 0; i < files.size(); ++i) {
                fd = (FileDescriptor)files.elementAt(i);
                byte[] data = fd.toByteArray();
                dos.writeInt(data.length);
                dos.write(data, 0, data.length);
                if (fd.isDirectory) continue;
                ++notesCount;
            }
            dos.writeInt(notesCount);
            for (i = 0; i < files.size(); ++i) {
                Note note;
                this.updateGauge();
                fd = (FileDescriptor)files.elementAt(i);
                if (fd.isDirectory || (note = MyNotes.fs.getNote(fd.id)) == null) continue;
                byte[] data = note.toByteArray();
                dos.writeInt(data.length);
                dos.write(data, 0, data.length);
            }
            dos.close();
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.exportFinished = true;
    }
}

