/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.Commands;
import mynotes.FileDescriptor;
import mynotes.MainMenu;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.NotesFileSystem;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class Import
implements MyDisplayable,
CommandListener {
    private static RecordStore rs;
    private static Alert jsr75NotSupported;
    private static Alert importError;
    private static Alert importComplete;
    private static MyList filesToImportFrom;
    private static Alert waitImport;
    private static Gauge gauge;
    private boolean importFinished;
    private boolean errors;

    public Import() {
        if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
            jsr75NotSupported = new Alert("MyNotes", ResourceBundle.getString("ex-nojsr75"), null, AlertType.WARNING);
            jsr75NotSupported.setTimeout(-2);
            MyNotes.display.setCurrent(jsr75NotSupported, MainMenu.menu.getDisplayable());
            return;
        }
        filesToImportFrom = new MyList(ResourceBundle.getString("im-title"));
        try {
            FileConnection fc = (FileConnection)Connector.open((String)System.getProperty("fileconn.dir.photos"));
            Enumeration e = fc.list("*.mn1", true);
            while (e.hasMoreElements()) {
                filesToImportFrom.append((String)e.nextElement(), null);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        filesToImportFrom.setSelectedIndex(0);
        filesToImportFrom.addCommand(Commands.BACK, 5);
        filesToImportFrom.addCommand(Commands.OK, 8);
        filesToImportFrom.setCommandListener(this);
    }

    public void activate() {
        filesToImportFrom.activate();
    }

    public void updateGauge() {
        if (gauge == null) {
            return;
        }
        int newValue = gauge.getValue() + 1;
        if (newValue < gauge.getMaxValue()) {
            gauge.setValue(gauge.getValue() + 1);
        }
    }

    public void import_(InputStream is) {
        try {
            byte[] data;
            FileDescriptor fd;
            int i;
            MyNotes.fs.deleteAllData();
            DataInputStream dis = new DataInputStream(is);
            int size = dis.readInt();
            Vector<FileDescriptor> files = new Vector<FileDescriptor>();
            files.setSize(size);
            for (i = 0; i < size; ++i) {
                fd = new FileDescriptor();
                int length = dis.readInt();
                data = new byte[length];
                dis.read(data, 0, length);
                fd.fromByteArray(data);
                files.setElementAt(fd, i);
            }
            for (i = 0; i < size; ++i) {
                fd = (FileDescriptor)files.elementAt(i);
                if (!fd.isDirectory) continue;
                this.updateGauge();
                NotesFileSystem.openDirStorage(fd.id);
                NotesFileSystem.closeStorage();
            }
            int notesCount = dis.readInt();
            block14: for (int i2 = 0; i2 < notesCount; ++i2) {
                this.updateGauge();
                try {
                    int length = dis.readInt();
                    if (length == 0) continue;
                    data = new byte[length];
                    dis.read(data, 0, length);
                    Note note = new Note();
                    note.fromByteArray(data);
                    for (int j = 0; j < size; ++j) {
                        FileDescriptor fd2 = (FileDescriptor)files.elementAt(j);
                        if (fd2.id != note.id) continue;
                        try {
                            rs = RecordStore.openRecordStore((String)("dir" + new Integer(fd2.parentDirId)), (boolean)true);
                            Utils.encrypt(data);
                            fd2.dirRecordId = rs.addRecord(data, 0, length);
                            rs.closeRecordStore();
                        }
                        catch (RecordStoreException ex) {
                            ex.printStackTrace();
                        }
                        continue block14;
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                rs = RecordStore.openRecordStore((String)"fs", (boolean)true);
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
            try {
                for (int i3 = 0; i3 < size; ++i3) {
                    FileDescriptor fd3 = (FileDescriptor)files.elementAt(i3);
                    data = fd3.toByteArray();
                    rs.addRecord(data, 0, data.length);
                }
                rs.closeRecordStore();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            dis.close();
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            MyNotes.fs.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (d == filesToImportFrom) {
            if (c == Commands.OK) {
                try {
                    if (filesToImportFrom.size() == 0) {
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    String filename = System.getProperty("fileconn.dir.photos") + filesToImportFrom.getString(filesToImportFrom.getSelectedIndex());
                    FileConnection fc = (FileConnection)Connector.open((String)filename, (int)1);
                    if (!fc.exists()) {
                        return;
                    }
                    final InputStream is = fc.openInputStream();
                    int filesCount = MyNotes.fs.files.size();
                    gauge = new Gauge(null, false, filesCount, 0);
                    waitImport = new Alert("MyNotes", ResourceBundle.getString("im-wait"), null, AlertType.INFO);
                    waitImport.addCommand(Commands.DUMMY);
                    waitImport.setTimeout(-2);
                    waitImport.setIndicator(gauge);
                    waitImport.setCommandListener((CommandListener)this);
                    MyNotes.display.setCurrent((Displayable)waitImport);
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                Import.this.importFinished = false;
                                Import.this.import_(is);
                                Import.this.importFinished = true;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }).start();
                }
                catch (Exception ex) {
                    this.errors = true;
                    ex.printStackTrace();
                }
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (!Import.this.importFinished) {
                                Thread.sleep(100L);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (Import.this.errors) {
                            importError = new Alert("MyNotes", ResourceBundle.getString("im-errors"), null, AlertType.ERROR);
                            importError.setTimeout(2000);
                            MyNotes.display.setCurrent(importError, MainMenu.menu.getDisplayable());
                        } else {
                            importComplete = new Alert("MyNotes", ResourceBundle.getString("im-ok"), null, AlertType.INFO);
                            importComplete.setTimeout(2000);
                            MyNotes.display.setCurrent(importComplete, MainMenu.menu.getDisplayable());
                        }
                    }
                }).start();
            }
            if (c == Commands.BACK) {
                MyNotes.menu.activate();
            }
        }
    }
}

