/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import mynotes.Commands;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyMenuItem;
import mynotes.MyNotes;

public class MyMenu
implements MyDisplayable,
CommandListener {
    int savePos;
    private MyList list;
    private Vector items;
    private MyDisplayable back;

    public MyMenu(String name) {
        this.list = new MyList(name);
        this.list.addCommand(Commands.SELECT, 8);
        this.list.setCommandListener(this);
        this.items = new Vector();
        this.savePos = 0;
        this.back = null;
        this.list.updateFont();
    }

    public MyList getList() {
        return this.list;
    }

    public void setTitle(String title) {
        this.list.setTitle(title);
    }

    public void addBackCommand(MyDisplayable b) {
        this.back = b;
        this.list.addCommand(Commands.BACK, 5);
    }

    public void addExitCommand() {
        this.list.addCommand(Commands.EXIT, 5);
    }

    public void addItem(String name, Image icon, MyMenuItem item) {
        this.list.append(name, icon);
        this.items.addElement(item);
    }

    public void deleteItem(int index) {
        this.list.delete(index);
        this.items.removeElementAt(index);
    }

    public void commandAction(Command c, Displayable d) {
        int index = this.list.getSelectedIndex();
        if (c.equals(Commands.SELECT)) {
            this.savePos = index;
            MyMenuItem item = (MyMenuItem)this.items.elementAt(index);
            if (item != null) {
                item.menuAction();
            }
        }
        if (c == Commands.BACK) {
            this.savePos = index;
            this.back.activate();
        }
        if (c == Commands.EXIT) {
            MyNotes.mynotes.destroyApp(false);
        }
    }

    public void activate() {
        this.list.setSelectedIndex(this.savePos);
        this.list.activate();
    }

    public Displayable getDisplayable() {
        return this.list;
    }
}

