/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import mynotes.CheckListEditor;
import mynotes.Commands;
import mynotes.Confirmation;
import mynotes.FileDescriptor;
import mynotes.FileProperties;
import mynotes.Find;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.TextEditor;
import mynotes.TextViewer;

public class NotesBrowser
implements CommandListener,
MyDisplayable {
    private static MyList list;
    public static Image noteIcon;
    public static Image dirIcon;
    public static Image checkListIcon;
    public Vector files;
    private Stack lastPos;
    private int savePos;
    private Stack dirNameLengths;
    private int currentDir;
    private final int ACTION_NOTHING;
    private final int ACTION_NEW_DIR;
    private final int ACTION_NEW_NOTE;
    private final int ACTION_NEW_CHECKLIST;
    private final int ACTION_RENAME;
    private final int ACTION_BACK;
    private final int ACTION_DELETE;
    private final int ACTION_EDIT;
    private final int ACTION_EDIT_CHECKLIST;
    private final int ACTION_PROPERTIES;
    private int lastAction;
    public TextEditor textEditor;
    private TextViewer textViewer;
    private CheckListEditor checkListEditor;
    private Confirmation alert;
    private Note note;
    private FileProperties properties;
    private final int NOTHING;
    private int idToCopy;
    private boolean cut;
    boolean isRealDirectory;

    public NotesBrowser() {
        this.ACTION_NOTHING = 0;
        this.ACTION_NEW_DIR = 1;
        this.ACTION_NEW_NOTE = 2;
        this.ACTION_NEW_CHECKLIST = 21;
        this.ACTION_RENAME = 3;
        this.ACTION_BACK = 4;
        this.ACTION_DELETE = 5;
        this.ACTION_EDIT = 6;
        this.ACTION_EDIT_CHECKLIST = 61;
        this.ACTION_PROPERTIES = 7;
        this.NOTHING = -1;
        try {
            noteIcon = Image.createImage((String)"/res/note.png");
            dirIcon = Image.createImage((String)"/res/folder.png");
            checkListIcon = Image.createImage((String)"/res/checklist.png");
        }
        catch (Exception ex) {
            noteIcon = null;
            dirIcon = null;
            checkListIcon = null;
            ex.printStackTrace();
        }
        list = new MyList("/");
        this.isRealDirectory = false;
        this.setRealDirectoryMode(true);
        this.files = new Vector();
        this.currentDir = 0;
        this.textEditor = new TextEditor();
        this.textViewer = new TextViewer();
        this.checkListEditor = new CheckListEditor();
        this.alert = new Confirmation();
        this.properties = new FileProperties();
        this.idToCopy = -1;
        this.cut = false;
        this.initBackStack();
    }

    public void initBackStack() {
        this.lastPos = new Stack();
        this.savePos = 0;
        this.dirNameLengths = new Stack();
        this.dirNameLengths.push(new Integer(0));
        list.setTitle("/");
    }

    public final void setRealDirectoryMode(boolean real) {
        list.deleteCommands();
        list.addCommand(Commands.SELECT, 8);
        list.addCommand(Commands.BACK, 5);
        if (real) {
            list.addCommand(Commands.NEWNOTE, 2);
            list.addCommand(Commands.NEWCHECKLIST, 2);
            list.addCommand(Commands.NEWDIR, 2);
            list.addCommand(Commands.CUT, 2);
            list.addCommand(Commands.COPY, 2);
            list.addCommand(Commands.PASTE, 2);
            list.addCommand(Commands.DELETE, 2);
            list.addCommand(Commands.RENAME, 2);
            list.addCommand(Commands.PROPERTIES, 2);
            this.isRealDirectory = true;
        }
        if (!real) {
            this.isRealDirectory = false;
        }
        list.updateMenuWidth();
        list.setCommandListener(this);
    }

    public void showDir(int dir, int cursor) {
        this.setRealDirectoryMode(true);
        this.currentDir = dir;
        this.files.removeAllElements();
        this.files = MyNotes.fs.getDirectoryListing(dir, 0);
        list.deleteAll();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fd = (FileDescriptor)this.files.elementAt(i);
            if (fd.isDirectory) {
                list.append(fd.name, dirIcon);
                continue;
            }
            if ((fd.type & 0x100) == 0) {
                list.append(fd.name, noteIcon);
                continue;
            }
            list.append(fd.name, checkListIcon);
        }
        if (cursor < list.size() && cursor >= 0) {
            NotesBrowser.list.topItemIndex = 0;
            list.setSelectedIndex(cursor);
        }
    }

    public void showSearchResults(String text, boolean byContent, boolean caseSensitive) {
        this.setRealDirectoryMode(false);
        this.files.removeAllElements();
        this.files = byContent ? MyNotes.fs.getListingByContent(text, caseSensitive) : MyNotes.fs.getListingByName(text, caseSensitive);
        list.setTitle(ResourceBundle.getString("nb-found") + " " + this.files.size());
        list.deleteAll();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fd = (FileDescriptor)this.files.elementAt(i);
            if ((fd.type & 0x100) == 0) {
                list.append(fd.name, noteIcon);
                continue;
            }
            list.append(fd.name, checkListIcon);
        }
        list.setSelectedIndex(0);
        Find.gauge = null;
        this.activate();
    }

    public void savePos() {
        this.savePos = list.getSelectedIndex();
    }

    public int locate(int id) {
        int pos = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fd = (FileDescriptor)this.files.elementAt(i);
            if (fd.id != id) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public void activate() {
        int status;
        int selectedId = -1;
        int cursor = 0;
        boolean emptyList = this.files.isEmpty();
        int pos = 0;
        FileDescriptor fd = null;
        if (!emptyList) {
            pos = list.getSelectedIndex();
            fd = (FileDescriptor)this.files.elementAt(pos);
        }
        if ((status = this.textEditor.getStatus()) == 0) {
            cursor = this.savePos;
        }
        if (status == 1) {
            String text = this.textEditor.getText();
            switch (this.lastAction) {
                case 6: {
                    this.note.text = text;
                    MyNotes.fs.setNote(this.note.id, this.note);
                    cursor = this.savePos;
                    break;
                }
                case 61: {
                    cursor = this.savePos;
                    break;
                }
                case 1: {
                    selectedId = MyNotes.fs.makeDir(text, this.currentDir);
                    break;
                }
                case 2: {
                    selectedId = MyNotes.fs.makeNote(text, this.currentDir, 17);
                    break;
                }
                case 21: {
                    selectedId = MyNotes.fs.makeNote(text, this.currentDir, 273);
                    break;
                }
                case 3: {
                    if (pos == 0 && fd.name.equals("..") && fd.parentDirId != -1) break;
                    MyNotes.fs.rename(fd.id, text);
                    selectedId = fd.id;
                    break;
                }
            }
        }
        if (this.lastAction == 5) {
            int astatus = this.alert.getStatus();
            if (astatus == 1) {
                MyNotes.fs.delete(fd.id);
                int newPos = pos;
                if (pos == list.size() - 1) {
                    --newPos;
                }
                cursor = newPos;
            } else if (astatus == 2) {
                cursor = this.savePos;
            }
        }
        if (this.lastAction == 4 || this.lastAction == 7) {
            cursor = this.savePos;
        }
        this.lastAction = 0;
        if (this.isRealDirectory) {
            this.showDir(this.currentDir, 0);
        }
        if (selectedId != -1) {
            cursor = this.locate(selectedId);
        }
        if (list.size() != 0) {
            if (cursor < list.size() && cursor >= 0) {
                list.setSelectedIndex(cursor);
            } else {
                list.setSelectedIndex(0);
            }
        }
        list.activate();
    }

    public void commandAction(Command c, Displayable d) {
        int lp;
        boolean isListEmpty = this.files.isEmpty();
        int pos = 0;
        FileDescriptor fd = null;
        if (!isListEmpty) {
            pos = list.getSelectedIndex();
            fd = (FileDescriptor)this.files.elementAt(pos);
        }
        if (c == Commands.SELECT) {
            if (isListEmpty) {
                return;
            }
            String dirName = list.getTitle();
            if (fd.isDirectory) {
                if (fd.name.equals("..") && pos == 0) {
                    int prevDirNameLength = (Integer)this.dirNameLengths.pop();
                    list.setTitle(dirName.substring(0, dirName.length() - prevDirNameLength - 1));
                    lp = (Integer)this.lastPos.pop();
                    this.showDir(fd.parentDirId, lp);
                } else {
                    this.lastPos.push(new Integer(pos));
                    list.setTitle(dirName.concat(fd.name).concat("/"));
                    this.dirNameLengths.push(new Integer(fd.name.length()));
                    this.showDir(fd.id, 0);
                }
            } else if ((fd.type & 0x100) == 0) {
                this.note = MyNotes.fs.getNote(fd.id);
                if (this.note != null) {
                    this.savePos = pos;
                    this.lastAction = 6;
                    if (this.note.text.length() == 0) {
                        this.textEditor.start(2, fd.name, this.note.text, this, this.textViewer);
                    } else {
                        this.textViewer.start(fd.name, this.note.text, this, this.textEditor);
                    }
                }
            } else {
                this.savePos = pos;
                this.lastAction = 61;
                this.checkListEditor.start(fd, this);
            }
        }
        if (c == Commands.NEWDIR) {
            this.lastAction = 1;
            this.textEditor.start(1, ResourceBundle.getString("nb-dirname"), "", this, null);
        }
        if (c == Commands.NEWNOTE) {
            this.lastAction = 2;
            this.textEditor.start(1, ResourceBundle.getString("nb-notename"), "", this, null);
        }
        if (c == Commands.NEWCHECKLIST) {
            this.lastAction = 21;
            this.textEditor.start(1, ResourceBundle.getString("nb-checkname"), "", this, null);
        }
        if (c == Commands.RENAME) {
            if (isListEmpty) {
                return;
            }
            this.lastAction = 3;
            this.textEditor.start(1, ResourceBundle.getString("nb-newname"), fd.name, this, null);
        }
        if (c == Commands.DELETE) {
            if (isListEmpty) {
                return;
            }
            if (fd.name.equals("..")) {
                return;
            }
            this.savePos = pos;
            this.lastAction = 5;
            this.alert.startAlert("MyNotes", ResourceBundle.getString("nb-delconfirm"), null, AlertType.CONFIRMATION);
        }
        if (c == Commands.PROPERTIES) {
            if (isListEmpty) {
                return;
            }
            if (fd.name.equals("..")) {
                return;
            }
            this.savePos = pos;
            this.lastAction = 7;
            this.properties.prepare(fd);
            this.properties.activate();
        }
        if (c == Commands.COPY) {
            if (isListEmpty) {
                return;
            }
            if (fd.name.equals("..")) {
                return;
            }
            this.idToCopy = fd.id;
            this.cut = false;
        }
        if (c == Commands.CUT) {
            if (isListEmpty) {
                return;
            }
            if (fd.name.equals("..")) {
                return;
            }
            this.idToCopy = fd.id;
            this.cut = true;
        }
        if (c == Commands.PASTE) {
            if (this.idToCopy == -1) {
                return;
            }
            FileDescriptor fdToCopy = MyNotes.fs.getDescriptorById(this.idToCopy);
            if (fdToCopy.parentDirId == this.currentDir && this.cut) {
                this.idToCopy = -1;
            } else {
                int id = MyNotes.fs.makeCopy(this.idToCopy, this.currentDir, this.cut);
                this.showDir(this.currentDir, list.getSelectedIndex());
                list.setSelectedIndex(this.locate(id));
            }
            if (this.cut) {
                this.idToCopy = -1;
                this.cut = false;
            }
        }
        if (c == Commands.BACK) {
            if (this.isRealDirectory) {
                if (this.currentDir == 0) {
                    MyNotes.menu.activate();
                    return;
                }
                int prevDirNameLength = (Integer)this.dirNameLengths.pop();
                String dirName = list.getTitle();
                list.setTitle(dirName.substring(0, dirName.length() - prevDirNameLength - 1));
                lp = (Integer)this.lastPos.pop();
                FileDescriptor thisDir = MyNotes.fs.getDescriptorById(this.currentDir);
                this.showDir(thisDir.parentDirId, lp);
            } else {
                MyNotes.find.activate();
            }
        }
    }
}

