/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import mynotes.Commands;
import mynotes.FileDescriptor;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.TextEditor;
import mynotes.Utils;

public class CheckListEditor
implements CommandListener,
MyDisplayable {
    FileDescriptor startFd;
    private static MyList list;
    public Vector itemCheckedStatuses;
    public Vector itemNames;
    public MyDisplayable back;
    public static Image checkedIcon;
    public static Image uncheckedIcon;
    private TextEditor textEditor;
    int cursor;
    int savePos;
    private final int ACTION_NOTHING;
    private final int ACTION_NEW_ITEM;
    private final int ACTION_RENAME;
    private final int ACTION_DELETE;
    int lastAction;
    private Alert saveModified;
    String initialText;

    public CheckListEditor() {
        this.ACTION_NOTHING = 0;
        this.ACTION_NEW_ITEM = 1;
        this.ACTION_RENAME = 2;
        this.ACTION_DELETE = 3;
        try {
            checkedIcon = Image.createImage((String)"/res/checked.png");
            uncheckedIcon = Image.createImage((String)"/res/unchecked.png");
        }
        catch (Exception ex) {
            checkedIcon = null;
            uncheckedIcon = null;
            ex.printStackTrace();
        }
        list = new MyList("");
        this.itemCheckedStatuses = new Vector();
        this.itemNames = new Vector();
        list.deleteCommands();
        list.addCommand(Commands.SELECT, 8);
        list.addCommand(Commands.BACK, 5);
        list.addCommand(Commands.NEWITEM, 2);
        list.addCommand(Commands.SAVE, 2);
        list.addCommand(Commands.RENAME, 2);
        list.addCommand(Commands.MOVEUP, 2);
        list.addCommand(Commands.MOVEDOWN, 2);
        list.addCommand(Commands.DELETE, 2);
        list.setCommandListener(this);
        this.textEditor = new TextEditor();
        this.saveModified = new Alert("MyNotes", ResourceBundle.getString("nb-saveconfirm"), null, AlertType.CONFIRMATION);
        this.saveModified.addCommand(Commands.YES);
        this.saveModified.addCommand(Commands.NO);
        this.saveModified.addCommand(Commands.CANCEL);
        this.saveModified.setCommandListener((CommandListener)this);
        this.saveModified.setTimeout(-2);
    }

    public void load(FileDescriptor fd) {
        list.deleteAll();
        this.itemCheckedStatuses.removeAllElements();
        this.itemNames.removeAllElements();
        list.setTitle(fd.name);
        if (fd.isDirectory) {
            return;
        }
        if ((fd.type & 0x100) == 0) {
            return;
        }
        Note note = MyNotes.fs.getNote(fd.id);
        this.initialText = note.text;
        if (note.text.length() == 0) {
            return;
        }
        int nlPosition = 0;
        int prevNlPosition = -1;
        String text = "";
        while ((nlPosition = note.text.indexOf(10, prevNlPosition + 1)) != -1) {
            text = note.text.substring(prevNlPosition + 1, nlPosition);
            this.itemCheckedStatuses.addElement(text.substring(0, 1).equals("@") ? Boolean.TRUE : Boolean.FALSE);
            this.itemNames.addElement(text.substring(1, text.length()));
            prevNlPosition = nlPosition;
        }
        this.updateList();
        list.setSelectedIndex(0);
    }

    public String getString() {
        String text = "";
        for (int i = 0; i < this.itemNames.size(); ++i) {
            boolean checked = (Boolean)this.itemCheckedStatuses.elementAt(i);
            text = text + (checked ? "@" : "#") + (String)this.itemNames.elementAt(i) + "\n";
        }
        return text;
    }

    public void save(FileDescriptor fd) {
        if (fd.isDirectory) {
            return;
        }
        if ((fd.type & 0x100) == 0) {
            return;
        }
        Note note = new Note();
        note.id = fd.id;
        note.text = this.getString();
        MyNotes.fs.setNote(note.id, note);
    }

    public void updateList() {
        list.deleteAll();
        for (int i = 0; i < this.itemNames.size(); ++i) {
            if (((Boolean)this.itemCheckedStatuses.elementAt(i)).booleanValue()) {
                list.append((String)this.itemNames.elementAt(i), checkedIcon);
                continue;
            }
            list.append((String)this.itemNames.elementAt(i), uncheckedIcon);
        }
    }

    public void activate() {
        int status = this.textEditor.getStatus();
        if (status == 0) {
            this.cursor = this.savePos;
        }
        if (status == 1) {
            if (this.lastAction == 1) {
                this.itemCheckedStatuses.addElement(Boolean.FALSE);
                this.itemNames.addElement(this.textEditor.getText());
                list.append(this.textEditor.getText(), uncheckedIcon);
                this.cursor = list.size() - 1;
            }
            if (this.lastAction == 2) {
                this.cursor = this.savePos;
                this.itemNames.setElementAt(this.textEditor.getText(), this.cursor);
                list.set(this.cursor, this.textEditor.getText(), CheckListEditor.list.images[this.cursor]);
            }
        }
        this.lastAction = 0;
        list.setSelectedIndex(this.cursor);
        list.activate();
    }

    public void start(FileDescriptor fd, MyDisplayable back) {
        this.back = back;
        this.savePos = 0;
        this.startFd = fd;
        this.load(fd);
        this.activate();
    }

    public void commandAction(Command c, Displayable d) {
        boolean isListEmpty;
        int selected = list.getSelectedIndex();
        boolean bl = isListEmpty = list.size() == 0;
        if (d == this.saveModified) {
            if (c == Commands.CANCEL) {
                list.activate();
            }
            if (c == Commands.YES) {
                this.commandAction(Commands.SAVE, null);
            }
            if (c == Commands.NO) {
                this.back.activate();
            }
            return;
        }
        if (c == Commands.BACK) {
            if (this.back == null) {
                return;
            }
            if (!this.getString().equals(this.initialText)) {
                MyNotes.display.setCurrent((Displayable)this.saveModified);
            } else {
                this.back.activate();
            }
            return;
        }
        if (c == Commands.SELECT) {
            if (isListEmpty) {
                return;
            }
            boolean b = (Boolean)this.itemCheckedStatuses.elementAt(selected);
            this.itemCheckedStatuses.setElementAt(b ? Boolean.FALSE : Boolean.TRUE, selected);
            CheckListEditor.list.images[selected] = b ? uncheckedIcon : checkedIcon;
            list.repaint();
            return;
        }
        if (c == Commands.NEWITEM) {
            this.savePos = selected;
            this.lastAction = 1;
            this.textEditor.start(1, ResourceBundle.getString("ce-itemname"), "", this, null);
            return;
        }
        if (c == Commands.RENAME) {
            this.savePos = selected;
            this.lastAction = 2;
            this.textEditor.start(1, ResourceBundle.getString("ce-itemname"), (String)this.itemNames.elementAt(selected), this, null);
            return;
        }
        if (c == Commands.MOVEUP) {
            if (selected == 0) {
                return;
            }
            Utils.swapVectorElements(this.itemNames, selected, selected - 1);
            Utils.swapVectorElements(this.itemCheckedStatuses, selected, selected - 1);
            list.set(selected, (String)this.itemNames.elementAt(selected), CheckListEditor.list.images[selected]);
            list.set(selected - 1, (String)this.itemNames.elementAt(selected - 1), CheckListEditor.list.images[selected - 1]);
            list.setSelectedIndex(selected - 1);
            list.repaint();
            return;
        }
        if (c == Commands.MOVEDOWN) {
            if (selected == list.size() - 9) {
                return;
            }
            Utils.swapVectorElements(this.itemNames, selected, selected + 1);
            Utils.swapVectorElements(this.itemCheckedStatuses, selected, selected + 1);
            list.set(selected, (String)this.itemNames.elementAt(selected), CheckListEditor.list.images[selected]);
            list.set(selected + 1, (String)this.itemNames.elementAt(selected + 1), CheckListEditor.list.images[selected + 1]);
            list.setSelectedIndex(selected + 1);
            list.repaint();
            return;
        }
        if (c == Commands.DELETE) {
            if (isListEmpty) {
                return;
            }
            this.itemNames.removeElementAt(selected);
            this.itemCheckedStatuses.removeElementAt(selected);
            this.updateList();
            this.cursor = list.size() != 0 ? (selected >= list.size() ? list.size() - 1 : selected) : 0;
            list.setSelectedIndex(this.cursor);
            return;
        }
        if (c == Commands.SAVE) {
            this.save(this.startFd);
            this.back.activate();
            return;
        }
    }
}

