/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import javax.microedition.lcdui.Graphics;
import mynotes.ChangeColorScheme;
import mynotes.ChangeFont;
import mynotes.ChangeLanguage;
import mynotes.ChangePassword;
import mynotes.Export;
import mynotes.Import;
import mynotes.MyDisplayable;
import mynotes.MyMenu;
import mynotes.MyMenuItem;
import mynotes.MyNotes;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class MainMenu
implements MyDisplayable {
    public static MyMenu menu;

    public MainMenu() {
        menu = new MyMenu("MyNotes");
        menu.addItem(ResourceBundle.getString("mm-notes"), Utils.getResImage("/res/notes.png"), new MyMenuItem(){

            public void menuAction() {
                MyNotes.notesBrowser.setRealDirectoryMode(true);
                MyNotes.notesBrowser.initBackStack();
                MyNotes.notesBrowser.activate();
            }
        });
        menu.addItem(ResourceBundle.getString("mm-find"), Utils.getResImage("/res/find.png"), new MyMenuItem(){

            public void menuAction() {
                MyNotes.find.activate();
            }
        });
        menu.addItem(ResourceBundle.getString("mm-pwd"), Utils.getResImage("/res/password.png"), new MyMenuItem(){

            public void menuAction() {
                ChangePassword chPwd = new ChangePassword();
                if (chPwd != null) {
                    chPwd.activate();
                }
            }
        });
        menu.addItem(ResourceBundle.getString("mm-lang"), Utils.getResImage("/res/lang.png"), new MyMenuItem(){

            public void menuAction() {
                ChangeLanguage chLng = new ChangeLanguage();
                if (chLng != null) {
                    chLng.activate();
                }
            }
        });
        menu.addItem(ResourceBundle.getString("mm-colors"), Utils.getResImage("/res/colors.png"), new MyMenuItem(){

            public void menuAction() {
                ChangeColorScheme schemeChooser = new ChangeColorScheme();
                schemeChooser.activate();
            }
        });
        menu.addItem(ResourceBundle.getString("mm-fonts"), Utils.getResImage("/res/font.png"), new MyMenuItem(){

            public void menuAction() {
                ChangeFont changeFont = new ChangeFont();
                changeFont.activate();
            }
        });
        menu.addItem(ResourceBundle.getString("mm-export"), Utils.getResImage("/res/export.png"), new MyMenuItem(){

            public void menuAction() {
                Export export = new Export();
                export.activate();
            }
        });
        menu.addItem(ResourceBundle.getString("mm-import"), Utils.getResImage("/res/import.png"), new MyMenuItem(){

            public void menuAction() {
                Import import_ = new Import();
                import_.activate();
            }
        });
        menu.addItem(ResourceBundle.getString("mm-about"), Utils.getResImage("/res/about.png"), new MyMenuItem(){

            public void menuAction() {
                MyNotes.about.activate();
            }
        });
        menu.addExitCommand();
        Runnable r = new Runnable(){

            public void run() {
                Graphics g = null;
                try {
                    while (g == null) {
                        g = MainMenu.menu.getList().g;
                        Thread.sleep(200L);
                    }
                    while (true) {
                        String time = Utils.timeAsString(System.currentTimeMillis());
                        if (g != null) {
                            String space = " ";
                            int spaceWidth = g.getFont().stringWidth(space);
                            int timeWidth = g.getFont().stringWidth(time);
                            int nameWidth = g.getFont().stringWidth("MyNotes");
                            int spaceNumber = (MainMenu.menu.getList().width - nameWidth - timeWidth) / spaceWidth;
                            String spaces = "";
                            for (int i = 0; i < spaceNumber; ++i) {
                                spaces = spaces + " ";
                            }
                            String title = "MyNotes" + spaces + time;
                            menu.setTitle(title);
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        };
        new Thread(r).start();
    }

    public void activate() {
        menu.activate();
    }
}

