/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.Property;

public class Properties {
    private String storageName;
    RecordStore rs;
    Hashtable pairs = new Hashtable();

    public Properties(String name) {
        this.storageName = name;
    }

    public void loadTable() {
        this.openStorage();
        this.pairs.clear();
        try {
            RecordEnumeration re = this.rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                Property p = new Property();
                int id = re.nextRecordId();
                byte[] data = this.rs.getRecord(id);
                if (!p.fromByteArray(data)) continue;
                p.rsId = id;
                this.pairs.put(p.key, p);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.closeStorage();
    }

    public void put(String key, Object value, int type) {
        Property p = null;
        if (this.pairs.containsKey(key)) {
            p = (Property)this.pairs.get(key);
        } else {
            p = new Property();
            p.rsId = -1;
        }
        p.type = type;
        p.key = key;
        p.value = value;
        this.openStorage();
        byte[] data = p.toByteArray();
        try {
            if (p.rsId != -1) {
                this.rs.setRecord(p.rsId, data, 0, data.length);
            } else {
                p.rsId = this.rs.addRecord(data, 0, data.length);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.closeStorage();
        this.pairs.put(p.key, p);
    }

    public Integer getIntValue(String key) {
        Integer result = null;
        Property p = (Property)this.pairs.get(key);
        if (p != null && p.value != null && p.value.getClass().getName().equals("java.lang.Integer")) {
            result = (Integer)p.value;
        }
        return result;
    }

    public String getStringValue(String key) {
        String result = null;
        Property p = (Property)this.pairs.get(key);
        if (p != null && p.value != null && p.value.getClass().getName().equals("java.lang.String")) {
            result = (String)p.value;
        }
        return result;
    }

    public void removePair(String key) {
        Property p = (Property)this.pairs.get(key);
        this.openStorage();
        try {
            this.rs.deleteRecord(p.rsId);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.closeStorage();
        this.pairs.remove(key);
    }

    private boolean openStorage() {
        try {
            this.rs = RecordStore.openRecordStore((String)this.storageName, (boolean)true);
        }
        catch (RecordStoreException ex) {
            return false;
        }
        return true;
    }

    private boolean closeStorage() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
            }
            catch (RecordStoreException ex) {
                return false;
            }
        }
        return true;
    }
}

