/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.FileDescriptor;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.TextViewer;
import mynotes.Utils;

public class FileProperties
implements MyDisplayable {
    RecordStore rs = null;
    String info = "";

    public void prepare(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            return;
        }
        this.info = ResourceBundle.getString("fp-name") + ": " + fileDescriptor.name + "\n";
        String string = "";
        string = fileDescriptor.isDirectory ? ResourceBundle.getString("fp-dir") : ((fileDescriptor.type & 0x100) == 0 ? ResourceBundle.getString("fp-file") : ResourceBundle.getString("fp-checklist"));
        this.info = this.info + ResourceBundle.getString("fp-type") + ": " + string + "\n";
        this.info = this.info + ResourceBundle.getString("fp-crdate") + ": " + Utils.dateAsString(fileDescriptor.date) + "\n";
        if (fileDescriptor.isDirectory) {
            try {
                this.rs = RecordStore.openRecordStore((String)("dir" + fileDescriptor.id), (boolean)false);
                if (this.rs != null) {
                    this.info = this.info + ResourceBundle.getString("fp-size") + ": " + this.rs.getSize() + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-avail") + ": " + this.rs.getSizeAvailable() + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-numrecords") + ": " + this.rs.getNumRecords() + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-modifdate") + ": " + Utils.dateAsString(this.rs.getLastModified()) + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-version") + ": " + this.rs.getVersion() + "\n";
                    this.rs.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        } else {
            this.info = this.info + ResourceBundle.getString("fp-size") + ": " + fileDescriptor.size + "\n";
            this.info = this.info + ResourceBundle.getString("fp-fsrecno") + ": " + fileDescriptor.dirRecordId + "\n";
        }
        this.info = this.info + ResourceBundle.getString("fp-dsrecno") + ": " + fileDescriptor.recordId + "\n";
        this.info = this.info + ResourceBundle.getString("fp-id") + ": " + fileDescriptor.id + "\n";
        this.info = this.info + ResourceBundle.getString("fp-parent") + ": " + fileDescriptor.parentDirId + "\n";
        if ((fileDescriptor.type & 0x100) != 0) {
            Note note = MyNotes.fs.getNote(fileDescriptor.id);
            int n = 0;
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            String string2 = "";
            while ((n = note.text.indexOf(10, n2 + 1)) != -1) {
                string2 = note.text.substring(n2 + 1, n);
                ++n3;
                if (string2.substring(0, 1).equals("@")) {
                    ++n4;
                }
                n2 = n;
            }
            this.info = n3 == 0 ? this.info + ResourceBundle.getString("fp-checked") + ": 0" : this.info + ResourceBundle.getString("fp-checked") + ": " + n4 + "/" + n3 + " (" + n4 * 100 / n3 + "%)";
        }
    }

    public void activate() {
        TextViewer textViewer = new TextViewer();
        textViewer.start(ResourceBundle.getString("fp-title"), this.info, MyNotes.notesBrowser, null);
    }
}

