/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mynotes.ColorScheme;
import mynotes.MyNotes;
import mynotes.ResourceBundle;

public class MyList
extends Canvas {
    static final int SIZE_INC = 5;
    int numOfItems = 0;
    String[] strings = new String[5];
    Image[] images = new Image[5];
    int currentItem;
    Graphics g;
    int x = 0;
    int y = 0;
    int width = this.getWidth();
    int height = this.getHeight();
    Font font;
    Font menuFont;
    int lineHeight;
    int menuLineHeight;
    int topItem;
    boolean isFirstRun;
    int scrollBarWidth = 5;
    int totalHeight;
    int menuBarHeight;
    int titleBarHeight;
    int listHeight;
    int menuWidth;
    boolean inMenu;
    CommandListener listener;
    String title;
    Vector commands;
    int currentCommand;

    public MyList(String string) {
        this.updateFont();
        this.title = string;
        this.isFirstRun = true;
        this.topItem = 0;
        this.lineHeight = 18;
        this.menuLineHeight = 18;
        this.menuBarHeight = 18;
        this.titleBarHeight = 18;
        this.commands = new Vector();
        this.deleteCommands();
        this.inMenu = false;
    }

    public void deleteCommands() {
        this.commands.removeAllElements();
        this.commands.addElement(null);
        this.commands.addElement(null);
    }

    public void initGraphics(Graphics graphics) {
        this.g = graphics;
        this.x = 0;
        this.y = 0;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.updateFont();
        this.updateMenuWidth();
    }

    public void updateMenuWidth() {
        int n = 0;
        for (int i = 2; i < this.commands.size(); ++i) {
            Command command = (Command)this.commands.elementAt(i);
            int n2 = this.menuFont.stringWidth(command.getLabel());
            if (n2 <= n) continue;
            n = n2;
        }
        this.menuWidth = n;
    }

    public void updateFont() {
        this.font = Font.getFont((int)0, (int)0, (int)0);
        this.menuBarHeight = this.lineHeight = this.font.getHeight() + 2;
        this.titleBarHeight = this.lineHeight;
        this.listHeight = this.height - this.menuBarHeight - this.titleBarHeight;
        this.menuFont = Font.getFont((int)0, (int)0, (int)8);
        this.menuLineHeight = this.menuFont.getHeight() + 2;
    }

    public int append(String string, Image image) {
        if (this.numOfItems == this.strings.length) {
            String[] stringArray = new String[this.numOfItems + 5];
            Image[] imageArray = new Image[this.numOfItems + 5];
            System.arraycopy(this.strings, 0, stringArray, 0, this.numOfItems);
            System.arraycopy(this.images, 0, imageArray, 0, this.numOfItems);
            this.strings = stringArray;
            this.images = imageArray;
        }
        this.strings[this.numOfItems] = string;
        this.images[this.numOfItems] = image;
        ++this.numOfItems;
        this.repaint();
        return this.numOfItems;
    }

    public void set(int n, String string, Image image) {
        if (n < 0 || n > this.numOfItems) {
            throw new IndexOutOfBoundsException();
        }
        this.strings[n] = string;
        this.images[n] = image;
        this.repaint();
    }

    public void delete(int n) {
        if (n < 0 || n > this.numOfItems) {
            throw new IndexOutOfBoundsException();
        }
        if (n != this.numOfItems - 1) {
            System.arraycopy(this.strings, n + 1, this.strings, n, this.numOfItems - n - 1);
            System.arraycopy(this.images, n + 1, this.images, n, this.numOfItems - n - 1);
        }
        --this.numOfItems;
        if (this.currentItem > n) {
            --this.currentItem;
        }
        if (this.currentItem >= this.numOfItems) {
            this.currentItem = this.numOfItems - 1;
        }
        this.repaint();
    }

    public void deleteAll() {
        this.numOfItems = 0;
        this.repaint();
    }

    public void setSelectedIndex(int n) {
        int n2;
        if (n < 0 || n > this.numOfItems) {
            throw new IndexOutOfBoundsException();
        }
        this.currentItem = n;
        int n3 = this.listHeight / this.lineHeight;
        if (this.currentItem < this.topItem) {
            this.topItem = this.currentItem;
        }
        if ((n2 = this.topItem + n3 - 1) > this.numOfItems) {
            n2 = this.numOfItems;
        }
        if (this.currentItem >= n2) {
            this.topItem += this.currentItem - n2;
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.currentItem;
    }

    public int size() {
        return this.numOfItems;
    }

    public void drawList() {
        this.g.setFont(this.font);
        this.g.setColor(ColorScheme.CL_LISTBACKGROUND);
        this.g.fillRect(this.x, this.y, this.width, this.height);
        this.g.setColor(ColorScheme.CL_LISTFONT);
        int n = this.y + this.titleBarHeight - this.lineHeight;
        for (int i = this.topItem; i < this.numOfItems && (n += this.lineHeight) <= this.listHeight; ++i) {
            if (i == this.currentItem) {
                this.g.setColor(ColorScheme.CL_SELECTEDBACKGROUND);
                this.g.fillRect(this.x, n, this.width - this.scrollBarWidth, this.lineHeight);
                this.g.setColor(ColorScheme.CL_SELECTEDFONT);
            } else {
                this.g.setColor(ColorScheme.CL_LISTFONT);
            }
            this.g.setFont(this.font);
            this.g.drawString(this.strings[i], this.x + 20, n + 1, 20);
            if (this.images[i] == null) continue;
            this.g.drawImage(this.images[i], this.x + 1, n + this.lineHeight / 2, 6);
        }
    }

    void drawTitleBar() {
        this.g.setColor(ColorScheme.CL_TITLEBARBACKGROUND);
        this.g.fillRect(this.x, this.y, this.width, this.titleBarHeight);
        this.g.setColor(ColorScheme.CL_TITLEBARFONT);
        if (this.title != null) {
            this.g.setFont(this.font);
            this.g.drawString(this.title, this.x + 1, this.y + 1, 20);
        }
    }

    void drawMenuBar() {
        Command command;
        this.g.setFont(this.font);
        this.g.setColor(ColorScheme.CL_MENUBARBACKGROUND);
        this.g.fillRect(this.x, this.height - this.menuBarHeight, this.width, this.menuBarHeight);
        this.g.setColor(ColorScheme.CL_MENUBARFONT);
        if (this.commands.size() > 2) {
            if (this.commands.size() == 3) {
                command = (Command)this.commands.elementAt(2);
                this.g.drawString(command.getLabel(), 3, this.height - this.menuBarHeight + 1, 20);
            } else {
                this.g.drawString(ResourceBundle.getString("menu"), 3, this.height - this.menuBarHeight + 1, 20);
            }
        }
        if ((command = (Command)this.commands.elementAt(1)) != null) {
            this.g.drawString(command.getLabel(), this.width - 3, this.height - this.menuBarHeight + 1, 24);
        }
        if ((command = (Command)this.commands.elementAt(0)) != null) {
            this.g.drawString(command.getLabel(), (this.width - this.scrollBarWidth) / 2, this.height - this.menuBarHeight + 1, 17);
        }
    }

    public void drawScrollBar() {
        this.totalHeight = this.numOfItems * this.lineHeight;
        int n = this.topItem * this.lineHeight;
        int n2 = this.totalHeight - n;
        int n3 = n2 > this.listHeight ? this.listHeight : n2;
        int n4 = 0;
        int n5 = 0;
        double d = 1.0;
        if (this.totalHeight < this.listHeight) {
            n5 = 0;
            n4 = this.listHeight;
            d = 1.0;
        } else {
            d = (double)n3 / (double)this.totalHeight;
            if (d < 0.1) {
                d = 0.1;
            }
            n4 = (int)((double)this.listHeight * d);
            n5 = (int)((double)this.listHeight * (double)n / (double)this.totalHeight);
        }
        if (n4 != this.listHeight) {
            this.g.setColor(ColorScheme.CL_SCROLLBAR);
            this.g.fillRect(this.width - this.scrollBarWidth, this.y + this.titleBarHeight, this.scrollBarWidth, this.listHeight);
            this.g.setColor(ColorScheme.CL_SCROLLBOX);
            this.g.fillRect(this.width - this.scrollBarWidth, this.y + this.titleBarHeight + n5, this.scrollBarWidth, n4);
        }
    }

    public void drawMenu() {
        this.g.setFont(this.menuFont);
        int n = this.commands.size() - 2;
        this.g.setColor(ColorScheme.CL_MENUBACKGROUND);
        this.g.fillRect(0, this.height - this.menuBarHeight - n * this.menuLineHeight - 1, this.menuWidth + 11, n * this.menuLineHeight + 1);
        this.g.setColor(ColorScheme.CL_MENUBORDER);
        this.g.drawRect(0, this.height - this.menuBarHeight - n * this.menuLineHeight - 1, this.menuWidth + 11, n * this.menuLineHeight + 1);
        if (n != 0) {
            for (int i = 2; i < this.commands.size(); ++i) {
                Command command = (Command)this.commands.elementAt(i);
                if (i - 2 == this.currentCommand) {
                    this.g.setColor(ColorScheme.CL_SELECTEDMENUBACKGROUND);
                    this.g.fillRect(1, this.height - this.menuBarHeight - (n - i + 2) * this.menuLineHeight, this.menuWidth + 10, this.menuLineHeight);
                    this.g.setColor(ColorScheme.CL_SELECTEDMENUFONT);
                } else {
                    this.g.setColor(ColorScheme.CL_MENUFONT);
                }
                this.g.drawString(command.getLabel(), 5, this.height - this.menuBarHeight - (n - i + 2) * this.menuLineHeight, 20);
            }
        }
    }

    protected void paint(Graphics graphics) {
        if (this.isFirstRun) {
            this.initGraphics(graphics);
            this.isFirstRun = false;
        }
        this.drawList();
        this.drawScrollBar();
        this.drawMenuBar();
        this.drawTitleBar();
        if (this.inMenu && this.commands.size() > 2) {
            this.drawMenu();
        }
    }

    public void activate() {
        this.inMenu = false;
        this.setFullScreenMode(true);
        MyNotes.display.setCurrent((Displayable)this);
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public String getString(int n) {
        if (n >= 0 && n < this.strings.length) {
            return this.strings[n];
        }
        return null;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.listener = commandListener;
    }

    protected void keyRepeated(int n) {
        if (this.hasRepeatEvents()) {
            // empty if block
        }
    }

    protected void keyPressed(int n) {
        Command command;
        int n2 = 2128506;
        try {
            n2 = this.getGameAction(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n == -7 || n == -22 || n == 22 || n == -203 || n == 35) {
            if (this.inMenu) {
                this.inMenu = false;
            } else if (this.listener != null) {
                command = (Command)this.commands.elementAt(1);
                this.listener.commandAction(command, (Displayable)this);
            }
        }
        if (n == -6 || n == -21 || n == 21 || n == -202 || n == 42) {
            if (!this.inMenu && this.commands.size() > 2) {
                if (this.commands.size() == 3) {
                    command = (Command)this.commands.elementAt(2);
                    this.listener.commandAction(command, (Displayable)this);
                } else {
                    this.inMenu = true;
                    this.currentCommand = 0;
                }
            } else if (this.inMenu) {
                this.inMenu = false;
            }
        }
        if ((n2 == 8 || n == 53) && this.listener != null) {
            command = (Command)this.commands.elementAt(this.inMenu ? this.currentCommand + 2 : 0);
            this.inMenu = false;
            this.listener.commandAction(command, (Displayable)this);
        }
        if (n2 == 1 || n == 50) {
            if (this.inMenu) {
                this.currentCommand = this.currentCommand != 0 ? --this.currentCommand : this.commands.size() - 3;
            } else if (this.numOfItems != 0) {
                this.lineUp();
            }
        }
        if (n2 == 6 || n == 56) {
            if (this.inMenu) {
                this.currentCommand = this.currentCommand != this.commands.size() - 3 ? ++this.currentCommand : 0;
            } else if (this.numOfItems != 0) {
                this.lineDown();
            }
        }
        if (!(n2 != 2 && n != 51 || this.inMenu || this.numOfItems == 0)) {
            this.pageUp();
        }
        if (!(n2 != 5 && n != 57 || this.inMenu || this.numOfItems == 0)) {
            this.pageDown();
        }
        if (n == 49) {
            if (!this.inMenu) {
                if (this.numOfItems != 0) {
                    this.currentItem = 0;
                }
            } else {
                this.currentCommand = 0;
            }
        }
        if (n == 55) {
            if (!this.inMenu) {
                if (this.numOfItems != 0) {
                    this.currentItem = this.numOfItems - 1;
                }
            } else {
                this.currentCommand = this.commands.size() - 3;
            }
        }
        this.setSelectedIndex(this.currentItem);
    }

    public void addCommand(Command command, int n) {
        switch (n) {
            case 5: {
                this.commands.setElementAt(command, 1);
                break;
            }
            case 8: {
                this.commands.setElementAt(command, 0);
                break;
            }
            case 2: {
                this.commands.addElement(command);
            }
        }
    }

    public void lineDown() {
        this.currentItem = this.currentItem != this.numOfItems - 1 ? ++this.currentItem : 0;
    }

    public void lineUp() {
        this.currentItem = this.currentItem != 0 ? --this.currentItem : this.numOfItems - 1;
    }

    public void pageUp() {
        this.currentItem -= 5;
        if (this.currentItem < 0) {
            this.currentItem = 0;
        }
    }

    public void pageDown() {
        this.currentItem += 5;
        if (this.currentItem >= this.numOfItems) {
            this.currentItem = this.numOfItems - 1;
        }
    }
}

