/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import mynotes.Commands;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyMenuItem;
import mynotes.MyNotes;

public class MyMenu
implements MyDisplayable,
CommandListener {
    int savePos;
    private MyList list;
    private Vector items;
    private MyDisplayable back;

    public MyMenu(String string) {
        this.list = new MyList(string);
        this.list.addCommand(Commands.SELECT, 8);
        this.list.setCommandListener(this);
        this.items = new Vector();
        this.savePos = 0;
        this.back = null;
        this.list.updateFont();
    }

    public MyList getList() {
        return this.list;
    }

    public void setTitle(String string) {
        this.list.setTitle(string);
    }

    public void addBackCommand(MyDisplayable myDisplayable) {
        this.back = myDisplayable;
        this.list.addCommand(Commands.BACK, 5);
    }

    public void addExitCommand() {
        this.list.addCommand(Commands.EXIT, 5);
    }

    public void addItem(String string, Image image, MyMenuItem myMenuItem) {
        this.list.append(string, image);
        this.items.addElement(myMenuItem);
    }

    public void deleteItem(int n) {
        this.list.delete(n);
        this.items.removeElementAt(n);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n = this.list.getSelectedIndex();
        if (command.equals(Commands.SELECT)) {
            this.savePos = n;
            MyMenuItem myMenuItem = (MyMenuItem)this.items.elementAt(n);
            if (myMenuItem != null) {
                myMenuItem.menuAction();
            }
        }
        if (command == Commands.BACK) {
            this.savePos = n;
            this.back.activate();
        }
        if (command == Commands.EXIT) {
            MyNotes.mynotes.destroyApp(false);
        }
    }

    public void activate() {
        this.list.setSelectedIndex(this.savePos);
        this.list.activate();
    }

    public Displayable getDisplayable() {
        return this.list;
    }
}

