/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import mynotes.CheckListEditor;
import mynotes.Commands;
import mynotes.Confirmation;
import mynotes.FileDescriptor;
import mynotes.FileProperties;
import mynotes.Find;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.TextEditor;
import mynotes.TextViewer;

public class NotesBrowser
implements CommandListener,
MyDisplayable {
    private static MyList list;
    public static Image noteIcon;
    public static Image dirIcon;
    public static Image checkListIcon;
    public Vector files;
    private Stack lastPos;
    private int savePos;
    private Stack dirNameLengths;
    private int currentDir;
    private final int ACTION_NOTHING;
    private final int ACTION_NEW_DIR;
    private final int ACTION_NEW_NOTE;
    private final int ACTION_NEW_CHECKLIST;
    private final int ACTION_RENAME;
    private final int ACTION_BACK;
    private final int ACTION_DELETE;
    private final int ACTION_EDIT;
    private final int ACTION_EDIT_CHECKLIST;
    private final int ACTION_PROPERTIES;
    private int lastAction;
    public TextEditor textEditor;
    private TextViewer textViewer;
    private CheckListEditor checkListEditor;
    private Confirmation alert;
    private Note note;
    private FileProperties properties;
    private final int NOTHING;
    private int idToCopy;
    private boolean cut;
    boolean isRealDirectory;

    public NotesBrowser() {
        this.ACTION_NOTHING = 0;
        this.ACTION_NEW_DIR = 1;
        this.ACTION_NEW_NOTE = 2;
        this.ACTION_NEW_CHECKLIST = 21;
        this.ACTION_RENAME = 3;
        this.ACTION_BACK = 4;
        this.ACTION_DELETE = 5;
        this.ACTION_EDIT = 6;
        this.ACTION_EDIT_CHECKLIST = 61;
        this.ACTION_PROPERTIES = 7;
        this.NOTHING = -1;
        try {
            noteIcon = Image.createImage((String)"/res/note.png");
            dirIcon = Image.createImage((String)"/res/folder.png");
            checkListIcon = Image.createImage((String)"/res/checklist.png");
        }
        catch (Exception exception) {
            noteIcon = null;
            dirIcon = null;
            checkListIcon = null;
            exception.printStackTrace();
        }
        list = new MyList("/");
        this.isRealDirectory = false;
        this.setRealDirectoryMode(true);
        this.files = new Vector();
        this.currentDir = 0;
        this.textEditor = new TextEditor();
        this.textViewer = new TextViewer();
        this.checkListEditor = new CheckListEditor();
        this.alert = new Confirmation();
        this.properties = new FileProperties();
        this.idToCopy = -1;
        this.cut = false;
        this.initBackStack();
    }

    public void initBackStack() {
        this.lastPos = new Stack();
        this.savePos = 0;
        this.dirNameLengths = new Stack();
        this.dirNameLengths.push(new Integer(0));
        list.setTitle("/");
    }

    public void setRealDirectoryMode(boolean bl) {
        list.deleteCommands();
        list.addCommand(Commands.SELECT, 8);
        list.addCommand(Commands.BACK, 5);
        if (bl) {
            list.addCommand(Commands.NEWNOTE, 2);
            list.addCommand(Commands.NEWCHECKLIST, 2);
            list.addCommand(Commands.NEWDIR, 2);
            list.addCommand(Commands.CUT, 2);
            list.addCommand(Commands.COPY, 2);
            list.addCommand(Commands.PASTE, 2);
            list.addCommand(Commands.DELETE, 2);
            list.addCommand(Commands.RENAME, 2);
            list.addCommand(Commands.PROPERTIES, 2);
            this.isRealDirectory = true;
        }
        if (!bl) {
            this.isRealDirectory = false;
        }
        list.updateMenuWidth();
        list.setCommandListener(this);
    }

    public void showDir(int n, int n2) {
        this.setRealDirectoryMode(true);
        this.currentDir = n;
        this.files.removeAllElements();
        this.files = MyNotes.fs.getDirectoryListing(n, 0);
        list.deleteAll();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            if (fileDescriptor.isDirectory) {
                list.append(fileDescriptor.name, dirIcon);
                continue;
            }
            if ((fileDescriptor.type & 0x100) == 0) {
                list.append(fileDescriptor.name, noteIcon);
                continue;
            }
            list.append(fileDescriptor.name, checkListIcon);
        }
        if (n2 < list.size() && n2 >= 0) {
            NotesBrowser.list.topItem = 0;
            list.setSelectedIndex(n2);
        }
    }

    public void showSearchResults(String string, boolean bl, boolean bl2) {
        this.setRealDirectoryMode(false);
        this.files.removeAllElements();
        this.files = bl ? MyNotes.fs.getListingByContent(string, bl2) : MyNotes.fs.getListingByName(string, bl2);
        list.setTitle(ResourceBundle.getString("nb-found") + " " + this.files.size());
        list.deleteAll();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            if ((fileDescriptor.type & 0x100) == 0) {
                list.append(fileDescriptor.name, noteIcon);
                continue;
            }
            list.append(fileDescriptor.name, checkListIcon);
        }
        list.setSelectedIndex(0);
        Find.gauge = null;
        this.activate();
    }

    public void savePos() {
        this.savePos = list.getSelectedIndex();
    }

    public int locate(int n) {
        int n2 = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            if (fileDescriptor.id != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void activate() {
        int n;
        int n2 = -1;
        int n3 = 0;
        boolean bl = this.files.size() == 0;
        int n4 = 0;
        FileDescriptor fileDescriptor = null;
        if (!bl) {
            n4 = list.getSelectedIndex();
            fileDescriptor = (FileDescriptor)this.files.elementAt(n4);
        }
        if ((n = this.textEditor.getStatus()) == 0) {
            n3 = this.savePos;
        }
        if (n == 1) {
            String string = this.textEditor.getText();
            switch (this.lastAction) {
                case 6: {
                    this.note.text = string;
                    MyNotes.fs.setNote(this.note.id, this.note);
                    n3 = this.savePos;
                    break;
                }
                case 61: {
                    n3 = this.savePos;
                    break;
                }
                case 1: {
                    n2 = MyNotes.fs.makeDir(string, this.currentDir);
                    break;
                }
                case 2: {
                    n2 = MyNotes.fs.makeNote(string, this.currentDir, 17);
                    break;
                }
                case 21: {
                    n2 = MyNotes.fs.makeNote(string, this.currentDir, 273);
                    break;
                }
                case 3: {
                    if (n4 == 0 && fileDescriptor.name.equals("..") && fileDescriptor.parentDirId != -1) break;
                    MyNotes.fs.rename(fileDescriptor.id, string);
                    n2 = fileDescriptor.id;
                    break;
                }
            }
        }
        if (this.lastAction == 5) {
            int n5 = this.alert.getStatus();
            if (n5 == 1) {
                MyNotes.fs.delete(fileDescriptor.id);
                int n6 = n4;
                if (n4 == list.size() - 1) {
                    --n6;
                }
                n3 = n6;
            } else if (n5 == 2) {
                n3 = this.savePos;
            }
        }
        if (this.lastAction == 4 || this.lastAction == 7) {
            n3 = this.savePos;
        }
        this.lastAction = 0;
        if (this.isRealDirectory) {
            this.showDir(this.currentDir, 0);
        }
        if (n2 != -1) {
            n3 = this.locate(n2);
        }
        if (list.size() != 0) {
            if (n3 < list.size() && n3 >= 0) {
                list.setSelectedIndex(n3);
            } else {
                list.setSelectedIndex(0);
            }
        }
        list.activate();
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        int n2;
        Object object;
        boolean bl = this.files.size() == 0;
        int n3 = 0;
        FileDescriptor fileDescriptor = null;
        if (!bl) {
            n3 = list.getSelectedIndex();
            fileDescriptor = (FileDescriptor)this.files.elementAt(n3);
        }
        if (command == Commands.SELECT) {
            if (bl) {
                return;
            }
            object = list.getTitle();
            if (fileDescriptor.isDirectory) {
                if (fileDescriptor.name.equals("..") && n3 == 0) {
                    n2 = (Integer)this.dirNameLengths.pop();
                    list.setTitle(((String)object).substring(0, ((String)object).length() - n2 - 1));
                    n = (Integer)this.lastPos.pop();
                    this.showDir(fileDescriptor.parentDirId, n);
                } else {
                    this.lastPos.push(new Integer(n3));
                    list.setTitle(((String)object).concat(fileDescriptor.name).concat("/"));
                    this.dirNameLengths.push(new Integer(fileDescriptor.name.length()));
                    this.showDir(fileDescriptor.id, 0);
                }
            } else if ((fileDescriptor.type & 0x100) == 0) {
                this.note = MyNotes.fs.getNote(fileDescriptor.id);
                if (this.note != null) {
                    this.savePos = n3;
                    this.lastAction = 6;
                    if (this.note.text.length() == 0) {
                        this.textEditor.start(2, fileDescriptor.name, this.note.text, this, this.textViewer);
                    } else {
                        this.textViewer.start(fileDescriptor.name, this.note.text, this, this.textEditor);
                    }
                }
            } else {
                this.savePos = n3;
                this.lastAction = 61;
                this.checkListEditor.start(fileDescriptor, this);
            }
        }
        if (command == Commands.NEWDIR) {
            this.lastAction = 1;
            this.textEditor.start(1, ResourceBundle.getString("nb-dirname"), "", this, null);
        }
        if (command == Commands.NEWNOTE) {
            this.lastAction = 2;
            this.textEditor.start(1, ResourceBundle.getString("nb-notename"), "", this, null);
        }
        if (command == Commands.NEWCHECKLIST) {
            this.lastAction = 21;
            this.textEditor.start(1, ResourceBundle.getString("nb-checkname"), "", this, null);
        }
        if (command == Commands.RENAME) {
            if (bl) {
                return;
            }
            this.lastAction = 3;
            this.textEditor.start(1, ResourceBundle.getString("nb-newname"), fileDescriptor.name, this, null);
        }
        if (command == Commands.DELETE) {
            if (bl) {
                return;
            }
            if (fileDescriptor.name.equals("..")) {
                return;
            }
            this.savePos = n3;
            this.lastAction = 5;
            this.alert.startAlert("MyNotes", ResourceBundle.getString("nb-delconfirm"), null, AlertType.CONFIRMATION);
        }
        if (command == Commands.PROPERTIES) {
            if (bl) {
                return;
            }
            if (fileDescriptor.name.equals("..")) {
                return;
            }
            this.savePos = n3;
            this.lastAction = 7;
            this.properties.prepare(fileDescriptor);
            this.properties.activate();
        }
        if (command == Commands.COPY) {
            if (bl) {
                return;
            }
            if (fileDescriptor.name.equals("..")) {
                return;
            }
            this.idToCopy = fileDescriptor.id;
            this.cut = false;
        }
        if (command == Commands.CUT) {
            if (bl) {
                return;
            }
            if (fileDescriptor.name.equals("..")) {
                return;
            }
            this.idToCopy = fileDescriptor.id;
            this.cut = true;
        }
        if (command == Commands.PASTE) {
            if (this.idToCopy == -1) {
                return;
            }
            object = MyNotes.fs.getDescriptorById(this.idToCopy);
            if (((FileDescriptor)object).parentDirId == this.currentDir && this.cut) {
                this.idToCopy = -1;
            } else {
                n2 = MyNotes.fs.makeCopy(this.idToCopy, this.currentDir, this.cut);
                this.showDir(this.currentDir, list.getSelectedIndex());
                list.setSelectedIndex(this.locate(n2));
            }
            if (this.cut) {
                this.idToCopy = -1;
                this.cut = false;
            }
        }
        if (command == Commands.BACK) {
            if (this.isRealDirectory) {
                if (this.currentDir == 0) {
                    MyNotes.menu.activate();
                    return;
                }
                int n4 = (Integer)this.dirNameLengths.pop();
                String string = list.getTitle();
                list.setTitle(string.substring(0, string.length() - n4 - 1));
                n = (Integer)this.lastPos.pop();
                FileDescriptor fileDescriptor2 = MyNotes.fs.getDescriptorById(this.currentDir);
                this.showDir(fileDescriptor2.parentDirId, n);
            } else {
                MyNotes.find.activate();
            }
        }
    }
}

