/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

class Property {
    public static final int PT_NOTHING = -1;
    public static final int PT_BYTE = 1;
    public static final int PT_SHORT = 2;
    public static final int PT_INT = 3;
    public static final int PT_LONG = 4;
    public static final int PT_CHAR = 5;
    public static final int PT_FLOAT = 6;
    public static final int PT_DOUBLE = 7;
    public static final int PT_BOOLEAN = 8;
    public static final int PT_STRING = 9;
    String key = null;
    Object value = null;
    int type = -1;
    protected int rsId;

    public boolean fromByteArray(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.type = dataInputStream.readInt();
            this.key = dataInputStream.readUTF();
            switch (this.type) {
                case 1: {
                    this.value = new Byte(dataInputStream.readByte());
                    break;
                }
                case 2: {
                    this.value = new Short(dataInputStream.readShort());
                    break;
                }
                case 3: {
                    this.value = new Integer(dataInputStream.readInt());
                    break;
                }
                case 4: {
                    this.value = new Long(dataInputStream.readLong());
                    break;
                }
                case 5: {
                    this.value = new Character(dataInputStream.readChar());
                    break;
                }
                case 6: {
                    this.value = new Float(dataInputStream.readFloat());
                    break;
                }
                case 7: {
                    this.value = new Double(dataInputStream.readDouble());
                    break;
                }
                case 8: {
                    this.value = new Boolean(dataInputStream.readBoolean());
                    break;
                }
                case 9: {
                    this.value = new String(dataInputStream.readUTF());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public byte[] toByteArray() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.type);
            dataOutputStream.writeUTF(this.key);
            switch (this.type) {
                case 1: {
                    dataOutputStream.writeByte((Integer)this.value);
                    break;
                }
                case 2: {
                    dataOutputStream.writeShort((Integer)this.value);
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt((Integer)this.value);
                    break;
                }
                case 4: {
                    dataOutputStream.writeLong(((Integer)this.value).intValue());
                    break;
                }
                case 5: {
                    dataOutputStream.writeChar((Integer)this.value);
                    break;
                }
                case 6: {
                    dataOutputStream.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    dataOutputStream.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    dataOutputStream.writeBoolean((Boolean)this.value);
                    break;
                }
                case 9: {
                    dataOutputStream.writeUTF((String)this.value);
                }
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }
}

