/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import mynotes.MyNotes;

public class ResourceBundle {
    private static RecordStore rs = null;
    public static String[] langCodes;
    public static String[] langNames;
    private static Hashtable resources;
    private static final String DEFAULT_LANG = "en";
    private static String currLangCode;
    private static String currLangName;

    public static void init() {
        try {
            InputStream inputStream = new Object().getClass().getResourceAsStream("/lang/langlist.lng");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readShort();
            langCodes = new String[n];
            langNames = new String[n];
            for (int i = 0; i < n; ++i) {
                ResourceBundle.langCodes[i] = dataInputStream.readUTF();
                ResourceBundle.langNames[i] = dataInputStream.readUTF();
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        currLangCode = ResourceBundle.getPreferredLang();
        ResourceBundle.setCurrLang(currLangCode);
    }

    public static String getCurrLangCode() {
        return currLangCode;
    }

    public static String getCurrLangName() {
        return currLangName;
    }

    public static void setCurrLang(String string) {
        for (int i = 0; i < langCodes.length; ++i) {
            if (!langCodes[i].equals(string)) continue;
            currLangCode = string;
            currLangName = langNames[i];
            return;
        }
    }

    private static void loadLang() {
        try {
            resources = new Hashtable();
            InputStream inputStream = resources.getClass().getResourceAsStream("/lang/" + currLangCode + ".lng");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readShort();
            for (int i = 0; i < n; ++i) {
                resources.put(dataInputStream.readUTF(), dataInputStream.readUTF());
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized String getString(String string) {
        String string2;
        if (resources == null) {
            ResourceBundle.loadLang();
        }
        if ((string2 = (String)resources.get(string)) != null) {
            return string2;
        }
        return string;
    }

    public static String getPreferredLang() {
        String string = MyNotes.properties.getStringValue("lang");
        if (string == null) {
            string = DEFAULT_LANG;
            ResourceBundle.savePreferredLang(string);
        }
        return string;
    }

    public static void savePreferredLang(String string) {
        MyNotes.properties.addPair("lang", string, 9);
    }

    static {
        resources = null;
    }
}

