/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Category;
import JabpLite.JabpLite;
import JabpLite.NameId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class CategoryStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public CategoryStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.categoryHt;
        this.openCategoryStore();
        if (this.getNumCategories() == 0) {
            this.setUpCategories();
        }
    }

    void openCategoryStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"Categories", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs1");
        }
    }

    void closeCategoryStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs2");
        }
    }

    int getNumCategories() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs3");
            return 0;
        }
    }

    RecordEnumeration getCategories() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs6");
            return null;
        }
    }

    byte[] toByteArray(Category category) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(category.name);
            dataOutputStream.writeUTF(category.description);
            dataOutputStream.writeInt(category.open);
            dataOutputStream.writeInt(category.current);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    Category fromByteArray(byte[] byArray) {
        Category category = new Category();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            category.name = dataInputStream.readUTF();
            if (category.name.equals("")) {
                category.name = "(Blank)";
            }
            category.description = dataInputStream.readUTF();
            category.open = dataInputStream.readInt();
            category.current = dataInputStream.readInt();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " cs4a");
        }
        return category;
    }

    Category getCategory(int n) {
        Category category = new Category();
        try {
            byte[] byArray = this.rs.getRecord(n);
            category = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs4 record " + n);
        }
        category.id = n;
        return category;
    }

    Category getCategoryFromIndex(int n) {
        short s = (short)n;
        int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
        return this.getCategory(n2);
    }

    Category getCategoryFromName(String string) {
        int n = this.getNumCategories();
        for (int i = 0; i < n; ++i) {
            short s = (short)i;
            String string2 = ((NameId)this.ht.get((Object)new Short((short)s))).name;
            if (!string2.equals(string)) continue;
            int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
            return this.getCategory(n2);
        }
        Category category = new Category();
        category.name = string;
        category.id = this.saveNewCategory(category);
        if (this.parent.cv != null) {
            ++this.parent.cv.numItems;
        }
        return category;
    }

    void deleteCategory(Category category) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(category.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs5");
        }
    }

    int saveNewCategory(Category category) {
        if (this.rs == null) {
            return 0;
        }
        try {
            category.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(category);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs7");
        }
        this.addIndex(category);
        return category.id;
    }

    void saveExistingCategory(Category category) {
        if (this.rs == null) {
            return;
        }
        if (category.id == 0) {
            System.out.println("Id error in saveExistingCategory()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(category);
            this.rs.setRecord(category.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs7a");
        }
    }

    int lookUpId(Category category) {
        category.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(category.name)) continue;
            category.id = ((NameId)this.ht.get((Object)s)).id;
            break;
        }
        return category.id;
    }

    int lookUpIndex(Category category) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(category.name)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            NameId nameId = (NameId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), nameId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void deleteAllIndices() {
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            this.ht.remove(new Short((short)i));
        }
    }

    void addIndex(Category category) {
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        for (n = 0; n < n2; ++n) {
            NameId nameId = (NameId)this.ht.get(new Short((short)n));
            if (category.name.compareTo(nameId.name) >= 0) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                NameId nameId = (NameId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), nameId);
            }
        }
        NameId nameId = new NameId(category.name, category.id);
        this.ht.put(new Short((short)n3), nameId);
    }

    void setUpCategories() {
        Category category = new Category();
        category.name = "Bills";
        this.saveNewCategory(category);
        category.name = "Car Expenses";
        this.saveNewCategory(category);
        category.name = "Entertainment";
        this.saveNewCategory(category);
        category.name = "Food";
        this.saveNewCategory(category);
        category.name = "Gifts";
        this.saveNewCategory(category);
        category.name = "Holiday Expenses";
        this.saveNewCategory(category);
        category.name = "Household";
        this.saveNewCategory(category);
        category.name = "Insurance";
        this.saveNewCategory(category);
        category.name = "Mortgage";
        this.saveNewCategory(category);
        category.name = "Salary";
        this.saveNewCategory(category);
        category.name = "Travel";
        this.saveNewCategory(category);
    }

    void compressCategories() {
        try {
            byte[] byArray;
            this.parent.categoryHt = new Hashtable();
            this.ht = this.parent.categoryHt;
            RecordStore recordStore = RecordStore.openRecordStore((String)"Temp", (boolean)true);
            RecordEnumeration recordEnumeration = this.getCategories();
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.closeCategoryStore();
            RecordStore.deleteRecordStore((String)"Categories");
            this.openCategoryStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                Category category = this.fromByteArray(byArray);
                category.id = this.rs.addRecord(byArray, 0, byArray.length);
                this.addIndex(category);
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"Temp");
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs8");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs9");
            return 0;
        }
    }

    int getRecordSize(int n) {
        try {
            return this.rs.getRecordSize(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cs10");
            return 0;
        }
    }
}

