/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.JabpLite;
import JabpLite.Split;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class PurgeForm
extends Form {
    Transaction t;
    AccountStore as;
    CategoryStore cs;
    TransactionStore ts;
    JabpLite parent;
    ChoiceGroup cgReconciled;
    DateField df1;
    DateField df2;

    public PurgeForm(JabpLite jabpLite) {
        super("Purge Data");
        this.parent = jabpLite;
        this.df1 = new DateField("From date", 1);
        this.df2 = new DateField("To date", 1);
        this.parent.genericDate.setTime(0L);
        this.df1.setDate(this.parent.genericDate);
        this.df2.setDate(this.parent.todayDate);
        this.append((Item)this.df1);
        this.append((Item)this.df2);
        int n = 4;
        if (this.parent.oldStyleChoice) {
            n = 1;
        }
        this.cgReconciled = new ChoiceGroup("Purge Reconciled only", n);
        this.cgReconciled.append("No", null);
        this.cgReconciled.append("Yes (recommended)", null);
        this.cgReconciled.setSelectedIndex(1, true);
        this.append((Item)this.cgReconciled);
        this.append("\nAll transactions between these dates will be purged");
    }

    void processPurge() {
        Date date = this.df1.getDate();
        Date date2 = this.df2.getDate();
        long l = Utilities.longToDays(date.getTime());
        long l2 = Utilities.longToDays(date2.getTime());
        int n = this.cgReconciled.getSelectedIndex();
        this.as = new AccountStore(this.parent);
        this.cs = new CategoryStore(this.parent);
        RecordEnumeration recordEnumeration = this.as.getAccounts();
        int n2 = 0;
        int n3 = 0;
        while (recordEnumeration.hasNextElement()) {
            int n4;
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " puf1");
            }
            Account account = this.as.getAccount(n2);
            TransactionStore transactionStore = new TransactionStore(this.parent, account);
            int n5 = -1;
            while (++n5 < (n4 = transactionStore.getNumTransactions())) {
                long l3;
                Transaction transaction = transactionStore.getTransactionFromIndex(n5);
                if (++n3 == n3 / 100 * 100) {
                    this.parent.av.show(n3 + " transactions read...", true);
                }
                if ((l3 = Utilities.longToDays(transaction.longDate)) < l || l3 > l2 || n != 0 && (n != 1 || !transaction.reconciled)) continue;
                this.updateOpenBalances(transaction, account);
                transactionStore.deleteTransaction(transaction);
                transactionStore.deleteIndex(n5);
                --n5;
            }
            transactionStore.closeTransactionStore();
            transactionStore = null;
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        this.cs.closeCategoryStore();
        this.cs = null;
        this.as.closeAccountStore();
        this.as = null;
    }

    void updateOpenBalances(Transaction transaction, Account account) {
        account.open += transaction.amount;
        this.as.saveExistingAccount(account);
        if (!transaction.transferFlag) {
            if (transaction.splitFlag) {
                for (int i = 0; i < transaction.ss.size(); ++i) {
                    Split split = transaction.ss.getSplit(i);
                    Category category = this.cs.getCategoryFromName(split.category);
                    category.current += split.amount;
                    this.cs.saveExistingCategory(category);
                }
            } else {
                Category category = this.cs.getCategoryFromName(transaction.category);
                category.current += transaction.amount;
                this.cs.saveExistingCategory(category);
            }
        }
    }
}

