/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.Investment;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class InvestmentForm
extends Form {
    Investment inv;
    JabpLite parent;
    DateField df;
    ChoiceGroup cgCurrency;
    TextField tfName;
    TextField tfDescription;
    TextField tfHolding;
    TextField tfPrice;

    public InvestmentForm(JabpLite jabpLite, Investment investment, String string, boolean bl) {
        super(string + " Investment");
        this.parent = jabpLite;
        this.inv = investment;
        if (string.equals("Show") || string.equals("Delete")) {
            this.append("Name: " + this.inv.name + "\n");
            this.append("Desc: " + this.inv.description + "\n");
            this.append("Holding: " + Utilities.decimalToString(this.inv.holding, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces) + "\n");
            this.append("Price: " + Utilities.decimalToString(this.inv.price, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces) + "\n");
            this.append("Value: " + Utilities.numberToString(this.inv.calcValue(this.inv), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "\n");
            this.append("Date: " + this.showDate(this.inv.priceLongDate) + "\n");
            this.append("Currency: " + this.inv.currency + "\n");
            return;
        }
        String string2 = "";
        if (bl) {
            this.append("New price for " + this.inv.name + "\n");
        } else {
            this.tfName = new TextField("Name", this.inv.name, 30, 0);
            this.append((Item)this.tfName);
            this.tfDescription = new TextField("Description", this.inv.description, 64, 0);
            this.append((Item)this.tfDescription);
            if (this.parent.holdingDecimalPlaces == 0) {
                this.append("Enter holding as an integer quantity\n");
            } else {
                this.append("Enter holding with " + this.parent.holdingDecimalPlaces + " decimal places, no period\n");
            }
            this.tfHolding = new TextField("Holding", "", 20, 2);
            if (this.inv.holding != 0) {
                string2 = Utilities.holdingToString(Math.abs(this.inv.holding), this.parent.isEuropeanNumberFormat, false);
            }
            this.tfHolding.setString(string2);
            this.append((Item)this.tfHolding);
        }
        this.append("Enter price with " + this.parent.priceDecimalPlaces + " decimal places, no period\n");
        this.tfPrice = new TextField("Price", "", 20, 2);
        string2 = "";
        if (this.inv.price != 0) {
            string2 = Utilities.numberToString(Math.abs(this.inv.price), true, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfPrice.setString(string2);
        this.append((Item)this.tfPrice);
        this.df = new DateField("Date", 1);
        if (string.equals("New") || string.equals("Price")) {
            this.inv.priceLongDate = this.parent.todayDate.getTime();
        }
        this.df.setDate(new Date(this.inv.priceLongDate + 3600000L));
        this.append((Item)this.df);
        if (bl) {
            this.append("Currency is " + this.inv.currency);
        } else {
            int n = 4;
            if (this.parent.oldStyleChoice) {
                n = 1;
            }
            this.cgCurrency = new ChoiceGroup("Currency", n);
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            int n2 = currencyStore.getNumCurrencies();
            for (int i = 0; i < n2; ++i) {
                Currency currency = currencyStore.getCurrencyFromIndex(i);
                this.cgCurrency.append(currency.code, null);
                if (this.inv.currency.equals("")) {
                    if (!currency.code.equals(this.parent.homeCurrency)) continue;
                    this.cgCurrency.setSelectedIndex(i, true);
                    continue;
                }
                if (!currency.code.equals(this.inv.currency)) continue;
                this.cgCurrency.setSelectedIndex(i, true);
            }
            this.append((Item)this.cgCurrency);
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
    }

    Investment update() {
        this.inv.name = this.tfName.getString();
        this.inv.description = this.tfDescription.getString();
        int n = this.inv.holding;
        this.inv.holding = Utilities.holdingToNumber(this.tfHolding.getString(), n);
        n = this.inv.price;
        this.inv.price = Utilities.stringToNumber(this.tfPrice.getString(), n, true, this.parent.isEuropeanNumberFormat);
        this.inv.priceLongDate = this.df.getDate().getTime();
        this.inv.currency = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex());
        return this.inv;
    }

    Investment updatePrice() {
        int n = this.inv.price;
        this.inv.price = Utilities.stringToNumber(this.tfPrice.getString(), n, true, this.parent.isEuropeanNumberFormat);
        this.inv.priceLongDate = this.df.getDate().getTime();
        return this.inv;
    }

    String showDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }
}

