/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.CategoryView;
import JabpLite.CurrencyView;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.LongId;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderForm;
import JabpLite.StandingOrderStore;
import JabpLite.TransferForm;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;

public class StandingOrderView
extends Canvas
implements CommandListener,
Runnable {
    StandingOrder so;
    StandingOrder so1;
    StandingOrder oldSO;
    StandingOrderForm sof;
    StandingOrderForm sof3;
    TransferForm trf;
    Form debug;
    Form f3;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    StandingOrderStore sos;
    Alert alert;
    DateField df;
    Display display;
    Font font;
    JabpLite parent;
    ViewForm vl;
    String msg = "";
    String oldName = "";
    boolean paintWholeScreen = true;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int spacing;
    int amountPosition;
    int accountWidth;
    int numberWidth;
    int categoryPosition;
    int accountPosition;
    int categoryWidth;
    int dateWidth;
    int descriptionPosition;
    int descriptionWidth;
    int minDescriptionWidth;
    int currencyRate;
    int runMode;
    long timePointerOnScreen;
    boolean pointerExecute;

    public StandingOrderView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.processNowCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.sos = new StandingOrderStore(this.parent);
        this.numItems = this.sos.getNumStandingOrders();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.runMode = 1;
        if (this.parent.createFormsInBackground) {
            this.runThread();
        }
        this.runMode = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    void runThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        } else {
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.so = this.sos.getStandingOrderFromIndex(i + this.startPos);
            this.buildLine(graphics, this.so, this.lineHeight * i + this.lineHeight);
        }
        this.so = this.sos.getStandingOrderFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.so = this.sos.getStandingOrderFromIndex(this.previousPos + this.startPos);
        this.buildLine(graphics, this.so, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.so = this.sos.getStandingOrderFromIndex(this.currentPos + this.startPos);
        this.buildLine(graphics, this.so, this.lineHeight * this.currentPos + this.lineHeight);
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            graphics.drawString("StandingOrders", this.parent.widthAdjustment, n, 20);
        } else {
            graphics.setColor(this.parent.colorMessage);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            graphics.drawString(this.msg, this.parent.widthAdjustment, n, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void buildLine(Graphics graphics, StandingOrder standingOrder, int n) {
        int n2;
        int n3;
        int n4 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.drawString(this.setPageDate(standingOrder.longProcessingDate), this.parent.widthAdjustment, n4, 20);
        int n5 = standingOrder.description.length();
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n5 - n3;
            if (this.font.stringWidth(standingOrder.description.substring(0, n2)) > this.descriptionWidth) continue;
            graphics.drawString(standingOrder.description.substring(0, n2), this.descriptionPosition, n4, 20);
            break;
        }
        if (this.categoryWidth > 0) {
            String string = standingOrder.category;
            if (standingOrder.transferFlag) {
                string = "[Transfer]";
            }
            n5 = string.length();
            for (n2 = 0; n2 < n5; ++n2) {
                int n6 = n5 - n2;
                if (this.font.stringWidth(string.substring(0, n6)) > this.categoryWidth) continue;
                graphics.drawString(string.substring(0, n6), this.categoryPosition, n4, 20);
                break;
            }
        }
        if (this.accountWidth > 0) {
            n5 = standingOrder.account.length();
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n5 - n3;
                if (this.font.stringWidth(standingOrder.account.substring(0, n2)) > this.accountWidth) continue;
                graphics.drawString(standingOrder.account.substring(0, n2), this.accountPosition, n4, 20);
                break;
            }
        }
        String string = Utilities.numberToString(standingOrder.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n4, 20);
    }

    String setPageDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 0) {
            return string + "/" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.dateWidth = this.font.stringWidth("99/99");
        if (this.parent.dateFormat > 1) {
            this.dateWidth = this.font.stringWidth("99/99/99");
        }
        this.numberWidth = this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99");
        this.minDescriptionWidth = this.font.stringWidth("Description");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = 10;
        this.accountWidth = 100;
        this.categoryWidth = 100;
        if (this.width > 500) {
            this.spacing = 20;
        }
        if (this.width > 640) {
            this.spacing = 30;
        }
        this.descriptionWidth = this.width - this.parent.widthAdjustment * 2 - this.dateWidth - this.numberWidth - this.categoryWidth - this.accountWidth - this.spacing * 4;
        if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
            this.descriptionWidth += this.categoryWidth + this.spacing;
            this.categoryWidth = 0;
        }
        if (this.descriptionWidth < this.minDescriptionWidth || this.accountWidth == 0) {
            this.descriptionWidth += this.accountWidth + this.spacing;
            this.accountWidth = 0;
        }
        this.descriptionPosition = this.parent.widthAdjustment + this.dateWidth + this.spacing;
        this.categoryPosition = this.descriptionPosition + this.descriptionWidth + this.spacing;
        this.accountPosition = this.categoryWidth > 0 ? this.categoryPosition + this.categoryWidth + this.spacing : this.categoryPosition;
        this.amountPosition = this.accountWidth > 0 ? this.accountPosition + this.accountWidth + this.spacing : this.accountPosition;
    }

    StandingOrder showStandingOrder() {
        this.oldSO = new StandingOrder();
        this.oldSO.clone(this.so);
        return this.so;
    }

    int newStandingOrder(StandingOrder standingOrder) {
        this.so1 = standingOrder;
        this.so1.id = this.sos.saveNewStandingOrder(this.so1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.so1), 6);
        }
        if (this.so == null) {
            this.so = this.so1;
        }
        ++this.numItems;
        this.repaint();
        return this.so1.id;
    }

    void editStandingOrder(StandingOrder standingOrder) {
        this.so1 = standingOrder;
        this.sos.saveExistingStandingOrder(this.so1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.oldSO), -6);
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.so1), 6);
        }
        if (Utilities.longToDays(this.so1.longProcessingDate) != Utilities.longToDays(this.oldSO.longProcessingDate)) {
            this.sos.deleteIndex(this.startPos + this.currentPos);
            this.sos.addIndex(this.so1);
        }
        this.oldY = this.currentY;
        this.repaint();
    }

    void deleteStandingOrder(StandingOrder standingOrder) {
        this.so1 = standingOrder;
        this.sos.deleteStandingOrder(this.so1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.so1), -6);
        }
        this.sos.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            this.displayTouchScreenMenu();
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("Record Properties");
            this.debug.append("Position " + n2 + " of " + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((LongId)this.sos.ht.get((Object)new Short((short)s))).id;
            this.debug.append("Record ID " + n3 + "\n");
            this.debug.append("Record length " + this.sos.getRecordSize(n3) + "\n");
            this.debug.append("RecordStore size " + this.sos.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        this.pointerExecute = true;
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.paintWholeScreen = false;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Standing Order Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("New", null);
        this.cgtsm.append("Edit", null);
        this.cgtsm.append("Delete", null);
        this.cgtsm.append("Show", null);
        this.cgtsm.append("Process Now", null);
        this.cgtsm.append("Main", null);
        this.cgtsm.append("Switch Views", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    void removeAllCommands() {
        this.sof.removeCommand(this.parent.createCommand);
        this.sof.removeCommand(this.parent.updateCommand);
        this.sof.removeCommand(this.parent.deleteCommand);
        this.sof.removeCommand(this.parent.cancelCommand);
    }

    void checkForm() {
        if (this.parent.isAndroid) {
            this.sof = null;
            return;
        }
        if (this.parent.reuseForm) {
            return;
        }
        this.runMode = 1;
        if (this.parent.createFormsInBackground) {
            this.runThread();
        } else {
            this.run();
        }
    }

    void show(String string) {
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 0) {
            this.androidDelay();
        }
        if (this.runMode == 1) {
            this.show("Creating form in background...");
            this.sof = new StandingOrderForm(this.parent);
            this.sof.build();
            this.sof.setCommandListener(this);
            this.show("");
        }
        if (this.runMode == 2) {
            if (!this.sos.processStandingOrders(this.df.getDate().getTime())) {
                this.alert.setTimeout(-2);
                this.alert.setString(this.parent.outOfSpaceMessage());
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            this.numItems = this.sos.getNumStandingOrders();
            this.runMode = 1;
            this.display.setCurrent((Displayable)this);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.runMode = 1;
                if (this.sof == null) {
                    this.run();
                }
                if (!this.sof.ready) {
                    this.display.setCurrent((Displayable)this.sof);
                }
                StandingOrder standingOrder = new StandingOrder();
                this.removeAllCommands();
                this.sof.addCommand(this.parent.createCommand);
                this.sof.addCommand(this.parent.cancelCommand);
                this.sof.addCommand(this.parent.exitCommand);
                this.sof.set(standingOrder, "New");
                this.display.setCurrent((Displayable)this.sof);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No standing orders set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.runMode = 1;
                if (this.sof == null) {
                    this.run();
                }
                if (!this.sof.ready) {
                    this.display.setCurrent((Displayable)this.sof);
                }
                this.removeAllCommands();
                this.sof.addCommand(this.parent.updateCommand);
                this.sof.addCommand(this.parent.cancelCommand);
                this.sof.addCommand(this.parent.exitCommand);
                this.sof.set(this.showStandingOrder(), "Edit");
                this.display.setCurrent((Displayable)this.sof);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No standing orders set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.sof3 = new StandingOrderForm(this.parent);
                this.sof3.show(this.so, "Delete");
                this.sof3.addCommand(this.parent.deleteCommand);
                this.sof3.addCommand(this.parent.cancelCommand);
                this.sof3.addCommand(this.parent.exitCommand);
                this.sof3.setCommandListener(this);
                this.display.setCurrent((Displayable)this.sof3);
            }
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No standing orders set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.sof3 = new StandingOrderForm(this.parent);
                this.sof3.show(this.so, "Show");
                this.sof3.addCommand(this.parent.okCommand);
                this.sof3.addCommand(this.parent.exitCommand);
                this.sof3.setCommandListener(this);
                this.display.setCurrent((Displayable)this.sof3);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.processNowCommand) {
                this.f3 = new Form("Process Now");
                this.df = new DateField("Process up to date", 1);
                this.df.setDate(this.parent.todayDate);
                this.f3.append((Item)this.df);
                this.f3.addCommand(this.parent.okCommand);
                this.f3.addCommand(this.parent.cancelCommand);
                this.f3.addCommand(this.parent.exitCommand);
                this.f3.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.f3);
            }
        }
        if (displayable == this.sof) {
            if (command == this.parent.createCommand) {
                this.so1 = this.sof.update();
                if (this.so1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (this.sos.getStandingOrderFromName(this.so1.description) != null) {
                    this.alert.setString(this.so1.description + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (this.so1.transferFlag) {
                    this.trf = new TransferForm(this.parent, null, this.so1, null, "Transfer");
                    this.trf.addCommand(this.parent.okCommand);
                    this.trf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.trf);
                    return;
                }
                this.newStandingOrder(this.so1);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.updateCommand) {
                this.so1 = this.sof.update();
                if (this.so1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (!this.so1.description.equals(this.oldSO.description) && this.sos.getStandingOrderFromName(this.so1.description) != null) {
                    this.alert.setString(this.so1.description + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (!this.oldSO.transferFlag && this.so1.transferFlag) {
                    this.alert.setString("Cannot change to transfer - delete then re-enter");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                if (this.oldSO.transferFlag && !this.so1.transferFlag) {
                    this.alert.setString("Cannot change from transfer - delete then re-enter");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    return;
                }
                this.editStandingOrder(this.so1);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.cancelCommand) {
                this.checkForm();
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.sof3) {
            if (command == this.parent.okCommand) {
                this.sof3 = null;
                this.display.setCurrent((Displayable)this);
                return;
            }
            if (command == this.parent.deleteCommand) {
                this.deleteStandingOrder(this.so);
                this.sof3 = null;
                this.display.setCurrent((Displayable)this);
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.sof3 = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.trf && command == this.parent.okCommand) {
            this.so1 = this.trf.updateTransferSO();
            if (this.so1.account.equals(this.so1.transferAccount)) {
                this.alert.setString("Choose another account");
                this.display.setCurrent(this.alert, (Displayable)this.sof);
                return;
            }
            this.newStandingOrder(this.so1);
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.vl = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("No account selected");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.f3) {
            if (command == this.parent.okCommand) {
                this.parent.f3 = new List("Process Now", 3);
                this.parent.f3.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.parent.f3);
                this.runMode = 2;
                this.runThread();
            }
            if (command == this.parent.cancelCommand) {
                this.f3 = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.newCommand, (Displayable)this);
                }
                if (n == 1) {
                    this.commandAction(this.parent.editCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.commandAction(this.parent.deleteCommand, (Displayable)this);
                }
                if (n == 3) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n == 4) {
                    this.commandAction(this.parent.processNowCommand, (Displayable)this);
                }
                if (n == 5) {
                    this.commandAction(this.parent.mainCommand, (Displayable)this);
                }
                if (n == 6) {
                    this.commandAction(this.parent.viewCommand, (Displayable)this);
                }
                if (n == 7) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

