/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.JabpLite;
import JabpLite.LongId;
import JabpLite.NameId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class IndexStore {
    RecordStore rs;
    JabpLite parent;
    String name1;

    public IndexStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        try {
            this.rs = RecordStore.openRecordStore((String)"Indices", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in1");
        }
    }

    void closeIndexStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in2");
        }
    }

    void selfDestruct() {
        try {
            RecordStore.deleteRecordStore((String)"Indices");
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in4");
        }
    }

    int getNumIndices() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in3");
            return 0;
        }
    }

    byte[] ht1ToByteArray(Hashtable hashtable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                short s2 = s;
                dataOutputStream.writeShort(s2);
                NameId nameId = (NameId)hashtable.get(s);
                dataOutputStream.writeUTF(nameId.name);
                dataOutputStream.writeInt(nameId.id);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in8a");
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] ht2ToByteArray(Hashtable hashtable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                short s2 = s;
                dataOutputStream.writeShort(s2);
                LongId longId = (LongId)hashtable.get(s);
                dataOutputStream.writeLong(longId.lo);
                dataOutputStream.writeInt(longId.id);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in8b");
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] ht3ToByteArray(Hashtable hashtable, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                short s2 = s;
                dataOutputStream.writeShort(s2);
                LongId longId = (LongId)hashtable.get(s);
                dataOutputStream.writeLong(longId.lo);
                dataOutputStream.writeInt(longId.id);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in8c");
        }
        return byteArrayOutputStream.toByteArray();
    }

    Hashtable ht1FromByteArray(byte[] byArray) {
        Hashtable<Short, NameId> hashtable = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            hashtable = new Hashtable<Short, NameId>(n);
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                String string = dataInputStream.readUTF();
                int n2 = dataInputStream.readInt();
                hashtable.put(new Short(s), new NameId(string, n2));
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in9a");
        }
        return hashtable;
    }

    Hashtable ht2FromByteArray(byte[] byArray) {
        Hashtable<Short, LongId> hashtable = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            hashtable = new Hashtable<Short, LongId>(n);
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                long l = dataInputStream.readLong();
                int n2 = dataInputStream.readInt();
                hashtable.put(new Short(s), new LongId(l, n2));
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in9b");
        }
        return hashtable;
    }

    Hashtable ht3FromByteArray(byte[] byArray) {
        Hashtable<Short, LongId> hashtable = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.name1 = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            hashtable = new Hashtable<Short, LongId>(n);
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                long l = dataInputStream.readLong();
                int n2 = dataInputStream.readInt();
                hashtable.put(new Short(s), new LongId(l, n2));
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in9c");
        }
        return hashtable;
    }

    boolean getIndices1() {
        try {
            if (this.rs.getNumRecords() == 0) {
                return false;
            }
            byte[] byArray = this.rs.getRecord(1);
            this.parent.accountHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(2);
            this.parent.categoryHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(3);
            this.parent.currencyHt = this.ht1FromByteArray(byArray);
            return true;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in5a");
            return false;
        }
    }

    void getIndices2() {
        try {
            if (this.rs.getNumRecords() == 0) {
                return;
            }
            byte[] byArray = this.rs.getRecord(4);
            this.parent.standingOrderHt = this.ht2FromByteArray(byArray);
            byArray = this.rs.getRecord(5);
            this.parent.regularHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(6);
            this.parent.investmentHt = this.ht1FromByteArray(byArray);
            int n = this.parent.accountHt.size();
            for (int i = 0; i < n; ++i) {
                byArray = this.rs.getRecord(7 + i);
                short s = (short)i;
                String string = ((NameId)this.parent.accountHt.get((Object)new Short((short)s))).name;
                Hashtable hashtable = this.ht3FromByteArray(byArray);
                if (!string.equals(this.name1)) {
                    System.out.println("Name mismatch in getIndices()");
                }
                this.parent.transactionHt.put(this.name1, hashtable);
            }
            byArray = this.rs.getRecord(7 + n);
            this.parent.syncHt = this.ht2FromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in5b");
        }
    }

    void saveIndices() {
        if (this.rs == null) {
            return;
        }
        try {
            boolean bl = false;
            int n = this.rs.getNumRecords();
            if (n > 0) {
                bl = true;
            }
            if (bl) {
                byte[] byArray = this.ht1ToByteArray(this.parent.accountHt);
                this.rs.setRecord(1, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.categoryHt);
                this.rs.setRecord(2, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.currencyHt);
                this.rs.setRecord(3, byArray, 0, byArray.length);
                byArray = this.ht2ToByteArray(this.parent.standingOrderHt);
                this.rs.setRecord(4, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.regularHt);
                this.rs.setRecord(5, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.investmentHt);
                this.rs.setRecord(6, byArray, 0, byArray.length);
                int n2 = this.parent.accountHt.size();
                for (int i = 0; i < n2; ++i) {
                    short s = (short)i;
                    String string = ((NameId)this.parent.accountHt.get((Object)new Short((short)s))).name;
                    Hashtable hashtable = new Hashtable();
                    hashtable = (Hashtable)this.parent.transactionHt.get(string);
                    byArray = this.ht3ToByteArray(hashtable, string);
                    if (7 + i > n) {
                        this.rs.addRecord(byArray, 0, byArray.length);
                        continue;
                    }
                    this.rs.setRecord(7 + i, byArray, 0, byArray.length);
                }
                byArray = this.ht2ToByteArray(this.parent.syncHt);
                if (7 + n2 > n) {
                    this.rs.addRecord(byArray, 0, byArray.length);
                } else {
                    this.rs.setRecord(7 + n2, byArray, 0, byArray.length);
                }
            } else {
                byte[] byArray = this.ht1ToByteArray(this.parent.accountHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.categoryHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.currencyHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht2ToByteArray(this.parent.standingOrderHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.regularHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.investmentHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                int n3 = this.parent.accountHt.size();
                for (int i = 0; i < n3; ++i) {
                    short s = (short)i;
                    String string = ((NameId)this.parent.accountHt.get((Object)new Short((short)s))).name;
                    Hashtable hashtable = new Hashtable();
                    hashtable = (Hashtable)this.parent.transactionHt.get(string);
                    byArray = this.ht3ToByteArray(hashtable, string);
                    this.rs.addRecord(byArray, 0, byArray.length);
                }
                byArray = this.ht2ToByteArray(this.parent.syncHt);
                this.rs.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in7");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in9");
            return 0;
        }
    }
}

