/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.JabpLite;
import JabpLite.LongId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SyncStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public SyncStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.syncHt;
        this.openSyncStore();
    }

    void openSyncStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"JabpSync", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss1");
        }
    }

    void closeSyncStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss2");
        }
    }

    int getNumSyncRecords() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss5");
            return 0;
        }
    }

    RecordEnumeration getSyncRecords() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss3");
            return null;
        }
    }

    byte[] getSyncRecord(int n) {
        byte[] byArray = null;
        try {
            byArray = this.rs.getRecord(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss4 record " + n);
        }
        return byArray;
    }

    byte[] getSyncRecordFromIndex(int n) {
        short s = (short)n;
        int n2 = ((LongId)this.ht.get((Object)new Short((short)s))).id;
        return this.getSyncRecord(n2);
    }

    void deleteSyncRecordFromIndex(int n) {
        short s = (short)n;
        int n2 = ((LongId)this.ht.get((Object)new Short((short)s))).id;
        try {
            this.rs.deleteRecord(n2);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss5 record " + n2);
        }
    }

    void deleteSyncRecord(int n) {
        try {
            this.rs.deleteRecord(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss6 record " + n);
        }
    }

    long getTimeCreated(byte[] byArray) {
        long l = 0L;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            l = dataInputStream.readLong();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    void addIndex(long l, int n) {
        int n2;
        int n3;
        int n4 = n3 = this.ht.size();
        for (n2 = 0; n2 < n3; ++n2) {
            LongId longId = (LongId)this.ht.get(new Short((short)n2));
            if (l > longId.lo) continue;
            n4 = n2;
            break;
        }
        if (n4 < n3) {
            for (n2 = n3 - 1; n2 >= n4; --n2) {
                int n5 = n2 + 1;
                LongId longId = (LongId)this.ht.get(new Short((short)n2));
                this.ht.put(new Short((short)n5), longId);
            }
        }
        LongId longId = new LongId(l, n);
        this.ht.put(new Short((short)n4), longId);
    }

    void saveSyncRecord(byte[] byArray, int n) {
        long l = System.currentTimeMillis();
        int n2 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(byArray, 0, n2);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        try {
            int n3 = this.rs.getNextRecordID();
            this.rs.addRecord(byArray2, 0, byArray2.length);
            this.addIndex(l, n3);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ss3");
        }
    }
}

