/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.Investment;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class InvestmentForm
extends Form {
    Investment inv;
    JabpLite parent;
    DateField df;
    ChoiceGroup cgCurrency;
    TextField tfName;
    TextField tfDescription;
    TextField tfHolding;
    TextField tfPrice;

    public InvestmentForm(JabpLite jabpLite, Investment investment, String string, boolean bl) {
        super(string + "\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
        this.parent = jabpLite;
        this.inv = investment;
        if (string.equals("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c") || string.equals("\u0423\u0434\u0430\u043b\u0438\u0442\u044c")) {
            this.append("\u0418\u043c\u044f: " + this.inv.name + "\n");
            this.append("Desc: " + this.inv.description + "\n");
            this.append("\u0412\u043a\u043b\u0430\u0434\u044b: " + Utilities.decimalToString(this.inv.holding, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces) + "\n");
            this.append("\u0426\u0435\u043d\u0430: " + Utilities.decimalToString(this.inv.price, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces) + "\n");
            this.append("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c: " + Utilities.numberToString(this.inv.calcValue(this.inv), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "\n");
            this.append("\u0414\u0430\u0442\u0430: " + this.showDate(this.inv.priceLongDate) + "\n");
            this.append("\u0412\u0430\u043b\u044e\u0442\u0430: " + this.inv.currency + "\n");
            return;
        }
        String string2 = "";
        if (bl) {
            this.append("\u041d\u043e\u0432\u0430\u044f \u0446\u0435\u043d\u0430 \u0434\u043b\u044f " + this.inv.name + "\n");
        } else {
            this.tfName = new TextField("\u0418\u043c\u044f", this.inv.name, 30, 0);
            this.append((Item)this.tfName);
            this.tfDescription = new TextField("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", this.inv.description, 64, 0);
            this.append((Item)this.tfDescription);
            if (this.parent.holdingDecimalPlaces == 0) {
                this.append("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u043a\u043b\u0430\u0434\u044b \u043a\u0430\u043a \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e\n");
            } else {
                this.append("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u043a\u043b\u0430\u0434\u044b \u0441 " + this.parent.holdingDecimalPlaces + " \u0437\u043d\u0430\u043a\u0430 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043d\u044f\u0442\u043e\u0439, \u0431\u0435\u0437 \u043f\u0435\u0440\u0438\u043e\u0434\u0430\n");
            }
            this.tfHolding = new TextField("\u0412\u043a\u043b\u0430\u0434", "", 20, 2);
            if (this.inv.holding != 0) {
                string2 = Utilities.holdingToString(Math.abs(this.inv.holding), this.parent.isEuropeanNumberFormat, false);
            }
            this.tfHolding.setString(string2);
            this.append((Item)this.tfHolding);
        }
        this.append("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u0441 " + this.parent.priceDecimalPlaces + " \u0437\u043d\u0430\u043a\u0430 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043d\u044f\u0442\u043e\u0439, \u0431\u0435\u0437 \u043f\u0435\u0440\u0438\u043e\u0434\u0430\n");
        this.tfPrice = new TextField("\u0426\u0435\u043d\u0430", "", 20, 2);
        string2 = "";
        if (this.inv.price != 0) {
            string2 = Utilities.numberToString(Math.abs(this.inv.price), true, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfPrice.setString(string2);
        this.append((Item)this.tfPrice);
        this.df = new DateField("\u0414\u0430\u0442\u0430", 1);
        if (string.equals("\u041d\u043e\u0432\u0430\u044f") || string.equals("\u0426\u0435\u043d\u0430")) {
            this.inv.priceLongDate = this.parent.todayDate.getTime();
        }
        this.df.setDate(new Date(this.inv.priceLongDate + 3600000L));
        this.append((Item)this.df);
        if (bl) {
            this.append("Currency is " + this.inv.currency);
        } else {
            int n = 4;
            if (this.parent.oldStyleChoice) {
                n = 1;
            }
            this.cgCurrency = new ChoiceGroup("\u0412\u0430\u043b\u044e\u0442\u0430", n);
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            int n2 = currencyStore.getNumCurrencies();
            for (int i = 0; i < n2; ++i) {
                Currency currency = currencyStore.getCurrencyFromIndex(i);
                this.cgCurrency.append(currency.code, null);
                if (this.inv.currency.equals("")) {
                    if (!currency.code.equals(this.parent.homeCurrency)) continue;
                    this.cgCurrency.setSelectedIndex(i, true);
                    continue;
                }
                if (!currency.code.equals(this.inv.currency)) continue;
                this.cgCurrency.setSelectedIndex(i, true);
            }
            this.append((Item)this.cgCurrency);
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
    }

    Investment update() {
        this.inv.name = this.tfName.getString();
        this.inv.description = this.tfDescription.getString();
        int n = this.inv.holding;
        this.inv.holding = Utilities.holdingToNumber(this.tfHolding.getString(), n);
        n = this.inv.price;
        this.inv.price = Utilities.stringToNumber(this.tfPrice.getString(), n, true, this.parent.isEuropeanNumberFormat);
        this.inv.priceLongDate = this.df.getDate().getTime();
        this.inv.currency = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex());
        return this.inv;
    }

    Investment updatePrice() {
        int n = this.inv.price;
        this.inv.price = Utilities.stringToNumber(this.tfPrice.getString(), n, true, this.parent.isEuropeanNumberFormat);
        this.inv.priceLongDate = this.df.getDate().getTime();
        return this.inv;
    }

    String showDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }
}

