/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.CategoryView;
import JabpLite.CurrencyView;
import JabpLite.Investment;
import JabpLite.InvestmentForm;
import JabpLite.InvestmentStore;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.PreferenceForm;
import JabpLite.StandingOrderView;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class InvestmentView
extends Canvas
implements CommandListener,
Runnable {
    Investment inv;
    Investment inv1;
    Investment oldInv;
    InvestmentForm invf;
    Form debug;
    Form f1;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    ChoiceGroup cgHoldingDecimalPlaces;
    ChoiceGroup cgPriceDecimalPlaces;
    InvestmentStore is;
    Alert alert;
    Display display;
    Font font;
    PreferenceForm pf;
    JabpLite parent;
    ViewForm vl;
    boolean paintWholeScreen = true;
    boolean priceFlag = false;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int totalValue;
    int minInvestmentAmount;
    int maxInvestmentAmount;
    int spacing;
    int numberWidth;
    int holdingWidth;
    int priceWidth;
    int investmentWidth;
    int holdingsPosition;
    int pricePosition;
    int valuePosition;
    int minInvestmentWidth;
    int investmentDisplayType;
    boolean reducedHeading;
    long timePointerOnScreen;
    boolean pointerExecute;

    public InvestmentView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.priceCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.investmentSettingsCommand);
        this.addCommand(this.parent.toggleDefaultActionCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.is = new InvestmentStore(this.parent);
        this.numItems = this.is.getNumInvestments();
        this.setTotals();
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        this.androidDelay();
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.setPositions();
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        } else {
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.inv = this.is.getInvestmentFromIndex(i + this.startPos);
            this.buildLine(graphics, this.inv, this.lineHeight * i + this.lineHeight);
        }
        this.inv = this.is.getInvestmentFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.inv = this.is.getInvestmentFromIndex(this.previousPos + this.startPos);
        this.buildLine(graphics, this.inv, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.inv = this.is.getInvestmentFromIndex(this.currentPos + this.startPos);
        this.buildLine(graphics, this.inv, this.lineHeight * this.currentPos + this.lineHeight);
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        String string = "\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438";
        String string2 = "\u0412\u043a\u043b\u0430\u0434\u044b";
        if (this.reducedHeading) {
            string = "\u0418\u043d\u0432\u0435\u0441\u0442.";
            string2 = "\u0412\u043a\u043b\u0430\u0434";
        }
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString(string, this.parent.widthAdjustment, n, 20);
        graphics.drawString(string2, this.holdingsPosition + this.holdingWidth - this.font.stringWidth(string2), n, 20);
        if (this.investmentDisplayType == 0) {
            graphics.drawString("\u0426\u0435\u043d\u0430", this.pricePosition + this.priceWidth - this.font.stringWidth("\u0426\u0435\u043d\u0430"), n, 20);
        }
        graphics.drawString(" \u0421\u0442\u043e\u0438\u043c.", this.valuePosition + this.numberWidth - this.font.stringWidth(" \u0421\u0442\u043e\u0438\u043c."), n, 20);
    }

    void showFooter(Graphics graphics) {
        int n = this.height - this.lineHeight + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("\u0412\u0441\u0435\u0433\u043e", this.parent.widthAdjustment, n, 20);
        String string = Utilities.numberToString(this.totalValue, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.valuePosition + this.numberWidth - this.font.stringWidth(string), n, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void buildLine(Graphics graphics, Investment investment, int n) {
        int n2;
        int n3 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        int n4 = investment.name.length();
        for (int i = 0; i < n4; ++i) {
            n2 = n4 - i;
            if (this.font.stringWidth(investment.name.substring(0, n2)) > this.investmentWidth) continue;
            graphics.drawString(investment.name.substring(0, n2), this.parent.widthAdjustment, n3, 20);
            break;
        }
        String string = Utilities.holdingToString(investment.holding, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces);
        graphics.drawString(string, this.holdingsPosition + this.holdingWidth - this.font.stringWidth(string), n3, 20);
        if (this.investmentDisplayType == 0) {
            string = Utilities.numberToString(investment.price, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces);
            graphics.drawString(string, this.pricePosition + this.priceWidth - this.font.stringWidth(string), n3, 20);
        }
        n2 = investment.calcValue(investment);
        string = Utilities.numberToString(n2, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.valuePosition + this.numberWidth - this.font.stringWidth(string), n3, 20);
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.minInvestmentAmount < -9999999 || this.maxInvestmentAmount > 99999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("9,999,999.99") : this.font.stringWidth("9999999.99")) : (this.minInvestmentAmount < -999999 || this.maxInvestmentAmount > 9999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99")) : (this.minInvestmentAmount < -99999 || this.maxInvestmentAmount > 999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("99,999.99") : this.font.stringWidth("99999.99")) : (this.parent.isGroupingUsed ? this.font.stringWidth("9,999.99") : this.font.stringWidth("9999.99"))));
        this.holdingWidth = this.numberWidth - this.font.stringWidth(".99");
        this.priceWidth = this.font.stringWidth("999.99");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = 10;
        if (this.width > 500) {
            this.spacing = 20;
        }
        if (this.width > 640) {
            this.spacing = 30;
        }
        this.reducedHeading = false;
        this.minInvestmentWidth = this.font.stringWidth("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        this.investmentDisplayType = 0;
        this.investmentWidth = this.width - this.parent.widthAdjustment * 2 - this.holdingWidth - this.priceWidth - this.numberWidth - this.spacing * 3;
        if (this.investmentWidth < this.minInvestmentWidth) {
            this.investmentDisplayType = 1;
            this.investmentWidth += this.priceWidth + this.spacing;
        }
        this.holdingsPosition = this.investmentWidth + this.parent.widthAdjustment + this.spacing;
        if (this.investmentDisplayType == 0) {
            this.pricePosition = this.holdingsPosition + this.holdingWidth + this.spacing;
            this.valuePosition = this.pricePosition + this.priceWidth + this.spacing;
        } else {
            this.valuePosition = this.holdingsPosition + this.holdingWidth + this.spacing;
        }
        if (this.font.stringWidth("\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438") + this.parent.widthAdjustment + this.spacing > this.holdingsPosition + this.holdingWidth - this.font.stringWidth("\u0412\u043a\u043b\u0430\u0434\u044b")) {
            this.reducedHeading = true;
        }
    }

    Investment showInvestment() {
        this.oldInv = new Investment(this.parent);
        this.oldInv.clone(this.inv);
        return this.inv;
    }

    void newInvestment(Investment investment) {
        this.inv1 = investment;
        this.inv1.id = this.is.saveNewInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), 4);
        }
        if (this.inv == null) {
            this.inv = this.inv1;
        }
        ++this.numItems;
        this.totalValue += this.inv1.calcValue(this.inv1);
        this.checkMinMax(this.inv1);
        this.repaint();
    }

    void editInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.saveExistingInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.oldInv), -4);
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), 4);
        }
        this.totalValue += this.inv1.calcValue(this.inv1) - this.oldInv.calcValue(this.oldInv);
        this.checkMinMax(this.inv1);
        if (!this.inv1.name.equals(this.oldInv.name)) {
            this.is.deleteIndex(this.startPos + this.currentPos);
            this.is.addIndex(this.inv1);
        }
        this.repaint();
    }

    void deleteInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.deleteInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), -4);
        }
        this.is.deleteIndex(this.startPos + this.currentPos);
        this.totalValue -= this.inv1.calcValue(this.inv1);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void checkMinMax(Investment investment) {
        this.minInvestmentAmount = Math.min(this.minInvestmentAmount, investment.calcValue(investment));
        this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, investment.calcValue(investment));
        this.minInvestmentAmount = Math.min(this.minInvestmentAmount, this.totalValue);
        this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, this.totalValue);
    }

    void setTotals() {
        this.totalValue = 0;
        this.minInvestmentAmount = 0;
        this.maxInvestmentAmount = 0;
        if (this.numItems <= 0) {
            return;
        }
        for (int i = 0; i < this.numItems; ++i) {
            this.inv = this.is.getInvestmentFromIndex(i);
            int n = this.inv.calcValue(this.inv);
            this.totalValue += n;
            this.minInvestmentAmount = Math.min(this.minInvestmentAmount, n);
            this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, n);
        }
        this.minInvestmentAmount = Math.min(this.minInvestmentAmount, this.totalValue);
        this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, this.totalValue);
        this.inv = this.is.getInvestmentFromIndex(0);
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            if (this.parent.showMenuInvestmentView) {
                this.displayTouchScreenMenu();
                return;
            }
            if (this.numItems == 0) {
                return;
            }
            this.priceFlag = true;
            this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0426\u0435\u043d\u0430", true);
            this.invf.addCommand(this.parent.updateCommand);
            this.invf.addCommand(this.parent.cancelCommand);
            this.invf.addCommand(this.parent.exitCommand);
            this.invf.setCommandListener(this);
            this.display.setCurrent((Displayable)this.invf);
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("Record Properties");
            this.debug.append("Position " + n2 + " of " + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.is.ht.get((Object)new Short((short)s))).id;
            this.debug.append("Record ID " + n3 + "\n");
            this.debug.append("Record length " + this.is.getRecordSize(n3) + "\n");
            this.debug.append("RecordStore size " + this.is.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        this.pointerExecute = true;
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.inv = this.is.getInvestmentFromIndex(this.startPos + this.currentPos);
        this.paintWholeScreen = true;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        if (this.parent.showMenuInvestmentView) {
            this.displayTouchScreenMenu();
            return;
        }
        this.priceFlag = true;
        this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0426\u0435\u043d\u0430", true);
        this.invf.addCommand(this.parent.updateCommand);
        this.invf.addCommand(this.parent.cancelCommand);
        this.invf.addCommand(this.parent.exitCommand);
        this.invf.setCommandListener(this);
        this.display.setCurrent((Displayable)this.invf);
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("\u041c\u0435\u043d\u044e \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0439");
        this.cgtsm = new ChoiceGroup("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e", 1);
        this.cgtsm.append("\u041d\u043e\u0432\u044b\u0435 ", null);
        this.cgtsm.append("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", null);
        this.cgtsm.append("\u0426\u0435\u043d\u0430", null);
        this.cgtsm.append("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", null);
        this.cgtsm.append("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c", null);
        this.cgtsm.append("\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0440.", null);
        this.cgtsm.append("\u041f\u0435\u0440\u0435\u043a\u043b. \u043e\u043a\u043d\u043e", null);
        this.cgtsm.append("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438", null);
        this.cgtsm.append("\u041f\u0435\u0440\u0435\u043a\u043b. \u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", null);
        this.cgtsm.append("\u0412\u044b\u0445\u043e\u0434", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.invf = new InvestmentForm(this.parent, new Investment(this.parent), "\u041d\u043e\u0432\u044b\u0435 ", false);
                this.invf.addCommand(this.parent.createCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442. \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0439");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.priceFlag = false;
                this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", false);
                this.invf.addCommand(this.parent.updateCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.priceCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442. \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0439");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.priceFlag = true;
                this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0426\u0435\u043d\u0430", true);
                this.invf.addCommand(this.parent.updateCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442. \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0439");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", false);
                this.invf.addCommand(this.parent.deleteCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442. \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0439");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c", false);
                this.invf.addCommand(this.parent.okCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.investmentSettingsCommand) {
                this.f1 = new Form("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438");
                this.f1.append("\u041f\u043e\u043c\u043e\u0449\u044c \u043f\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044e \u044d\u0442\u043e\u0439 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u0441\u043c\u043e\u0442\u0440\u0438 \u0432 FAQ\n");
                n = 4;
                if (this.parent.oldStyleChoice) {
                    n = 1;
                }
                this.cgHoldingDecimalPlaces = new ChoiceGroup("\u0427\u0438\u0441\u043b\u043e \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043d\u044f\u0442\u043e\u0439 for Holdings", n);
                this.cgHoldingDecimalPlaces.append("0", null);
                this.cgHoldingDecimalPlaces.append("1", null);
                this.cgHoldingDecimalPlaces.append("2", null);
                this.cgHoldingDecimalPlaces.append("3", null);
                this.cgHoldingDecimalPlaces.setSelectedIndex(this.parent.holdingDecimalPlaces, true);
                this.f1.append((Item)this.cgHoldingDecimalPlaces);
                this.cgPriceDecimalPlaces = new ChoiceGroup("\u0427\u0438\u0441\u043b\u043e \u0437\u043d\u0430\u043a\u043e\u0432 \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043d\u044f\u0442\u043e\u0439 \u0434\u043b\u044f \u0446\u0435\u043d", n);
                this.cgPriceDecimalPlaces.append("2", null);
                this.cgPriceDecimalPlaces.append("3", null);
                this.cgPriceDecimalPlaces.append("4", null);
                this.cgPriceDecimalPlaces.append("5", null);
                this.cgPriceDecimalPlaces.setSelectedIndex(this.parent.priceDecimalPlaces - 2, true);
                this.f1.append((Item)this.cgPriceDecimalPlaces);
                this.f1.addCommand(this.parent.okCommand);
                this.f1.addCommand(this.parent.cancelCommand);
                this.f1.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.f1);
            }
            if (command == this.parent.toggleDefaultActionCommand) {
                if (this.parent.showMenuInvestmentView) {
                    this.parent.showMenuInvestmentView = false;
                    this.alert.setString("Default action: update price");
                } else {
                    this.parent.showMenuInvestmentView = true;
                    this.alert.setString("Default action: show menu");
                }
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
        }
        if (displayable == this.invf) {
            if (command == this.parent.deleteCommand) {
                this.invf = null;
                this.deleteInvestment(this.inv);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.invf = null;
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.inv1 = this.invf.update();
                if (this.inv1.name.equals("")) {
                    this.alert.setString("\u041d\u0435\u0442 \u0438\u043c\u0435\u043d\u0438 \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                if (this.is.lookUpId(this.inv1) != 0) {
                    this.alert.setString(this.inv1.name + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                this.newInvestment(this.inv1);
                this.display.setCurrent((Displayable)this);
                this.invf = null;
            }
            if (command == this.parent.updateCommand) {
                this.inv1 = this.priceFlag ? this.invf.updatePrice() : this.invf.update();
                if (this.inv1.name.equals("")) {
                    this.alert.setString("\u041d\u0435\u0442 \u0438\u043c\u0435\u043d\u0438 \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                n = this.inv.id;
                if (!this.inv1.name.equals(this.oldInv.name) && this.is.lookUpId(this.inv1) != 0) {
                    this.alert.setString(this.inv1.name + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                this.inv.id = n;
                this.editInvestment(this.inv1);
                this.display.setCurrent((Displayable)this);
                this.invf = null;
            }
            if (command == this.parent.cancelCommand) {
                this.invf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u0447. \u0437\u0430\u043f\u0438\u0441\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.f1) {
            if (command == this.parent.okCommand) {
                this.f1.removeCommand(this.parent.okCommand);
                this.f1.removeCommand(this.parent.cancelCommand);
                n = this.parent.holdingDecimalPlaces;
                int n2 = this.parent.priceDecimalPlaces;
                int n3 = this.cgHoldingDecimalPlaces.getSelectedIndex();
                int n4 = this.cgPriceDecimalPlaces.getSelectedIndex() + 2;
                this.parent.holdingDecimalPlaces = n3;
                this.parent.priceDecimalPlaces = n4;
                this.totalValue = 0;
                for (int i = 0; i < this.numItems; ++i) {
                    this.inv = this.is.getInvestmentFromIndex(i);
                    long l = this.inv.holding;
                    long l2 = Utilities.pow(10, n3);
                    long l3 = Utilities.pow(10, n);
                    l = l * l2 / l3;
                    this.inv.holding = (int)l;
                    long l4 = this.inv.price;
                    l2 = Utilities.pow(10, n4 - 2);
                    l3 = Utilities.pow(10, n2 - 2);
                    l4 = l4 * l2 / l3;
                    this.inv.price = (int)l4;
                    this.is.saveExistingInvestment(this.inv);
                    this.totalValue += this.inv.calcValue(this.inv);
                }
                this.display.setCurrent((Displayable)this);
                this.repaint();
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.f1 = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.newCommand, (Displayable)this);
                }
                if (n == 1) {
                    this.commandAction(this.parent.editCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.commandAction(this.parent.priceCommand, (Displayable)this);
                }
                if (n == 3) {
                    this.commandAction(this.parent.deleteCommand, (Displayable)this);
                }
                if (n == 4) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n == 5) {
                    this.commandAction(this.parent.mainCommand, (Displayable)this);
                }
                if (n == 6) {
                    this.commandAction(this.parent.viewCommand, (Displayable)this);
                }
                if (n == 7) {
                    this.commandAction(this.parent.investmentSettingsCommand, (Displayable)this);
                }
                if (n == 8) {
                    this.commandAction(this.parent.toggleDefaultActionCommand, (Displayable)this);
                }
                if (n == 9) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

